/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.Highlight;
import com.xmlmind.xmledit.view.HighlightSettings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class TextLocationHighlight
implements Highlight,
ActionListener {
    private DocumentView docView;
    private TextLocation textLocation;
    private Settings settings;
    private Rectangle bounds = new Rectangle();
    private int[] triangleX = new int[3];
    private int[] triangleY = new int[3];
    private Timer blinkTimer = null;
    private Color blinkColor = null;

    public TextLocationHighlight(DocumentView documentView, TextLocation textLocation, Settings settings) {
        this.docView = documentView;
        this.textLocation = textLocation;
        this.settings = settings;
        if (settings.blinkDelay > 0) {
            this.blinkTimer = new Timer(settings.blinkDelay, this);
            this.blinkTimer.setCoalesce(true);
            this.blinkColor = settings.blinkColor;
            this.blinkTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.bounds.height <= 0) {
            return;
        }
        if (!(!this.settings.blinkWhenEditable || this.docView.isEditable() && this.docView.hasFocus())) {
            return;
        }
        Graphics graphics = this.docView.getGraphics();
        if (graphics != null) {
            try {
                this.blinkColor = this.blinkColor == this.settings.blinkColor ? this.settings.color : this.settings.blinkColor;
                graphics.setColor(this.blinkColor);
                if (this.bounds.width > 1) {
                    graphics.fillPolygon(this.triangleX, this.triangleY, 3);
                } else {
                    graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height - 1);
                }
                Object var4_3 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public TextLocation getTextLocation() {
        return this.textLocation;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isAboveText() {
        return true;
    }

    public Mark getMark() {
        return this.textLocation;
    }

    public Mark getMark2() {
        return null;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle relayout() {
        this.docView.modelToView(this.textLocation.getTextNode(), this.textLocation.getOffset(), this.bounds);
        if (this.bounds.height > 0) {
            this.bounds.width = 1;
        } else {
            Rectangle rectangle = this.docView.modelToVisibleView(this.textLocation.getTextNode());
            if (rectangle != null) {
                this.bounds.x = rectangle.x;
                this.bounds.y = rectangle.y;
                this.bounds.width = 7;
                this.bounds.height = 7;
                this.triangleX[0] = rectangle.x;
                this.triangleY[0] = rectangle.y;
                this.triangleX[1] = rectangle.x + 6;
                this.triangleY[1] = rectangle.y;
                this.triangleX[2] = rectangle.x;
                this.triangleY[2] = rectangle.y + 6;
            }
        }
        return this.bounds;
    }

    public void paint(Graphics graphics) {
        if (this.bounds.height > 0) {
            graphics.setColor(this.settings.color);
            if (this.bounds.width > 1) {
                graphics.fillPolygon(this.triangleX, this.triangleY, 3);
            } else {
                graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height - 1);
            }
        }
    }

    public void dispose() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
    }

    public static class Settings
    extends HighlightSettings {
        public int blinkDelay;
        public Color blinkColor;
        public boolean blinkWhenEditable;

        public Settings() {
            this.color = Color.black;
            this.blinkDelay = -1;
            this.blinkColor = Color.black;
            this.blinkWhenEditable = false;
        }
    }
}

