/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.gadget.CollapsibleGadget;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.MenuItemSpec;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.ElementViewPart;
import com.xmlmind.xmledit.view.GadgetList;
import com.xmlmind.xmledit.view.Msg;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.view.ViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TreeView
extends GadgetContainer
implements CollapsibleGadget,
ElementView,
ElementViewPart {
    public static final Settings DEFAULT_SETTINGS = new Settings();
    protected Element element;
    protected Settings settings;
    protected boolean collapsed = false;
    private static final int OUT_OF_SIGHT = -1000000;
    private static MenuSpec menuSpec = new MenuSpec(null, new MenuItemSpec[]{new MenuItemSpec(Msg.msg("TV.collapseTree"), null, null, "collapseTree"), new MenuItemSpec(Msg.msg("TV.expandTree"), null, null, "expandTree")});

    public TreeView(Element element) {
        this(element, DEFAULT_SETTINGS);
    }

    public TreeView(Element element, Settings settings) {
        this.element = element;
        this.settings = settings;
    }

    public Node getModel() {
        return this.element;
    }

    public void getGadgets(GadgetList gadgetList, int n) {
        gadgetList.appendGadget(this);
    }

    public void detachingFromModel(Document document, int n) {
    }

    public Element getElement() {
        return this.element;
    }

    public Gadget addChildViewGadgets(NodeView nodeView, int n) {
        int n2 = this.element.indexOfChild(nodeView.getModel());
        if (n2 < 0) {
            return null;
        }
        if (this.element.getAttributeCount() > 0) {
            ++n2;
        }
        this.insertChild(n2, (Gadget)((Object)nodeView));
        return this;
    }

    public Gadget removeChildViewGadgets(NodeView nodeView, int n) {
        this.removeChild((Gadget)((Object)nodeView));
        return this;
    }

    public NodeView getView() {
        return this;
    }

    public ElementView getElementView() {
        return this;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isCollapsible() {
        return this.children.length > 0;
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void getSizeConstraints(Gadget gadget, Dimension dimension) {
        if (this.parent != null) {
            this.parent.getSizeConstraints(this, dimension);
            if (dimension.width > 0) {
                dimension.width -= TreeViewFactory.Settings.collapseBitmapWidth + this.settings.indent;
            }
            dimension.height = -1;
        }
    }

    public void layout(int n, int n2, boolean bl) {
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n4 = fontMetrics.charWidth('x');
        int n5 = TreeViewFactory.Settings.collapseBitmapWidth + 5;
        int n6 = TreeViewFactory.Settings.collapseBitmapHeight;
        if (this.settings.icon != null) {
            n5 += n4 + this.settings.icon.getHeight(null);
            n6 = Math.max(n6, this.settings.icon.getHeight(null));
        }
        if (this.settings.label != null) {
            n5 += n4 + fontMetrics.stringWidth(this.settings.label);
            n6 = Math.max(n6, n3);
        }
        if (this.settings.autoLabel) {
            String string = this.element.getName().format(false, this.element);
            n5 += n4 + fontMetrics.stringWidth(string);
            n6 = Math.max(n6, n3);
        }
        n5 += n4;
        if (this.collapsed) {
            int n7 = 0;
            while (n7 < this.children.length) {
                Gadget gadget = this.children[n7];
                if (bl) {
                    gadget.layout(n, -1, true);
                }
                gadget.y = -1000000;
                gadget.x = -1000000;
                ++n7;
            }
        } else {
            int n8 = TreeViewFactory.Settings.collapseBitmapWidth + this.settings.indent;
            if (n > 0) {
                n -= n8;
            }
            int n9 = 0;
            while (n9 < this.children.length) {
                Gadget gadget = this.children[n9];
                if (bl) {
                    gadget.layout(n, -1, true);
                }
                gadget.x = n8;
                gadget.y = n6 += this.settings.gap;
                n6 += gadget.height;
                int n10 = n8 + gadget.width;
                if (n10 > n5) {
                    n5 = n10;
                }
                ++n9;
            }
        }
        this.width = n5;
        this.height = n6;
    }

    public void paintRelayout(Gadget gadget, int n, int n2, int n3, int n4) {
        if (this.collapsed) {
            return;
        }
        if (gadget.height == n2 && gadget.x + n < this.width && gadget.x + gadget.width <= this.width) {
            int n5 = n3 == 4 ? gadget.x + gadget.width - n4 : gadget.x;
            this.repaint(n5, gadget.y, this.width - n5, gadget.height);
            return;
        }
        if (gadget.width == n) {
            int n6 = gadget.height - n2;
            int n7 = this.indexOfChild(gadget) + 1;
            while (n7 < this.children.length) {
                this.children[n7].y += n6;
                ++n7;
            }
            this.height += n6;
            int n8 = n3 == 2 ? gadget.y + gadget.height - n4 : gadget.y;
            this.parent.paintRelayout(this, this.width, this.height - n6, 2, this.height - n8);
            return;
        }
        super.paintRelayout(gadget, n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        if (this.settings.backgroundColor != null) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.settings.backgroundColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintHead(graphics);
        if (!this.collapsed) {
            this.paintArcs(graphics);
            super.paint(graphics);
        }
    }

    private void paintHead(Graphics graphics) {
        PaintUtil.configureTextRendering(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.settings.font);
        int n = fontMetrics.getAscent();
        int n2 = n + fontMetrics.getDescent();
        int n3 = fontMetrics.charWidth('x');
        int n4 = TreeViewFactory.Settings.collapseBitmapHeight;
        if (this.settings.icon != null) {
            n4 = Math.max(n4, this.settings.icon.getHeight(null));
        }
        if (this.settings.label != null) {
            n4 = Math.max(n4, n2);
        }
        if (this.settings.autoLabel) {
            n4 = Math.max(n4, n2);
        }
        int n5 = TreeViewFactory.Settings.collapseBitmapWidth / 2;
        int n6 = n4 / 2;
        graphics.setColor(this.settings.arcColor);
        if (this.children.length == 0) {
            graphics.drawLine(n5, 0, n5, n6);
            if (this.element.getNextSibling() != null) {
                graphics.drawLine(n5, n6, n5, this.height - 1);
            }
            int n7 = TreeViewFactory.Settings.collapseBitmapWidth + 5;
            graphics.drawLine(n5, n6, n7 - 1, n6);
            n5 = n7 + n3;
        } else {
            Image image = this.collapsed ? this.settings.expandIcon : this.settings.collapseIcon;
            int n8 = n6 - TreeViewFactory.Settings.collapseBitmapHeight / 2;
            graphics.drawImage(image, 0, n8, null);
            graphics.drawLine(n5, 0, n5, n8 - 1);
            if (this.element.getNextSibling() != null) {
                graphics.drawLine(n5, n8 + TreeViewFactory.Settings.collapseBitmapHeight, n5, this.height - 1);
            }
            int n9 = TreeViewFactory.Settings.collapseBitmapWidth + 5;
            graphics.drawLine(TreeViewFactory.Settings.collapseBitmapWidth, n6, n9 - 1, n6);
            n5 = n9 + n3;
        }
        if (this.settings.icon != null) {
            graphics.drawImage(this.settings.icon, n5, n6 - this.settings.icon.getHeight(null) / 2, null);
            n5 += this.settings.icon.getWidth(null) + n3;
        }
        graphics.setColor(this.settings.textColor);
        graphics.setFont(this.settings.font);
        n6 = n6 - n2 / 2 + n;
        if (this.settings.label != null) {
            graphics.drawString(this.settings.label, n5, n6);
            n5 += fontMetrics.stringWidth(this.settings.label) + n3;
        }
        if (this.settings.autoLabel) {
            String string = this.element.getName().format(false, this.element);
            graphics.drawString(string, n5, n6);
        }
    }

    private void paintArcs(Graphics graphics) {
        if (this.children.length <= 1) {
            return;
        }
        graphics.setColor(this.settings.arcColor);
        Gadget gadget = this.children[0];
        int n = gadget.x + TreeViewFactory.Settings.collapseBitmapWidth / 2;
        int n2 = gadget.y + gadget.height;
        int n3 = 1;
        while (n3 < this.children.length) {
            gadget = this.children[n3];
            graphics.drawLine(n, n2, n, gadget.y - 1);
            n2 = gadget.y + gadget.height;
            ++n3;
        }
    }

    public void print(Graphics graphics) {
        this.paintHead(graphics);
        if (!this.collapsed) {
            this.paintArcs(graphics);
            super.print(graphics);
        }
    }

    public int[] getNonBreakableVerticalRanges() {
        int n = this.collapsed || this.children.length == 0 ? this.height - 1 : this.children[0].y - 1;
        return new int[]{0, n};
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        if (this.children.length == 0) {
            return false;
        }
        if (mouseEvent.getX() >= TreeViewFactory.Settings.collapseBitmapWidth + 5 || mouseEvent.getY() >= (this.collapsed ? this.height : this.children[0].y)) {
            return false;
        }
        int n = mouseEvent.getModifiers();
        return n == 16 || n == 4 || PlatformUtil.IS_MAC_OS && n == 18;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (n == 16 && mouseEvent.getID() == 500) {
            this.collapsed = !this.collapsed;
            this.refresh();
        } else if ((n == 4 || PlatformUtil.IS_MAC_OS && n == 18) && mouseEvent.getID() == 501) {
            this.showMenu(menuSpec, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        if (string.equals("collapseTree")) {
            TreeView.collapseTree(this, true);
            this.refresh();
        } else if (string.equals("expandTree")) {
            TreeView.collapseTree(this, false);
            this.refresh();
        }
        return null;
    }

    private static void collapseTree(GadgetContainer gadgetContainer, boolean bl) {
        CollapsibleGadget collapsibleGadget;
        Gadget[] gadgetArray = gadgetContainer.getChildren();
        int n = 0;
        while (n < gadgetArray.length) {
            if (gadgetArray[n] instanceof GadgetContainer) {
                TreeView.collapseTree((GadgetContainer)gadgetArray[n], bl);
            }
            ++n;
        }
        if (gadgetContainer instanceof CollapsibleGadget && (collapsibleGadget = (CollapsibleGadget)((Object)gadgetContainer)).isCollapsible()) {
            collapsibleGadget.setCollapsed(bl);
        }
    }

    public static class Settings
    extends ViewSettings {
        public int indent;
        public int gap;
        public Image collapseIcon;
        public Image expandIcon;

        public Settings() {
            this.backgroundColor = Color.white;
            this.textColor = Color.black;
            this.arcColor = Color.gray;
            this.font = new Font("SansSerif", 0, 10);
            this.icon = null;
            this.label = null;
            this.autoLabel = true;
            this.indent = 10;
            this.gap = 5;
            this.collapseIcon = TreeViewFactory.Settings.collapseBitmap.getImage(this.arcColor);
            this.expandIcon = TreeViewFactory.Settings.expandBitmap.getImage(this.arcColor);
        }
    }
}

