/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.PreserveSpaceDefaultValue;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Bitmap;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.view.AttributeOutline;
import com.xmlmind.xmledit.view.AttributeView;
import com.xmlmind.xmledit.view.CharView;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.Outline;
import com.xmlmind.xmledit.view.TextNodeOutline;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TreeView;
import com.xmlmind.xmledit.view.ViewFactory;
import com.xmlmind.xmledit.view.WordView;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Color;
import java.awt.Image;

public class TreeViewFactory
extends ViewFactory {
    protected Settings settings = new Settings();
    protected DocumentType docType;
    protected boolean isUnconstrainedDocType;
    static /* synthetic */ Class class$com$xmlmind$xmledit$view$TreeViewFactory;

    public TreeViewFactory(DocumentView documentView) {
        super(documentView);
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        if (document != null) {
            this.docType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
            if (this.docType == null) {
                this.docType = UnconstrainedDocumentType.INSTANCE;
            }
            this.isUnconstrainedDocType = this.docType instanceof UnconstrainedDocumentType;
        }
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.applySettings();
    }

    public void applySettings() {
        if (this.doc != null) {
            this.docView.rebuildView(this.doc.getRootElement());
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public int elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        if (this.settings.showText && elementAttributeEvent.getName() == Name.XML_SPACE) {
            return 2;
        }
        int n2 = elementAttributeEvent.getElementSource().getAttributeCount();
        switch (elementAttributeEvent.getId()) {
            case 20: {
                if (n2 != 1) break;
                return 2;
            }
            case 22: {
                if (n2 != 0) break;
                return 2;
            }
        }
        return 1;
    }

    public ElementView createElementView(Element element, ElementView elementView) {
        TreeView treeView = new TreeView(element, this.settings.elementSettings);
        if (element.getAttributeCount() > 0) {
            Gadget gadget = this.settings.showAttribute ? new AttributeView(element, this.settings.attributeSettings) : new AttributeOutline(element, this.settings.attributeOutlineSettings);
            treeView.insertChild(0, gadget);
        }
        return treeView;
    }

    public TextNodeView createTextView(Text text, ElementView elementView) {
        String string;
        if (!this.settings.showText) {
            return new TextNodeOutline(text, this.settings.textOutlineSettings);
        }
        Element element = (Element)text.getParent();
        boolean bl = this.isUnconstrainedDocType ? element.hasPreserveSpace() : ((string = this.docType.lookupElementAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE)) == null ? false : string.trim().equals("preserve"));
        if (bl) {
            return new CharView(text, this.settings.preformattedTextSettings);
        }
        return new WordView(text, this.settings.textSettings);
    }

    public TextNodeView createCommentView(Comment comment, ElementView elementView) {
        if (this.settings.showComment) {
            return new CharView(comment, this.settings.commentSettings);
        }
        return new TextNodeOutline(comment, this.settings.commentOutlineSettings);
    }

    public TextNodeView createProcessingInstructionView(ProcessingInstruction processingInstruction, ElementView elementView) {
        if (this.settings.showPI) {
            return new CharView(processingInstruction, this.settings.piSettings);
        }
        return new TextNodeOutline(processingInstruction, this.settings.piOutlineSettings);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Settings {
        public static final Bitmap collapseBitmap = new Bitmap(9, 9, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1, 125, 1, 1, 1, 1, 1, 1, 1, -1, 1});
        public static final int collapseBitmapWidth = collapseBitmap.getWidth();
        public static final int collapseBitmapHeight = collapseBitmap.getHeight();
        public static final Bitmap expandBitmap = new Bitmap(9, 9, new byte[]{-1, 1, 1, 1, 17, 1, 17, 1, 125, 1, 17, 1, 17, 1, 1, 1, -1, 1});
        public static final int arcIndent = 5;
        public static Image elementIcon = ImageResource.get(class$com$xmlmind$xmledit$view$TreeViewFactory == null ? (class$com$xmlmind$xmledit$view$TreeViewFactory = TreeViewFactory.class$("com.xmlmind.xmledit.view.TreeViewFactory")) : class$com$xmlmind$xmledit$view$TreeViewFactory, "element.gif");
        public static Image attributeIcon = ImageResource.get(class$com$xmlmind$xmledit$view$TreeViewFactory == null ? (class$com$xmlmind$xmledit$view$TreeViewFactory = TreeViewFactory.class$("com.xmlmind.xmledit.view.TreeViewFactory")) : class$com$xmlmind$xmledit$view$TreeViewFactory, "attribute.gif");
        public static Image textIcon = ImageResource.get(class$com$xmlmind$xmledit$view$TreeViewFactory == null ? (class$com$xmlmind$xmledit$view$TreeViewFactory = TreeViewFactory.class$("com.xmlmind.xmledit.view.TreeViewFactory")) : class$com$xmlmind$xmledit$view$TreeViewFactory, "text.gif");
        public static Image commentIcon = ImageResource.get(class$com$xmlmind$xmledit$view$TreeViewFactory == null ? (class$com$xmlmind$xmledit$view$TreeViewFactory = TreeViewFactory.class$("com.xmlmind.xmledit.view.TreeViewFactory")) : class$com$xmlmind$xmledit$view$TreeViewFactory, "comment.gif");
        public static Image piIcon = ImageResource.get(class$com$xmlmind$xmledit$view$TreeViewFactory == null ? (class$com$xmlmind$xmledit$view$TreeViewFactory = TreeViewFactory.class$("com.xmlmind.xmledit.view.TreeViewFactory")) : class$com$xmlmind$xmledit$view$TreeViewFactory, "pi.gif");
        public TreeView.Settings elementSettings = new TreeView.Settings();
        public AttributeView.Settings attributeSettings;
        public Outline.Settings attributeOutlineSettings;
        public WordView.Settings textSettings;
        public CharView.Settings preformattedTextSettings;
        public Outline.Settings textOutlineSettings;
        public CharView.Settings commentSettings;
        public Outline.Settings commentOutlineSettings;
        public CharView.Settings piSettings;
        public Outline.Settings piOutlineSettings;
        public boolean showAttribute;
        public boolean showText;
        public boolean showComment;
        public boolean showPI;

        public Settings() {
            this.elementSettings.icon = elementIcon;
            this.attributeSettings = new AttributeView.Settings();
            this.attributeOutlineSettings = new Outline.Settings();
            this.attributeOutlineSettings.icon = attributeIcon;
            this.textSettings = new WordView.Settings();
            this.preformattedTextSettings = new CharView.Settings();
            this.textOutlineSettings = new Outline.Settings();
            this.textOutlineSettings.icon = textIcon;
            this.commentSettings = new CharView.Settings();
            this.commentSettings.borderColor = new Color(128, 128, 0);
            this.commentSettings.contentBackgroundColor = new Color(255, 255, 192);
            this.commentOutlineSettings = new Outline.Settings();
            this.commentOutlineSettings.icon = commentIcon;
            this.piSettings = new CharView.Settings();
            this.piSettings.autoLabel = true;
            this.piSettings.borderColor = new Color(0, 128, 0);
            this.piSettings.contentBackgroundColor = new Color(192, 255, 192);
            this.piOutlineSettings = new Outline.Settings();
            this.piOutlineSettings.icon = piIcon;
            this.showAttribute = false;
            this.showText = false;
            this.showComment = false;
            this.showPI = false;
        }
    }
}

