/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.view;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.view.GadgetList;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.Outline;
import com.xmlmind.xmledit.view.RectangleList;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmledit.view.ViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WordView
extends Gadget
implements TextNodeView,
TextNodeViewText {
    private TextNode text;
    private Settings settings;
    private int[] lineLayout = new int[0];
    private short textLeft;
    private short textTop;

    public WordView(TextNode textNode, Settings settings) {
        this.text = textNode;
        this.settings = settings;
    }

    public Node getModel() {
        return this.text;
    }

    public void getGadgets(GadgetList gadgetList, int n) {
        gadgetList.appendGadget(this);
    }

    public void detachingFromModel(Document document, int n) {
    }

    public TextNode getTextNode() {
        return this.text;
    }

    public void getTextGadgets(GadgetList gadgetList, int n) {
        gadgetList.appendGadget(this);
    }

    public boolean acceptsControlChar(char c) {
        return false;
    }

    public NodeView getView() {
        return this;
    }

    public TextNodeView getTextNodeView() {
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void layout(int n, int n2, boolean bl) {
        int n3 = this.settings.margin + 1 + this.settings.pad;
        this.textLeft = (short)(TreeViewFactory.Settings.collapseBitmapWidth + 5 + n3);
        if (Outline.hasOutline(this.settings)) {
            Dimension dimension = Outline.computeSize(this, this.settings, this.text);
            this.textTop = (short)(dimension.height + n3);
            if (n > 0 && dimension.width > n) {
                n = dimension.width;
            }
        } else {
            this.textTop = (short)(Math.max(TreeViewFactory.Settings.collapseBitmapHeight / 2, this.settings.margin) + 1 + this.settings.pad);
        }
        this.relayoutLines(n, 0);
    }

    private int relayoutLines(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = new int[10];
        int n7 = 0;
        if (this.lineLayout.length <= 2) {
            n2 = 0;
        } else {
            n6 = 2;
            while (true) {
                if (n6 == this.lineLayout.length || this.lineLayout[n6] > n2) {
                    n2 = this.lineLayout[n6 - 2];
                    break;
                }
                nArray = WordView.addLineLayout(nArray, n7, this.lineLayout[n6 - 2], this.lineLayout[n6 - 1]);
                n7 += 2;
                n6 += 2;
            }
        }
        n6 = n7 / 2;
        char[] cArray = this.text.getTextChars();
        int n8 = this.text.getTextLength();
        int n9 = this.settings.pad + 1 + this.settings.margin;
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int[] nArray2 = fontMetrics.getWidths();
        int n10 = n5 = n > 0 ? n - this.textLeft - n9 : Integer.MAX_VALUE;
        if (n5 <= 0) {
            n5 = 1;
        }
        int n11 = n2;
        int n12 = 0;
        int n13 = -1;
        int n14 = 0;
        int n15 = n2;
        while (n15 < n8) {
            n4 = cArray[n15];
            int n16 = n3 = n4 < 256 ? nArray2[n4] : fontMetrics.charWidth((char)n4);
            if (n3 == 0) {
                n3 = PaintUtil.defaultCharWidth(fontMetrics);
            }
            switch (n4) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (n13 >= 0) {
                        n13 = -1;
                        n12 += n14;
                        n14 = 0;
                    }
                    if (n12 + n3 > n5 && n12 > 0) {
                        nArray = WordView.addLineLayout(nArray, n7, n11, n12);
                        n7 += 2;
                        n11 = n15 + 1;
                        n12 = 0;
                        break;
                    }
                    n12 += n3;
                    break;
                }
                default: {
                    if (n13 < 0) {
                        n13 = n15;
                    }
                    if (n12 + (n14 += n3) <= n5 || n12 <= 0) break;
                    nArray = WordView.addLineLayout(nArray, n7, n11, n12);
                    n7 += 2;
                    n11 = n13;
                    n12 = 0;
                }
            }
            ++n15;
        }
        if (n12 + n14 > 0) {
            nArray = WordView.addLineLayout(nArray, n7, n11, n12 + n14);
            n7 += 2;
        }
        this.lineLayout = new int[n7];
        System.arraycopy(nArray, 0, this.lineLayout, 0, n7);
        n4 = 0;
        n3 = 1;
        while (n3 < n7) {
            if (nArray[n3] > n4) {
                n4 = nArray[n3];
            }
            n3 += 2;
        }
        this.width = this.textLeft + n4 + n9;
        this.height = this.textTop + (fontMetrics.getAscent() + fontMetrics.getDescent()) + n9;
        int n17 = n7 / 2;
        if (n17 > 1) {
            this.height += (n17 - 1) * fontMetrics.getHeight();
        }
        if (n > 0 && this.width < n) {
            this.width = n;
        }
        return n6;
    }

    private static final int[] addLineLayout(int[] nArray, int n, int n2, int n3) {
        if (n + 2 > nArray.length) {
            int[] nArray2 = new int[Math.max(n + 2, 2 * nArray.length)];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        nArray[n] = n2;
        nArray[n + 1] = n3;
        return nArray;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.settings.backgroundColor != null) {
            graphics.setColor(this.settings.backgroundColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        int n3 = TreeViewFactory.Settings.collapseBitmapWidth + 5 + this.settings.margin;
        if (Outline.hasOutline(this.settings)) {
            n2 = Outline.paintOutline(this, this.settings, this.text, graphics);
            n = n2 + this.settings.margin;
        } else {
            n2 = Math.max(TreeViewFactory.Settings.collapseBitmapHeight / 2, this.settings.margin);
            Outline.paintArc(this, this.settings, this.text, 2 * n2, graphics);
            n = n2;
        }
        n2 = this.width - n3 - this.settings.margin;
        int n4 = this.height - n - this.settings.margin;
        if (this.settings.contentBackgroundColor != null) {
            graphics.setColor(this.settings.contentBackgroundColor);
            graphics.fillRect(n3, n, n2, n4);
        }
        if (this.settings.borderColor != null) {
            graphics.setColor(this.settings.borderColor);
            graphics.drawRect(n3, n, n2 - 1, n4 - 1);
        }
    }

    public void paintText(Graphics graphics) {
        int n = this.lineLayout.length / 2;
        if (n == 0) {
            return;
        }
        char[] cArray = this.text.getTextChars();
        int n2 = this.text.getTextLength();
        PaintUtil.configureTextRendering(graphics);
        graphics.setColor(this.settings.textColor);
        graphics.setFont(this.settings.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.settings.font);
        int n3 = fontMetrics.getHeight();
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = rectangle.y - this.textTop + fontMetrics.getLeading();
        int n5 = n4 / n3;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= n) {
            n5 = n - 1;
        }
        int n6 = (n4 += rectangle.height - 1) / n3;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 >= n) {
            n6 = n - 1;
        }
        int n7 = this.textTop + fontMetrics.getAscent() + n5 * n3;
        int n8 = n5;
        while (n8 <= n6) {
            int n9 = this.lineLayout[2 * n8];
            int n10 = n8 < n - 1 ? this.lineLayout[2 * (n8 + 1)] - 1 : n2;
            PaintUtil.drawChars(graphics, fontMetrics, cArray, n9, n10 - n9, this.textLeft, n7);
            n7 += n3;
            ++n8;
        }
    }

    public int gadgetToModel(int n, int n2) {
        int n3 = this.lineLayout.length / 2;
        if (n3 == 0) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n4 = fontMetrics.getHeight();
        int n5 = (n2 = n2 - this.textTop + fontMetrics.getLeading()) / n4;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= n3) {
            n5 = n3 - 1;
        }
        n -= this.textLeft;
        char[] cArray = this.text.getTextChars();
        int n6 = this.text.getTextLength();
        int n7 = this.lineLayout[2 * n5];
        int n8 = n5 < n3 - 1 ? this.lineLayout[2 * (n5 + 1)] - 1 : n6;
        int n9 = n7;
        int n10 = n8 - n7;
        while (n10 > 1) {
            int n11 = n10 / 2;
            int n12 = PaintUtil.charsWidth(fontMetrics, cArray, n9, n11);
            if (n < n12) {
                n10 = n11;
                continue;
            }
            n -= n12;
            n9 += n11;
            n10 -= n11;
        }
        if (n >= PaintUtil.charWidth(fontMetrics, cArray[n9]) / 2) {
            ++n9;
        }
        return n9;
    }

    public int modelToGadget(int n, int n2, RectangleList rectangleList) {
        int n3;
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n4 = fontMetrics.getHeight();
        int n5 = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n6 = this.lineLayout.length / 2;
        if (n6 == 0) {
            rectangleList.appendRectangle(this.textLeft, this.textTop, 0, n5);
            return 1;
        }
        char[] cArray = this.text.getTextChars();
        int n7 = this.text.getTextLength();
        if (n < 0) {
            n = 0;
        } else if (n > n7) {
            n = n7;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n + n2 > n7) {
            n2 = n7 - n;
        }
        int n8 = 0;
        while (n8 < n6) {
            n3 = n8 < n6 - 1 ? this.lineLayout[2 * (n8 + 1)] - 1 : n7;
            if (n <= n3) {
                if (n2 != 0) break;
                int n9 = this.lineLayout[2 * n8];
                int n10 = this.textLeft + PaintUtil.charsWidth(fontMetrics, cArray, n9, n - n9);
                rectangleList.appendRectangle(n10, this.textTop + n8 * n4, 0, n5);
                return 1;
            }
            ++n8;
        }
        n3 = 0;
        while (n8 < n6) {
            int n11;
            int n12;
            int n13 = this.lineLayout[2 * n8];
            if (n8 < n6 - 1) {
                n12 = this.lineLayout[2 * (n8 + 1)];
                n11 = n12 - 1;
            } else {
                n12 = n11 = n7;
            }
            int n14 = n > n13 ? this.textLeft + PaintUtil.charsWidth(fontMetrics, cArray, n13, n - n13) : this.textLeft;
            int n15 = n14 + PaintUtil.charsWidth(fontMetrics, cArray, n, n + n2 <= n11 ? n2 : n11 - n);
            rectangleList.appendRectangle(n14, this.textTop + n8 * n4, n15 - n14, n5);
            ++n3;
            int n16 = n;
            n = n12;
            if ((n2 -= n12 - n16) <= 0) break;
            ++n8;
        }
        return n3;
    }

    public void charInserted(char c, int n) {
        int n2;
        if (this.lineLayout.length == 0) {
            this.refreshFrom(0);
            return;
        }
        int n3 = WordView.layoutIndexOfChar(this.lineLayout, n);
        if (n3 != 0 && WordView.isXMLSpace(c) && n <= (n2 = WordView.findWordEnd(this.text.getTextChars(), this.text.getTextLength(), this.lineLayout[n3]))) {
            this.refreshFrom(this.lineLayout[n3 - 2]);
            return;
        }
        n2 = this.settings.pad + 1 + this.settings.margin;
        int n4 = this.lineLayout[n3 + 1];
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n5 = PaintUtil.charWidth(fontMetrics, c);
        if (n4 + n5 <= this.width - this.textLeft - n2) {
            int n6 = n3 + 1;
            this.lineLayout[n6] = this.lineLayout[n6] + n5;
            int n7 = n3 + 2;
            while (n7 < this.lineLayout.length) {
                int n8 = n7;
                this.lineLayout[n8] = this.lineLayout[n8] + 1;
                n7 += 2;
            }
            int n9 = this.textTop + n3 / 2 * fontMetrics.getHeight();
            int n10 = fontMetrics.getAscent() + fontMetrics.getDescent();
            this.repaint(0, n9, this.width, n10);
            return;
        }
        this.refreshFrom(n);
    }

    private static final int layoutIndexOfChar(int[] nArray, int n) {
        if (nArray.length <= 2) {
            return 0;
        }
        int n2 = 2;
        while (n2 != nArray.length && nArray[n2] <= n) {
            n2 += 2;
        }
        return n2 - 2;
    }

    private static final boolean isXMLSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static final int findWordEnd(char[] cArray, int n, int n2) {
        while (n2 < n && WordView.isXMLSpace(cArray[n2])) {
            ++n2;
        }
        while (n2 < n && !WordView.isXMLSpace(cArray[n2])) {
            ++n2;
        }
        return n2;
    }

    public void charDeleted(char c, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.text.getTextLength();
        if (n6 == 0) {
            this.refreshFrom(0);
            return;
        }
        int n7 = WordView.layoutIndexOfChar(this.lineLayout, n);
        char[] cArray = this.text.getTextChars();
        if (n7 != 0 && n <= (n5 = WordView.findWordEnd(cArray, n6, this.lineLayout[n7]))) {
            this.refreshFrom(this.lineLayout[n7 - 2]);
            return;
        }
        if (n7 < this.lineLayout.length - 2 && n == this.lineLayout[n7 + 2] - 1) {
            this.refreshFrom(n);
            return;
        }
        n5 = this.settings.pad + 1 + this.settings.margin;
        int n8 = this.lineLayout[n7 + 1];
        FontMetrics fontMetrics = this.getFontMetrics(this.settings.font);
        int n9 = PaintUtil.charWidth(fontMetrics, c);
        if (n8 - n9 + (n4 = n7 == this.lineLayout.length - 2 ? this.width : PaintUtil.charsWidth(fontMetrics, cArray, n3, (n2 = WordView.findNextSpace(cArray, n6, n3 = this.lineLayout[n7 + 2])) >= n6 ? n6 - n3 : n2 - n3 + 1)) >= this.width - this.textLeft - n5) {
            int n10 = n7 + 1;
            this.lineLayout[n10] = this.lineLayout[n10] - n9;
            n3 = n7 + 2;
            while (n3 < this.lineLayout.length) {
                int n11 = n3;
                this.lineLayout[n11] = this.lineLayout[n11] - 1;
                n3 += 2;
            }
            n2 = this.textTop + n7 / 2 * fontMetrics.getHeight();
            int n12 = fontMetrics.getAscent() + fontMetrics.getDescent();
            this.repaint(0, n2, this.width, n12);
            return;
        }
        this.refreshFrom(n);
    }

    private static final int findNextSpace(char[] cArray, int n, int n2) {
        while (n2 < n && !WordView.isXMLSpace(cArray[n2])) {
            ++n2;
        }
        return n2;
    }

    private void refreshFrom(int n) {
        if (this.parent == null) {
            return;
        }
        int n2 = this.width;
        int n3 = this.height;
        Dimension dimension = new Dimension();
        this.parent.getSizeConstraints(this, dimension);
        int n4 = dimension.width;
        if (n4 > 0 && Outline.hasOutline(this.settings)) {
            Outline.computeSize(this, this.settings, this.text, dimension);
            if (dimension.width > n4) {
                n4 = dimension.width;
            }
        }
        int n5 = this.relayoutLines(n4, n);
        if (this.width == n2 && this.height == n3) {
            int n6 = this.getFontMetrics(this.settings.font).getHeight();
            int n7 = this.textTop + n5 * n6;
            this.repaint(0, n7, this.width, this.height - n7);
        } else {
            int n8;
            int n9;
            if (this.width == n2) {
                int n10 = this.getFontMetrics(this.settings.font).getHeight();
                int n11 = this.textTop + n5 * n10;
                n9 = 2;
                n8 = this.height - n11;
            } else {
                n9 = 0;
                n8 = -1;
            }
            this.parent.paintRelayout(this, n2, n3, n9, n8);
        }
    }

    public static class Settings
    extends ViewSettings {
        public int margin;
        public Color borderColor;
        public int pad;
        public Color contentBackgroundColor;

        public Settings() {
            this.backgroundColor = null;
            this.textColor = Color.black;
            this.arcColor = Color.gray;
            this.font = new Font("SansSerif", 0, 10);
            this.icon = null;
            this.label = null;
            this.autoLabel = false;
            this.margin = 2;
            this.borderColor = Color.gray;
            this.pad = 2;
            this.contentBackgroundColor = Color.white;
        }
    }
}

