/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xmlutil;

import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.XMLUtil;

public final class ElementXPointer {
    private String id;
    private int[] descendant;

    public static ElementXPointer parse(String string) {
        ElementXPointer elementXPointer;
        if (string.indexOf(40) < 0) {
            if (!XMLUtil.isName(string)) {
                return null;
            }
            elementXPointer = new ElementXPointer(string);
        } else {
            int n = string.indexOf("element(");
            if (n < 0) {
                return null;
            }
            int n2 = string.indexOf(41, n);
            if (n2 < 0) {
                return null;
            }
            String string2 = string.substring(n + 8, n2);
            elementXPointer = ElementXPointer.parseElementSchemeData(string2);
        }
        return elementXPointer;
    }

    private static final ElementXPointer parseElementSchemeData(String string) {
        Object object;
        String[] stringArray = StringUtil.split(string, '/');
        Object object2 = null;
        int[] nArray = new int[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            if (n2 == 0) {
                if (((String)object).length() > 0 && !XMLUtil.isName((String)(object2 = object))) {
                    return null;
                }
            } else {
                int n3;
                try {
                    n3 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = -1;
                }
                if (n3 <= 0) {
                    return null;
                }
                nArray[n++] = n3;
            }
            ++n2;
        }
        if (object2 == null && n == 0) {
            return null;
        }
        object = new int[n];
        System.arraycopy(nArray, 0, object, 0, n);
        return new ElementXPointer((String)object2, (int[])object);
    }

    public ElementXPointer(String string) {
        this(string, null);
    }

    public ElementXPointer(String string, int[] nArray) {
        this.id = string;
        this.descendant = nArray == null ? new int[]{} : nArray;
    }

    public String getId() {
        return this.id;
    }

    public int[] getDescendant() {
        return this.descendant;
    }

    public boolean isRootElement() {
        return this.id == null && this.descendant.length == 1 && this.descendant[0] == 1;
    }

    public String toString() {
        if (this.descendant.length == 0) {
            return this.id;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("element(");
        if (this.id != null) {
            stringBuffer.append(this.id);
        }
        int n = 0;
        while (n < this.descendant.length) {
            stringBuffer.append('/');
            stringBuffer.append(Integer.toString(this.descendant[n]));
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

