/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xmlutil;

import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public final class PreferredPrefix
implements NamespacePrefixMap {
    public static final PreferredPrefix INSTANCE = new PreferredPrefix();
    private HashMap prefixTONS;
    private IdentityHashMap nsToPrefix;
    private Namespace defaultNamespace = null;
    private String[] prefixe1 = new String[1];
    private String[] prefixe2 = new String[2];

    public PreferredPrefix() {
        this(null);
    }

    public PreferredPrefix(PrefixEntry[] prefixEntryArray) {
        this.prefixTONS = new HashMap();
        this.nsToPrefix = new IdentityHashMap();
        if (prefixEntryArray != null) {
            int n = 0;
            while (n < prefixEntryArray.length) {
                PrefixEntry prefixEntry = prefixEntryArray[n];
                this.add(prefixEntry.namespace, prefixEntry.prefix);
                ++n;
            }
        }
    }

    public String add(Namespace namespace, String string) {
        String string2;
        String string3 = (String)this.nsToPrefix.get(namespace);
        if (string3 != null) {
            return string3;
        }
        if (namespace == Namespace.NONE || namespace == Namespace.XML || !XMLUtil.isNCName(string) || string.regionMatches(true, 0, "xml", 0, 3)) {
            return null;
        }
        Namespace namespace2 = (Namespace)this.prefixTONS.get(string);
        if (namespace2 == null) {
            string2 = string;
        } else {
            int n = string.length();
            int n2 = -1;
            Iterator iterator = this.nsToPrefix.values().iterator();
            while (iterator.hasNext()) {
                int n3;
                String string4 = (String)iterator.next();
                if (string4.indexOf(string) != 0 || string4.length() == n) continue;
                try {
                    n3 = Integer.parseInt(string4.substring(n));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = -1;
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            string2 = string + Integer.toString(n2 + 1);
        }
        this.nsToPrefix.put(namespace, string2);
        this.prefixTONS.put(string2, namespace);
        return string2;
    }

    public Namespace remove(String string) {
        Namespace namespace = (Namespace)this.prefixTONS.remove(string);
        if (namespace != null) {
            this.nsToPrefix.remove(namespace);
            if (namespace == this.defaultNamespace) {
                this.defaultNamespace = null;
            }
        }
        return namespace;
    }

    public String remove(Namespace namespace) {
        String string = (String)this.nsToPrefix.remove(namespace);
        if (string != null) {
            this.prefixTONS.remove(string);
            if (namespace == this.defaultNamespace) {
                this.defaultNamespace = null;
            }
        }
        return string;
    }

    public void clear() {
        this.prefixTONS.clear();
        this.nsToPrefix.clear();
        this.defaultNamespace = null;
    }

    public Namespace get(String string) {
        return (Namespace)this.prefixTONS.get(string);
    }

    public String get(Namespace namespace) {
        return (String)this.nsToPrefix.get(namespace);
    }

    public int size() {
        return this.nsToPrefix.size();
    }

    public PrefixEntry[] getAll() {
        PrefixEntry[] prefixEntryArray = new PrefixEntry[this.nsToPrefix.size()];
        int n = 0;
        Iterator iterator = this.nsToPrefix.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            prefixEntryArray[n++] = new PrefixEntry((String)entry.getValue(), (Namespace)entry.getKey());
        }
        return prefixEntryArray;
    }

    public boolean setDefaultNamespace(Namespace namespace) {
        if (namespace == null || this.nsToPrefix.get(namespace) != null) {
            this.defaultNamespace = namespace;
            return true;
        }
        return false;
    }

    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public static PrefixEntry[] merge(PrefixEntry[] prefixEntryArray, PrefixEntry[] prefixEntryArray2) {
        if (prefixEntryArray == null || prefixEntryArray.length == 0) {
            return prefixEntryArray2;
        }
        if (prefixEntryArray2 == null || prefixEntryArray2.length == 0) {
            return prefixEntryArray;
        }
        PreferredPrefix preferredPrefix = new PreferredPrefix();
        int n = 0;
        while (n < prefixEntryArray.length) {
            PrefixEntry prefixEntry = prefixEntryArray[n];
            preferredPrefix.add(prefixEntry.namespace, prefixEntry.prefix);
            ++n;
        }
        int n2 = 0;
        while (n2 < prefixEntryArray2.length) {
            PrefixEntry prefixEntry = prefixEntryArray2[n2];
            preferredPrefix.add(prefixEntry.namespace, prefixEntry.prefix);
            ++n2;
        }
        return preferredPrefix.getAll();
    }

    public PreferredPrefix copy() {
        PreferredPrefix preferredPrefix = new PreferredPrefix();
        preferredPrefix.prefixTONS = (HashMap)this.prefixTONS.clone();
        preferredPrefix.nsToPrefix = (IdentityHashMap)this.nsToPrefix.clone();
        preferredPrefix.defaultNamespace = this.defaultNamespace;
        return preferredPrefix;
    }

    public String toString() {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        Namespace namespace = this.getDefaultNamespace();
        if (namespace != null) {
            stringBuffer.append("xmlns=\"");
            stringBuffer.append(namespace.getURI());
            stringBuffer.append("\"\n");
        }
        if ((objectArray = this.getAll()).length > 1) {
            Arrays.sort(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            stringBuffer.append("xmlns:");
            stringBuffer.append(((PrefixEntry)object).prefix);
            stringBuffer.append("=\"");
            stringBuffer.append(((PrefixEntry)object).namespace.getURI());
            stringBuffer.append("\"\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Namespace prefixToNamespace(String string) {
        if (string.length() == 0 && this.defaultNamespace != null) {
            return this.defaultNamespace;
        }
        Namespace namespace = (Namespace)this.prefixTONS.get(string);
        if (namespace == null && "xml".equals(string)) {
            return Namespace.XML;
        }
        return namespace;
    }

    public String[] namespaceToPrefixes(Namespace namespace) {
        String string = (String)this.nsToPrefix.get(namespace);
        if (string == null) {
            return namespace == Namespace.XML ? NamespaceToPrefixes.XML_PREFIXES : null;
        }
        if (namespace == this.defaultNamespace) {
            this.prefixe2[0] = "";
            this.prefixe2[1] = string;
            return this.prefixe2;
        }
        this.prefixe1[0] = string;
        return this.prefixe1;
    }
}

