/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NodeUtil;
import com.xmlmind.xmledit.xpath.SafeNodeIterator;
import java.math.BigDecimal;

public final class Converter {
    private Converter() {
    }

    public static double toNumber(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static double toNumber(NodeIterator nodeIterator) throws EvalException {
        return Converter.toNumber(Converter.toString(nodeIterator));
    }

    public static double toNumber(boolean bl) {
        return bl ? 1.0 : 0.0;
    }

    public static boolean toBoolean(String string) {
        return string.length() != 0;
    }

    public static boolean toBoolean(double d) {
        return d != 0.0 && d == d;
    }

    public static boolean toBoolean(NodeIterator nodeIterator) throws EvalException {
        return nodeIterator.next() != null;
    }

    public static String toString(NodeIterator nodeIterator) throws EvalException {
        return Converter.toString(nodeIterator.next());
    }

    public static String toString(XNode xNode) throws EvalException {
        if (xNode == null) {
            return "";
        }
        String string = xNode.data();
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Converter.addContent(xNode, stringBuffer);
        return stringBuffer.toString();
    }

    private static void addContent(XNode xNode, StringBuffer stringBuffer) throws EvalException {
        switch (xNode.type()) {
            case 0: {
                stringBuffer.append(xNode.data());
                break;
            }
            case 4: 
            case 5: {
                SafeNodeIterator safeNodeIterator = NodeUtil.getChildren(xNode);
                while ((xNode = safeNodeIterator.next()) != null) {
                    Converter.addContent(xNode, stringBuffer);
                }
                break;
            }
        }
    }

    public static String toString(double d) {
        String string;
        int n;
        if (!Double.isInfinite(d) && (d >= 9.007199254740992E15 || -d >= 9.007199254740992E15)) {
            return new BigDecimal(d).toString();
        }
        String string2 = Double.toString(d);
        if (string2.charAt((n = string2.length()) - 2) == '.' && string2.charAt(n - 1) == '0') {
            if ((string2 = string2.substring(0, n - 2)).equals("-0")) {
                return "0";
            }
            return string2;
        }
        int n2 = string2.indexOf(69);
        if (n2 < 0) {
            return string2;
        }
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        if (string2.charAt(0) == '-') {
            string = "-";
            string2 = string2.substring(1);
            --n2;
        } else {
            string = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return string + string2.substring(0, 1) + string2.substring(2, n2) + Converter.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return string + string2.substring(0, 1) + string2.substring(2, 2 + n3) + "." + string2.substring(2 + n3, n2);
        }
        return string + "0." + Converter.zeros(-1 - n3) + string2.substring(0, 1) + string2.substring(2, n2);
    }

    private static String zeros(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    static boolean positionToBoolean(double d, ExprContext exprContext) throws EvalException {
        return (double)exprContext.getPosition() == d;
    }
}

