/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.Converter;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xmledit.xpath.ConvertibleStringExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.MergeNodeIterator;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.NullNodeIterator;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantExpr;

class DocumentFunction
implements Function {
    DocumentFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray) throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr;
        if (convertibleExprArray.length != 1 && convertibleExprArray.length != 2) {
            throw new ParseException("expected one or two arguments");
        }
        ConvertibleExpr convertibleExpr = convertibleExprArray[0];
        ConvertibleNodeSetExpr convertibleNodeSetExpr2 = convertibleNodeSetExpr = convertibleExprArray.length == 1 ? null : convertibleExprArray[1].makeNodeSetExpr();
        if (convertibleExpr instanceof NodeSetExpr) {
            final NodeSetExpr nodeSetExpr = (NodeSetExpr)((Object)convertibleExpr);
            return new ConvertibleNodeSetExpr(){

                public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    return DocumentFunction.document(exprContext, nodeSetExpr.eval(xNode, exprContext), convertibleNodeSetExpr == null ? null : convertibleNodeSetExpr.eval(xNode, exprContext).next());
                }
            };
        }
        if (convertibleExpr instanceof VariantExpr) {
            final VariantExpr variantExpr = (VariantExpr)((Object)convertibleExpr);
            return new ConvertibleNodeSetExpr(){

                public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    Variant variant = variantExpr.eval(xNode, exprContext);
                    if (variant.isNodeSet()) {
                        return DocumentFunction.document(exprContext, variant.convertToNodeSet(), convertibleNodeSetExpr == null ? null : convertibleNodeSetExpr.eval(xNode, exprContext).next());
                    }
                    return DocumentFunction.document(exprContext, variant.convertToString(), convertibleNodeSetExpr == null ? null : convertibleNodeSetExpr.eval(xNode, exprContext).next());
                }
            };
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleNodeSetExpr(){

            public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                return DocumentFunction.document(exprContext, convertibleStringExpr.eval(xNode, exprContext), convertibleNodeSetExpr == null ? null : convertibleNodeSetExpr.eval(xNode, exprContext).next());
            }
        };
    }

    private static final NodeIterator document(ExprContext exprContext, NodeIterator nodeIterator, XNode xNode) throws EvalException {
        XNode xNode2;
        NodeIterator[] nodeIteratorArray = new NodeIterator[1];
        int n = 0;
        while ((xNode2 = nodeIterator.next()) != null) {
            if (n == nodeIteratorArray.length) {
                NodeIterator[] nodeIteratorArray2 = nodeIteratorArray;
                nodeIteratorArray = new NodeIterator[nodeIteratorArray.length * 2];
                System.arraycopy(nodeIteratorArray2, 0, nodeIteratorArray, 0, nodeIteratorArray2.length);
            }
            nodeIteratorArray[n++] = DocumentFunction.document(exprContext, Converter.toString(xNode2), xNode == null ? xNode2 : xNode);
        }
        if (n > 1) {
            return new MergeNodeIterator(nodeIteratorArray, n);
        }
        if (n == 1) {
            return nodeIteratorArray[0];
        }
        return new NullNodeIterator();
    }

    private static final NodeIterator document(ExprContext exprContext, String string, XNode xNode) throws EvalException {
        return exprContext.getDocument(string, xNode == null ? null : xNode.location());
    }
}

