/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.AddExpr;
import com.xmlmind.xmledit.xpath.AlternativesPattern;
import com.xmlmind.xmledit.xpath.AncestorAxisExpr;
import com.xmlmind.xmledit.xpath.AncestorOrSelfAxisExpr;
import com.xmlmind.xmledit.xpath.AndExpr;
import com.xmlmind.xmledit.xpath.AnyNodeButAttrAndDocTest;
import com.xmlmind.xmledit.xpath.AttributeAxisExpr;
import com.xmlmind.xmledit.xpath.AttributeTest;
import com.xmlmind.xmledit.xpath.AxisExpr;
import com.xmlmind.xmledit.xpath.BooleanExpr;
import com.xmlmind.xmledit.xpath.BooleanFunction;
import com.xmlmind.xmledit.xpath.BooleanRelationalExpr;
import com.xmlmind.xmledit.xpath.CeilingFunction;
import com.xmlmind.xmledit.xpath.ChildAxisExpr;
import com.xmlmind.xmledit.xpath.ConcatFunction;
import com.xmlmind.xmledit.xpath.ContainsFunction;
import com.xmlmind.xmledit.xpath.Converter;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xmledit.xpath.CopyFunction;
import com.xmlmind.xmledit.xpath.CountFunction;
import com.xmlmind.xmledit.xpath.CurrentFunction;
import com.xmlmind.xmledit.xpath.DescendantAxisExpr;
import com.xmlmind.xmledit.xpath.DescendantOrSelfAxisExpr;
import com.xmlmind.xmledit.xpath.DifferenceFunction;
import com.xmlmind.xmledit.xpath.DivideExpr;
import com.xmlmind.xmledit.xpath.DocumentFunction;
import com.xmlmind.xmledit.xpath.ElementTest;
import com.xmlmind.xmledit.xpath.EqualsRelation;
import com.xmlmind.xmledit.xpath.ExprTokenizer;
import com.xmlmind.xmledit.xpath.ExtensionFunctionCallExpr;
import com.xmlmind.xmledit.xpath.FalseFunction;
import com.xmlmind.xmledit.xpath.FilterExpr;
import com.xmlmind.xmledit.xpath.FilterPattern;
import com.xmlmind.xmledit.xpath.FloorFunction;
import com.xmlmind.xmledit.xpath.FollowingAxisExpr;
import com.xmlmind.xmledit.xpath.FollowingSiblingAxisExpr;
import com.xmlmind.xmledit.xpath.FormatNumberFunction;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.GreaterThanEqualsRelation;
import com.xmlmind.xmledit.xpath.GreaterThanRelation;
import com.xmlmind.xmledit.xpath.IdFunction;
import com.xmlmind.xmledit.xpath.IdPattern;
import com.xmlmind.xmledit.xpath.IfFunction;
import com.xmlmind.xmledit.xpath.InheritPattern;
import com.xmlmind.xmledit.xpath.IntersectionFunction;
import com.xmlmind.xmledit.xpath.JoinFunction;
import com.xmlmind.xmledit.xpath.LangFunction;
import com.xmlmind.xmledit.xpath.LastFunction;
import com.xmlmind.xmledit.xpath.LiteralExpr;
import com.xmlmind.xmledit.xpath.LocalNameFunction;
import com.xmlmind.xmledit.xpath.MatchesFunction;
import com.xmlmind.xmledit.xpath.MaxFunction;
import com.xmlmind.xmledit.xpath.MinFunction;
import com.xmlmind.xmledit.xpath.ModuloExpr;
import com.xmlmind.xmledit.xpath.MultiplyExpr;
import com.xmlmind.xmledit.xpath.NameFunction;
import com.xmlmind.xmledit.xpath.NamespaceAttributeTest;
import com.xmlmind.xmledit.xpath.NamespaceElementTest;
import com.xmlmind.xmledit.xpath.NamespaceUriFunction;
import com.xmlmind.xmledit.xpath.NegateExpr;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.NodeTestExpr;
import com.xmlmind.xmledit.xpath.NodeTypeTest;
import com.xmlmind.xmledit.xpath.NormalizeSpaceFunction;
import com.xmlmind.xmledit.xpath.NotEqualsRelation;
import com.xmlmind.xmledit.xpath.NotFunction;
import com.xmlmind.xmledit.xpath.NumberConstantExpr;
import com.xmlmind.xmledit.xpath.NumberExpr;
import com.xmlmind.xmledit.xpath.NumberFunction;
import com.xmlmind.xmledit.xpath.NumberRelationalExpr;
import com.xmlmind.xmledit.xpath.NumericRelation;
import com.xmlmind.xmledit.xpath.OrExpr;
import com.xmlmind.xmledit.xpath.ParentAxisExpr;
import com.xmlmind.xmledit.xpath.ParentPattern;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.PathPattern;
import com.xmlmind.xmledit.xpath.PathPatternBase;
import com.xmlmind.xmledit.xpath.Pattern;
import com.xmlmind.xmledit.xpath.PositionFunction;
import com.xmlmind.xmledit.xpath.PowFunction;
import com.xmlmind.xmledit.xpath.PrecedingAxisExpr;
import com.xmlmind.xmledit.xpath.PrecedingSiblingAxisExpr;
import com.xmlmind.xmledit.xpath.ProcessingInstructionTest;
import com.xmlmind.xmledit.xpath.Relation;
import com.xmlmind.xmledit.xpath.RelativizeURIFunction;
import com.xmlmind.xmledit.xpath.ReplaceFunction;
import com.xmlmind.xmledit.xpath.ResolveURIFunction;
import com.xmlmind.xmledit.xpath.RootExpr;
import com.xmlmind.xmledit.xpath.RoundFunction;
import com.xmlmind.xmledit.xpath.SelfAxisExpr;
import com.xmlmind.xmledit.xpath.SimpleFunction;
import com.xmlmind.xmledit.xpath.SimpleFunctionCallExpr;
import com.xmlmind.xmledit.xpath.SimpleFunctionTable;
import com.xmlmind.xmledit.xpath.StartsWithFunction;
import com.xmlmind.xmledit.xpath.StringExpr;
import com.xmlmind.xmledit.xpath.StringFunction;
import com.xmlmind.xmledit.xpath.StringLengthFunction;
import com.xmlmind.xmledit.xpath.StringRelationalExpr;
import com.xmlmind.xmledit.xpath.SubstringAfterFunction;
import com.xmlmind.xmledit.xpath.SubstringBeforeFunction;
import com.xmlmind.xmledit.xpath.SubstringFunction;
import com.xmlmind.xmledit.xpath.SubtractExpr;
import com.xmlmind.xmledit.xpath.SumFunction;
import com.xmlmind.xmledit.xpath.SystemPropertyFunction;
import com.xmlmind.xmledit.xpath.TranslateFunction;
import com.xmlmind.xmledit.xpath.TrueFunction;
import com.xmlmind.xmledit.xpath.URIToFileNameFunction;
import com.xmlmind.xmledit.xpath.UnionExpr;
import com.xmlmind.xmledit.xpath.VariableRefExpr;
import com.xmlmind.xmledit.xpath.VariantExpr;
import com.xmlmind.xmledit.xpath.VariantRelationalExpr;
import com.xmlmind.xmledit.xpath.WithCurrentExpr;
import java.util.HashMap;
import java.util.IdentityHashMap;

public class ExprParser
extends ExprTokenizer {
    private PrefixToNamespace prefixToNS;
    private boolean acceptUnknownPrefix;
    private boolean usesCurrentFunction = false;
    private static HashMap axisTable = new HashMap();
    private static AxisExpr childAxis = new ChildAxisExpr();
    private static AxisExpr parentAxis = new ParentAxisExpr();
    private static AxisExpr selfAxis = new SelfAxisExpr();
    private static AxisExpr attributeAxis = new AttributeAxisExpr();
    private static AxisExpr descendantOrSelfAxis = new DescendantOrSelfAxisExpr();
    private static HashMap functionTable = new HashMap();
    private static IdentityHashMap simpleFunctionTables = new IdentityHashMap();
    private static Relation equalsRelation = new EqualsRelation();
    private static Relation notEqualsRelation = new NotEqualsRelation();
    private static Relation greaterThanEqualsRelation = new GreaterThanEqualsRelation();
    private static Relation greaterThanRelation = new GreaterThanRelation();
    private static Function currentFunction = new CurrentFunction();

    public static void setSimpleFunctionTable(Namespace namespace, SimpleFunctionTable simpleFunctionTable) {
        if (simpleFunctionTable == null) {
            simpleFunctionTables.remove(namespace);
        } else {
            simpleFunctionTables.put(namespace, simpleFunctionTable);
        }
    }

    public static SimpleFunctionTable getSimpleFunctionTable(Namespace namespace) {
        return (SimpleFunctionTable)simpleFunctionTables.get(namespace);
    }

    public static NodeSetExpr parseNodeSetExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseNodeSetExpr(string, prefixToNamespace, false);
    }

    public static NodeSetExpr parseNodeSetExpr(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace, bl).makeNodeSetExpr();
    }

    public static StringExpr parseStringExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseStringExpr(string, prefixToNamespace, false);
    }

    public static StringExpr parseStringExpr(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace, bl).makeStringExpr();
    }

    public static NumberExpr parseNumberExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseNumberExpr(string, prefixToNamespace, false);
    }

    public static NumberExpr parseNumberExpr(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace, bl).makeNumberExpr();
    }

    public static BooleanExpr parseBooleanExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseBooleanExpr(string, prefixToNamespace, false);
    }

    public static BooleanExpr parseBooleanExpr(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace, bl).makeBooleanExpr();
    }

    public static VariantExpr parseVariantExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseVariantExpr(string, prefixToNamespace, false);
    }

    public static VariantExpr parseVariantExpr(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace, bl).makeVariantExpr();
    }

    private static ConvertibleExpr parseConvertibleExpr(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return new ExprParser(string, prefixToNamespace, bl).parseExpr();
    }

    private ExprParser(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        super(string);
        this.prefixToNS = prefixToNamespace;
        this.acceptUnknownPrefix = bl;
    }

    private ConvertibleExpr parseExpr() throws ParseException {
        this.next();
        ConvertibleExpr convertibleExpr = this.parseOrExpr();
        if (this.currentToken != 0) {
            throw new ParseException("unexpected token");
        }
        if (this.usesCurrentFunction) {
            return new WithCurrentExpr(convertibleExpr);
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseOrExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseAndExpr();
        while (this.currentToken == 35) {
            this.next();
            convertibleExpr = new OrExpr(convertibleExpr.makeBooleanExpr(), this.parseAndExpr().makeBooleanExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseAndExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseEqualityExpr();
        while (this.currentToken == 34) {
            this.next();
            convertibleExpr = new AndExpr(convertibleExpr.makeBooleanExpr(), this.parseEqualityExpr().makeBooleanExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseEqualityExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseRelationalExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 28: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(equalsRelation, convertibleExpr, this.parseRelationalExpr());
                    continue block4;
                }
                case 29: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(notEqualsRelation, convertibleExpr, this.parseRelationalExpr());
                    continue block4;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseRelationalExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseAdditiveExpr();
        block6: while (true) {
            switch (this.currentToken) {
                case 30: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanRelation, convertibleExpr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 32: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanEqualsRelation, convertibleExpr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 31: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanRelation, this.parseAdditiveExpr(), convertibleExpr);
                    continue block6;
                }
                case 33: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanEqualsRelation, this.parseAdditiveExpr(), convertibleExpr);
                    continue block6;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseAdditiveExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 26: {
                    this.next();
                    convertibleExpr = new AddExpr(convertibleExpr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
                case 27: {
                    this.next();
                    convertibleExpr = new SubtractExpr(convertibleExpr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseMultiplicativeExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 37: {
                    this.next();
                    convertibleExpr = new DivideExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 36: {
                    this.next();
                    convertibleExpr = new ModuloExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 11: {
                    this.next();
                    convertibleExpr = new MultiplyExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseUnaryExpr() throws ParseException {
        if (this.currentToken == 27) {
            this.next();
            return new NegateExpr(this.parseUnaryExpr().makeNumberExpr());
        }
        return this.parseUnionExpr();
    }

    private ConvertibleExpr parseUnionExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parsePathExpr();
        while (this.currentToken == 24) {
            this.next();
            convertibleExpr = new UnionExpr(convertibleExpr.makeNodeSetExpr(), this.parsePathExpr().makeNodeSetExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parsePathExpr() throws ParseException {
        if (this.tokenStartsStep()) {
            return this.parseRelativeLocationPath();
        }
        if (this.currentToken == 22) {
            this.next();
            if (this.tokenStartsStep()) {
                return new RootExpr(this.parseRelativeLocationPath());
            }
            return new RootExpr(selfAxis);
        }
        if (this.currentToken == 23) {
            this.next();
            return new RootExpr(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        ConvertibleExpr convertibleExpr = this.parsePrimaryExpr();
        while (this.currentToken == 14) {
            this.next();
            convertibleExpr = new FilterExpr(convertibleExpr.makeNodeSetExpr(), this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        if (this.currentToken == 22) {
            this.next();
            return convertibleExpr.makeNodeSetExpr().compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return convertibleExpr.makeNodeSetExpr().compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return convertibleExpr;
    }

    private ConvertibleNodeSetExpr parseRelativeLocationPath() throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr = this.parseStep();
        if (this.currentToken == 22) {
            this.next();
            return convertibleNodeSetExpr.compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return convertibleNodeSetExpr.compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return convertibleNodeSetExpr;
    }

    private ConvertibleNodeSetExpr parseStep() throws ParseException {
        switch (this.currentToken) {
            case 18: {
                AxisExpr axisExpr = (AxisExpr)axisTable.get(this.currentTokenValue);
                if (axisExpr == null) {
                    throw new ParseException("no such axis");
                }
                boolean bl = this.currentTokenValue.equals("attribute");
                this.next();
                return this.parsePredicates(axisExpr, this.parseNodeTest(bl));
            }
            case 5: {
                this.next();
                return selfAxis;
            }
            case 6: {
                this.next();
                return parentAxis;
            }
            case 4: {
                this.next();
                return this.parsePredicates(attributeAxis, this.parseNodeTest(true));
            }
        }
        return this.parsePredicates(childAxis, this.parseNodeTest(false));
    }

    private ConvertibleNodeSetExpr parsePredicates(AxisExpr axisExpr, Pattern pattern) throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr = axisExpr;
        if (pattern != null) {
            convertibleNodeSetExpr = new NodeTestExpr(convertibleNodeSetExpr, pattern);
        }
        while (this.currentToken == 14) {
            this.next();
            convertibleNodeSetExpr = new FilterExpr(convertibleNodeSetExpr, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return axisExpr.makeDocumentOrderExpr(convertibleNodeSetExpr);
    }

    private PathPatternBase parseNodeTest(boolean bl) throws ParseException {
        PathPatternBase pathPatternBase;
        switch (this.currentToken) {
            case 1: {
                if (bl) {
                    pathPatternBase = new AttributeTest(this.expandName());
                    break;
                }
                pathPatternBase = new ElementTest(this.expandName());
                break;
            }
            case 2: {
                pathPatternBase = bl ? null : new NodeTypeTest(4);
                break;
            }
            case 3: {
                if (bl) {
                    pathPatternBase = new NamespaceAttributeTest(this.expandPrefix());
                    break;
                }
                pathPatternBase = new NamespaceElementTest(this.expandPrefix());
                break;
            }
            case 8: {
                PathPatternBase pathPatternBase2;
                this.next();
                if (this.currentToken == 16) {
                    pathPatternBase2 = new ProcessingInstructionTest(this.expandName());
                    this.next();
                } else {
                    pathPatternBase2 = new NodeTypeTest(2);
                }
                this.expectRpar();
                return pathPatternBase2;
            }
            case 7: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(1);
            }
            case 9: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(0);
            }
            case 10: {
                this.next();
                this.expectRpar();
                return null;
            }
            default: {
                throw new ParseException("expected node test");
            }
        }
        this.next();
        return pathPatternBase;
    }

    private final void expectRpar() throws ParseException {
        if (this.currentToken != 13) {
            throw new ParseException("expected )");
        }
        this.next();
    }

    private final void expectRsqb() throws ParseException {
        if (this.currentToken != 15) {
            throw new ParseException("expected ]");
        }
        this.next();
    }

    private ConvertibleExpr parsePrimaryExpr() throws ParseException {
        ConvertibleExpr convertibleExpr;
        switch (this.currentToken) {
            case 21: {
                convertibleExpr = new VariableRefExpr(this.expandName());
                break;
            }
            case 12: {
                this.next();
                ConvertibleExpr convertibleExpr2 = this.parseOrExpr();
                this.expectRpar();
                return convertibleExpr2;
            }
            case 16: {
                convertibleExpr = new LiteralExpr(this.currentTokenValue);
                break;
            }
            case 17: {
                convertibleExpr = new NumberConstantExpr(Converter.toNumber(this.currentTokenValue));
                break;
            }
            case 19: {
                Function function = (Function)functionTable.get(this.currentTokenValue);
                if (function == null) {
                    if (!this.currentTokenValue.equals("current")) {
                        throw new ParseException("no such function: " + this.currentTokenValue);
                    }
                    this.usesCurrentFunction = true;
                    function = currentFunction;
                }
                this.next();
                return function.makeCallExpr(this.parseArgs());
            }
            case 20: {
                Name name = this.expandName();
                this.next();
                Namespace namespace = name.getNamespace();
                if (namespace.getURI().startsWith("java:")) {
                    ConvertibleExpr[] convertibleExprArray = this.parseArgs();
                    VariantExpr[] variantExprArray = new VariantExpr[convertibleExprArray.length];
                    int n = 0;
                    while (n < convertibleExprArray.length) {
                        variantExprArray[n] = convertibleExprArray[n].makeVariantExpr();
                        ++n;
                    }
                    return new ExtensionFunctionCallExpr(name, variantExprArray);
                }
                SimpleFunction simpleFunction = null;
                SimpleFunctionTable simpleFunctionTable = (SimpleFunctionTable)simpleFunctionTables.get(namespace);
                if (simpleFunctionTable != null) {
                    simpleFunction = simpleFunctionTable.getSimpleFunction(name.getLocalPart());
                }
                if (simpleFunction == null) {
                    throw new ParseException("no such function: " + name.toString());
                }
                ConvertibleExpr[] convertibleExprArray = this.parseArgs();
                VariantExpr[] variantExprArray = new VariantExpr[convertibleExprArray.length];
                int n = 0;
                while (n < convertibleExprArray.length) {
                    variantExprArray[n] = convertibleExprArray[n].makeVariantExpr();
                    ++n;
                }
                return new SimpleFunctionCallExpr(simpleFunction.getObject(), simpleFunction.getMethod(), variantExprArray);
            }
            default: {
                throw new ParseException("syntax error");
            }
        }
        this.next();
        return convertibleExpr;
    }

    ConvertibleExpr[] parseArgs() throws ParseException {
        if (this.currentToken == 13) {
            this.next();
            return new ConvertibleExpr[0];
        }
        ConvertibleExpr[] convertibleExprArray = new ConvertibleExpr[1];
        while (true) {
            convertibleExprArray[convertibleExprArray.length - 1] = this.parseOrExpr();
            if (this.currentToken != 25) break;
            this.next();
            ConvertibleExpr[] convertibleExprArray2 = convertibleExprArray;
            convertibleExprArray = new ConvertibleExpr[convertibleExprArray2.length + 1];
            System.arraycopy(convertibleExprArray2, 0, convertibleExprArray, 0, convertibleExprArray2.length);
        }
        this.expectRpar();
        return convertibleExprArray;
    }

    private boolean tokenStartsNodeTest() {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private boolean tokenStartsStep() {
        switch (this.currentToken) {
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                return true;
            }
        }
        return this.tokenStartsNodeTest();
    }

    private Name expandName() throws ParseException {
        Name name = Name.parse(this.currentTokenValue, true, this.prefixToNS);
        if (name == null && this.acceptUnknownPrefix && XMLUtil.isName(this.currentTokenValue)) {
            name = Name.get(this.currentTokenValue);
        }
        if (name == null) {
            throw new ParseException("'" + this.currentTokenValue + "' malformed name or undefined prefix");
        }
        return name;
    }

    private Namespace expandPrefix() throws ParseException {
        Namespace namespace = null;
        if (this.prefixToNS == null) {
            if ("".equals(this.currentTokenValue)) {
                namespace = Namespace.NONE;
            } else if ("xml".equals(this.currentTokenValue)) {
                namespace = Namespace.XML;
            }
        } else {
            namespace = this.prefixToNS.prefixToNamespace(this.currentTokenValue);
        }
        if (namespace == null) {
            throw new ParseException("undefined prefix '" + this.currentTokenValue + "'");
        }
        return namespace;
    }

    ConvertibleExpr makeRelationalExpr(Relation relation, ConvertibleExpr convertibleExpr, ConvertibleExpr convertibleExpr2) throws ParseException {
        if (convertibleExpr instanceof NodeSetExpr || convertibleExpr2 instanceof NodeSetExpr || convertibleExpr instanceof VariantExpr || convertibleExpr2 instanceof VariantExpr) {
            return new VariantRelationalExpr(relation, convertibleExpr.makeVariantExpr(), convertibleExpr2.makeVariantExpr());
        }
        if (relation instanceof NumericRelation) {
            return new NumberRelationalExpr(relation, convertibleExpr.makeNumberExpr(), convertibleExpr2.makeNumberExpr());
        }
        if (convertibleExpr instanceof BooleanExpr || convertibleExpr2 instanceof BooleanExpr) {
            return new BooleanRelationalExpr(relation, convertibleExpr.makeBooleanExpr(), convertibleExpr2.makeBooleanExpr());
        }
        if (convertibleExpr instanceof NumberExpr || convertibleExpr2 instanceof NumberExpr) {
            return new NumberRelationalExpr(relation, convertibleExpr.makeNumberExpr(), convertibleExpr2.makeNumberExpr());
        }
        return new StringRelationalExpr(relation, convertibleExpr.makeStringExpr(), convertibleExpr2.makeStringExpr());
    }

    public static PathPattern parsePattern(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parsePattern(string, prefixToNamespace, false);
    }

    public static PathPattern parsePattern(String string, PrefixToNamespace prefixToNamespace, boolean bl) throws ParseException {
        return new ExprParser(string, prefixToNamespace, bl).parseTopLevelPattern();
    }

    private PathPattern parseTopLevelPattern() throws ParseException {
        this.next();
        PathPattern pathPattern = this.parsePathPattern();
        while (this.currentToken == 24) {
            this.next();
            pathPattern = new AlternativesPattern(pathPattern, this.parsePathPattern());
        }
        if (this.currentToken != 0) {
            throw new ParseException("unexpected token");
        }
        if (this.usesCurrentFunction) {
            throw new ParseException("current() in match pattern");
        }
        return pathPattern;
    }

    private PathPatternBase parsePathPattern() throws ParseException {
        PathPatternBase pathPatternBase;
        Pattern pattern = null;
        switch (this.currentToken) {
            case 23: {
                this.next();
                break;
            }
            case 22: {
                this.next();
                if (!this.tokenStartsStep()) {
                    return new NodeTypeTest(5);
                }
                pattern = new NodeTypeTest(5);
                break;
            }
            case 19: {
                if (this.currentTokenValue.equals("id")) {
                    this.next();
                    if (this.currentToken != 16) {
                        throw new ParseException("expected literal");
                    }
                    pathPatternBase = new IdPattern(this.currentTokenValue);
                    this.next();
                    this.expectRpar();
                    if (this.currentToken == 22) {
                        pattern = pathPatternBase;
                    } else if (this.currentToken == 23) {
                        pattern = new InheritPattern(pathPatternBase);
                    } else {
                        return pathPatternBase;
                    }
                    this.next();
                    break;
                }
                throw new ParseException("function illegal in pattern");
            }
        }
        while (true) {
            pathPatternBase = this.parseStepPattern();
            if (pattern != null) {
                pathPatternBase = new ParentPattern(pathPatternBase, pattern);
            }
            if (this.currentToken == 22) {
                pattern = pathPatternBase;
            } else if (this.currentToken == 23) {
                pattern = new InheritPattern(pathPatternBase);
            } else {
                return pathPatternBase;
            }
            this.next();
        }
    }

    private PathPatternBase parseStepPattern() throws ParseException {
        PathPatternBase pathPatternBase;
        if (this.currentToken == 4 || this.currentToken == 18 && this.currentTokenValue.equals("attribute")) {
            this.next();
            pathPatternBase = this.parseNodeTest(true);
            if (pathPatternBase == null) {
                pathPatternBase = new NodeTypeTest(6);
            }
        } else {
            if (this.currentToken == 18 && this.currentTokenValue.equals("child")) {
                this.next();
            }
            if ((pathPatternBase = this.parseNodeTest(false)) == null) {
                pathPatternBase = new AnyNodeButAttrAndDocTest();
            }
        }
        while (this.currentToken == 14) {
            this.next();
            pathPatternBase = new FilterPattern(pathPatternBase, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return pathPatternBase;
    }

    static {
        axisTable.put("child", childAxis);
        axisTable.put("parent", parentAxis);
        axisTable.put("self", selfAxis);
        axisTable.put("attribute", attributeAxis);
        axisTable.put("descendant-or-self", descendantOrSelfAxis);
        axisTable.put("descendant", new DescendantAxisExpr());
        axisTable.put("ancestor-or-self", new AncestorOrSelfAxisExpr());
        axisTable.put("ancestor", new AncestorAxisExpr());
        axisTable.put("following-sibling", new FollowingSiblingAxisExpr());
        axisTable.put("preceding-sibling", new PrecedingSiblingAxisExpr());
        axisTable.put("following", new FollowingAxisExpr());
        axisTable.put("preceding", new PrecedingAxisExpr());
        functionTable.put("boolean", new BooleanFunction());
        functionTable.put("ceiling", new CeilingFunction());
        functionTable.put("concat", new ConcatFunction());
        functionTable.put("contains", new ContainsFunction());
        functionTable.put("count", new CountFunction());
        functionTable.put("document", new DocumentFunction());
        functionTable.put("false", new FalseFunction());
        functionTable.put("floor", new FloorFunction());
        functionTable.put("format-number", new FormatNumberFunction());
        functionTable.put("id", new IdFunction());
        functionTable.put("lang", new LangFunction());
        functionTable.put("last", new LastFunction());
        functionTable.put("local-name", new LocalNameFunction());
        functionTable.put("namespace-uri", new NamespaceUriFunction());
        functionTable.put("normalize-space", new NormalizeSpaceFunction());
        functionTable.put("not", new NotFunction());
        functionTable.put("number", new NumberFunction());
        functionTable.put("position", new PositionFunction());
        functionTable.put("name", new NameFunction());
        functionTable.put("round", new RoundFunction());
        functionTable.put("starts-with", new StartsWithFunction());
        functionTable.put("string", new StringFunction());
        functionTable.put("string-length", new StringLengthFunction());
        functionTable.put("substring", new SubstringFunction());
        functionTable.put("substring-after", new SubstringAfterFunction());
        functionTable.put("substring-before", new SubstringBeforeFunction());
        functionTable.put("sum", new SumFunction());
        functionTable.put("translate", new TranslateFunction());
        functionTable.put("true", new TrueFunction());
        functionTable.put("intersection", new IntersectionFunction());
        functionTable.put("difference", new DifferenceFunction());
        functionTable.put("copy", new CopyFunction());
        functionTable.put("resolve-uri", new ResolveURIFunction());
        functionTable.put("relativize-uri", new RelativizeURIFunction());
        functionTable.put("uri-to-file-name", new URIToFileNameFunction());
        functionTable.put("if", new IfFunction());
        functionTable.put("min", new MinFunction());
        functionTable.put("max", new MaxFunction());
        functionTable.put("pow", new PowFunction());
        functionTable.put("join", new JoinFunction());
        functionTable.put("replace", new ReplaceFunction());
        functionTable.put("matches", new MatchesFunction());
        functionTable.put("system-property", new SystemPropertyFunction());
    }
}

