/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xpath.EvalException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class ExtensionFunctions {
    ExtensionFunctions() {
    }

    static Object call(Name name, Object[] objectArray) throws EvalException {
        Class clazz = ExtensionFunctions.loadClass(name);
        String string = ExtensionFunctions.camelCase(name.getLocalPart());
        try {
            if (string.equals("new")) {
                return ExtensionFunctions.callConstructor(clazz, objectArray);
            }
            return ExtensionFunctions.callMethod(clazz, string, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvalException("cannot invoke '" + ExtensionFunctions.methodName(clazz, string) + "': illegal access");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvalException("cannot invoke '" + ExtensionFunctions.methodName(clazz, string) + "': illegal arguments");
        }
        catch (InstantiationException instantiationException) {
            throw new EvalException("cannot instantiate class '" + clazz.getName() + "'");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof EvalException) {
                throw (EvalException)throwable;
            }
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getName();
            }
            throw new EvalException("cannot invoke '" + ExtensionFunctions.methodName(clazz, string) + "': " + string2);
        }
    }

    private static Class loadClass(Name name) throws EvalException {
        String string = name.getNamespace().getURI();
        if (!string.startsWith("java:")) {
            throw new EvalException("'" + string + "' invalid namespace" + " for an extension function:" + " should start with 'java:'");
        }
        string = string.substring(5);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            String string2 = exception.getClass().getName();
            if (exception.getMessage() != null) {
                string2 = string2 + ": " + exception.getMessage();
            }
            throw new EvalException("cannot load class '" + string + "': " + string2);
        }
        return clazz;
    }

    private static String camelCase(String string) {
        int n = string.indexOf(45);
        if (n < 0 || n + 1 == string.length()) {
            return string;
        }
        return string.substring(0, n) + Character.toUpperCase(string.charAt(n + 1)) + ExtensionFunctions.camelCase(string.substring(n + 2));
    }

    private static String methodName(Class clazz, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if ("new".equals(string)) {
            stringBuffer.append("new ");
            stringBuffer.append(clazz.getName());
        } else {
            stringBuffer.append(clazz.getName());
            stringBuffer.append('.');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static Object callConstructor(Class clazz, Object[] objectArray) throws EvalException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor<?> constructor = null;
        int n = 0;
        while (n < constructorArray.length) {
            if (constructorArray[n].getParameterTypes().length == objectArray.length) {
                if (constructor != null) {
                    throw new EvalException("overloaded constructor of '" + clazz.getName() + "'");
                }
                constructor = constructorArray[n];
            }
            ++n;
        }
        if (constructor == null) {
            throw new EvalException("no constructor of '" + clazz.getName() + "' with " + objectArray.length + " arguments");
        }
        return constructor.newInstance(objectArray);
    }

    private static Object callMethod(Class clazz, String string, Object[] objectArray) throws EvalException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object;
        boolean bl = true;
        if (objectArray.length > 0 && clazz.isInstance(objectArray[0])) {
            bl = false;
        }
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string) && (Modifier.isStatic(methodArray[n].getModifiers()) ? methodArray[n].getParameterTypes().length == objectArray.length : !bl && methodArray[n].getParameterTypes().length == objectArray.length - 1)) {
                if (method != null) {
                    throw new EvalException("overloaded method '" + ExtensionFunctions.methodName(clazz, string) + "'");
                }
                method = methodArray[n];
            }
            ++n;
        }
        if (method == null) {
            throw new EvalException("no method '" + ExtensionFunctions.methodName(clazz, string) + "' with " + objectArray.length + " arguments");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            object = method.invoke(null, objectArray);
        } else {
            Object object2 = objectArray[0];
            Object[] objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
            object = method.invoke(object2, objectArray2);
        }
        return object;
    }
}

