/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.BooleanExpr;
import com.xmlmind.xmledit.xpath.CloneableNodeIterator;
import com.xmlmind.xmledit.xpath.CloneableNodeIteratorImpl;
import com.xmlmind.xmledit.xpath.DelegateExprContext;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.NodeIterator;

class FilterNodeIterator
extends DelegateExprContext
implements NodeIterator {
    private int pos = 0;
    private int lastPos = 0;
    private NodeIterator iter;
    private BooleanExpr predicate;

    FilterNodeIterator(NodeIterator nodeIterator, ExprContext exprContext, BooleanExpr booleanExpr) {
        super(exprContext);
        this.iter = nodeIterator;
        this.predicate = booleanExpr;
    }

    public XNode next() throws EvalException {
        XNode xNode;
        while ((xNode = this.iter.next()) != null) {
            ++this.pos;
            if (!this.predicate.eval(xNode, this)) continue;
            return xNode;
        }
        return null;
    }

    public int getPosition() {
        return this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPosition() throws EvalException {
        if (this.lastPos == 0) {
            CloneableNodeIterator cloneableNodeIterator = this.iter instanceof CloneableNodeIterator ? (CloneableNodeIterator)this.iter : new CloneableNodeIteratorImpl(this.iter);
            this.iter = (NodeIterator)cloneableNodeIterator.clone();
            int n = this.pos;
            try {
                while (this.next() != null) {
                }
                this.lastPos = this.pos;
                Object var4_3 = null;
                this.pos = n;
                this.iter = cloneableNodeIterator;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.pos = n;
                this.iter = cloneableNodeIterator;
                throw throwable;
            }
        }
        return this.lastPos;
    }
}

