/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.BooleanExpr;
import com.xmlmind.xmledit.xpath.DelegateExprContext;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.NodeUtil;
import com.xmlmind.xmledit.xpath.PathPatternBase;
import com.xmlmind.xmledit.xpath.SafeNodeIterator;

class FilterPattern
extends PathPatternBase {
    private PathPatternBase pattern;
    private BooleanExpr predicate;

    FilterPattern(PathPatternBase pathPatternBase, BooleanExpr booleanExpr) {
        this.pattern = pathPatternBase;
        this.predicate = booleanExpr;
    }

    public boolean matches(XNode xNode, ExprContext exprContext) throws EvalException {
        if (!this.pattern.matches(xNode, exprContext)) {
            return false;
        }
        return this.predicate.eval(xNode, new Context(xNode, exprContext));
    }

    class Context
    extends DelegateExprContext {
        XNode node;
        int position = 0;
        int lastPosition = 0;

        Context(XNode xNode, ExprContext exprContext) {
            super(exprContext);
            this.node = xNode;
        }

        public int getPosition() throws EvalException {
            XNode xNode;
            SafeNodeIterator safeNodeIterator;
            if (this.position != 0) {
                return this.position;
            }
            switch (this.node.type()) {
                case 5: {
                    this.position = 1;
                    return 1;
                }
                case 6: {
                    safeNodeIterator = NodeUtil.getAttributes(this.node.parent());
                    break;
                }
                default: {
                    safeNodeIterator = NodeUtil.getChildren(this.node.parent());
                }
            }
            this.position = 1;
            while (!(xNode = safeNodeIterator.next()).equals(this.node)) {
                if (!FilterPattern.this.pattern.matches(xNode, this.origContext)) continue;
                ++this.position;
            }
            return this.position;
        }

        public int getLastPosition() throws EvalException {
            XNode xNode;
            SafeNodeIterator safeNodeIterator;
            if (this.lastPosition != 0) {
                return this.lastPosition;
            }
            switch (this.node.type()) {
                case 5: {
                    this.lastPosition = 1;
                    return 1;
                }
                case 6: {
                    safeNodeIterator = NodeUtil.getAttributes(this.node.parent());
                    this.lastPosition = 0;
                    break;
                }
                default: {
                    safeNodeIterator = NodeUtil.getFollowingSiblings(this.node);
                    this.lastPosition = this.getPosition();
                    break;
                }
            }
            while ((xNode = safeNodeIterator.next()) != null) {
                if (!FilterPattern.this.pattern.matches(xNode, this.origContext)) continue;
                ++this.lastPosition;
            }
            return this.lastPosition;
        }
    }
}

