/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NodeUtil;

class FollowingNodeIterator
implements NodeIterator {
    private NodeIterator iter;
    private XNode parent;

    public FollowingNodeIterator(XNode xNode) {
        if (xNode.type() == 6) {
            xNode = xNode.parent();
        }
        this.parent = xNode.parent();
        if (this.parent == null) {
            this.parent = xNode;
        }
        this.iter = NodeUtil.getFollowingSiblings(xNode);
    }

    public XNode next() throws EvalException {
        while (true) {
            XNode xNode;
            if ((xNode = this.iter.next()) != null) {
                this.parent = xNode;
                this.iter = NodeUtil.getChildren(xNode);
                return xNode;
            }
            this.iter = NodeUtil.getFollowingSiblings(this.parent);
            xNode = this.parent.parent();
            if (xNode == null) break;
            this.parent = xNode;
        }
        return null;
    }
}

