/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.BooleanExpr;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleVariantExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantExpr;

class IfFunction
implements Function {
    IfFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray) throws ParseException {
        if (convertibleExprArray.length % 2 != 1 || convertibleExprArray.length < 3) {
            throw new ParseException("expected an even number, at least 3, arguments");
        }
        int n = convertibleExprArray.length / 2;
        final BooleanExpr[] booleanExprArray = new BooleanExpr[n];
        final VariantExpr[] variantExprArray = new VariantExpr[n];
        int n2 = 0;
        while (n2 < n) {
            booleanExprArray[n2] = convertibleExprArray[2 * n2].makeBooleanExpr();
            variantExprArray[n2] = convertibleExprArray[2 * n2 + 1].makeVariantExpr();
            ++n2;
        }
        final ConvertibleVariantExpr convertibleVariantExpr = convertibleExprArray[convertibleExprArray.length - 1].makeVariantExpr();
        return new ConvertibleVariantExpr(){

            public Variant eval(XNode xNode, ExprContext exprContext) throws EvalException {
                int n = 0;
                while (n < booleanExprArray.length) {
                    if (booleanExprArray[n].eval(xNode, exprContext)) {
                        return variantExprArray[n].eval(xNode, exprContext);
                    }
                    ++n;
                }
                return convertibleVariantExpr.eval(xNode, exprContext);
            }
        };
    }
}

