/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xpath.ConvertibleBooleanExpr;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleStringExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function1;
import com.xmlmind.xmledit.xpath.ParseException;

class LangFunction
extends Function1 {
    LangFunction() {
    }

    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleBooleanExpr(){

            public boolean eval(XNode xNode, ExprContext exprContext) throws EvalException {
                return LangFunction.lang(xNode, convertibleStringExpr.eval(xNode, exprContext));
            }
        };
    }

    private static final boolean lang(XNode xNode, String string) {
        while (xNode != null) {
            String string2 = xNode.attributeValue(Name.XML_LANG);
            if (string2 != null) {
                return LangFunction.isSubLanguage(string, string2);
            }
            xNode = xNode.parent();
        }
        return false;
    }

    private static final boolean isSubLanguage(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 > (n = string2.length())) {
            return false;
        }
        if (n2 < n && string2.charAt(n2) != '-') {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            char c2 = string2.charAt(n3);
            switch (c - c2) {
                case -32: 
                case 0: 
                case 32: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }
}

