/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.Converter;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xmledit.xpath.ConvertibleNumberExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NumberExpr;
import com.xmlmind.xmledit.xpath.ParseException;

class MinFunction
implements Function {
    MinFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray) throws ParseException {
        if (convertibleExprArray.length < 1) {
            throw new ParseException("expected 1 node-set argument or at least 2 number arguments");
        }
        if (convertibleExprArray.length == 1) {
            final ConvertibleNodeSetExpr convertibleNodeSetExpr = convertibleExprArray[0].makeNodeSetExpr();
            return new ConvertibleNumberExpr(){

                public double eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    XNode xNode2;
                    double d = Double.NaN;
                    NodeIterator nodeIterator = convertibleNodeSetExpr.eval(xNode, exprContext);
                    while ((xNode2 = nodeIterator.next()) != null) {
                        double d2 = Double.NaN;
                        String string = Converter.toString(xNode2);
                        if (string != null) {
                            try {
                                d2 = Double.parseDouble(string.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (Double.isNaN(d2) || !Double.isNaN(d) && !(d2 < d)) continue;
                        d = d2;
                    }
                    return d;
                }
            };
        }
        final NumberExpr[] numberExprArray = new NumberExpr[convertibleExprArray.length];
        int n = 0;
        while (n < convertibleExprArray.length) {
            numberExprArray[n] = convertibleExprArray[n].makeNumberExpr();
            ++n;
        }
        return new ConvertibleNumberExpr(){

            public double eval(XNode xNode, ExprContext exprContext) throws EvalException {
                double d = Double.NaN;
                int n = 0;
                while (n < numberExprArray.length) {
                    double d2 = numberExprArray[n].eval(xNode, exprContext);
                    if (!Double.isNaN(d2) && (Double.isNaN(d) || d2 < d)) {
                        d = d2;
                    }
                    ++n;
                }
                return d;
            }
        };
    }
}

