/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.DocumentTypeDeclaration;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.NodeIterator;

class PrecedingNodeIterator
implements NodeIterator {
    private XNode initial;
    private XNode current;

    public PrecedingNodeIterator(XNode xNode) {
        if (xNode.type() == 6) {
            xNode = xNode.parent();
        }
        this.initial = this.current = xNode;
    }

    public XNode next() throws EvalException {
        if (this.current != null) {
            XNode xNode = this.current.preceding();
            if (xNode == null) {
                this.current = this.current.parent();
            } else {
                XNode xNode2 = xNode.lastChild();
                while (xNode2 != null) {
                    xNode = xNode2;
                    xNode2 = xNode.lastChild();
                }
                this.current = xNode;
            }
        }
        return this.current instanceof DocumentTypeDeclaration || PrecedingNodeIterator.isAncestorOf(this.current, this.initial) ? this.next() : this.current;
    }

    private static final boolean isAncestorOf(XNode xNode, XNode xNode2) {
        while (xNode2 != null) {
            if (xNode2 == xNode) {
                return true;
            }
            xNode2 = xNode2.parent();
        }
        return false;
    }
}

