/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleStringExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.ParseException;
import java.net.MalformedURLException;
import java.net.URL;

class RelativizeURIFunction
implements Function {
    RelativizeURIFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray) throws ParseException {
        if (convertibleExprArray.length < 1 || convertibleExprArray.length > 2) {
            throw new ParseException("expected 1 or 2 arguments");
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExprArray[0].makeStringExpr();
        final ConvertibleStringExpr convertibleStringExpr2 = convertibleExprArray.length == 1 ? null : convertibleExprArray[1].makeStringExpr();
        return new ConvertibleStringExpr(){

            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                URL uRL;
                String string;
                URL uRL2;
                String string2 = convertibleStringExpr.eval(xNode, exprContext);
                try {
                    uRL2 = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new EvalException("invalid argument to relativize-uri: '" + string2 + "' malformed URL");
                }
                if (convertibleStringExpr2 != null) {
                    string = convertibleStringExpr2.eval(xNode, exprContext);
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new EvalException("invalid argument to relativize-uri: '" + string + "' malformed URL");
                    }
                } else {
                    uRL = xNode.location();
                    if (uRL == null) {
                        throw new EvalException("relativize-uri cannot use the context node to relativize its absolute URI argument: the context node has no location property");
                    }
                }
                string = URLUtil.getRelativeRawPath(uRL2, uRL);
                return string == null ? string2 : string;
            }
        };
    }
}

