/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleStringExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.ParseException;
import java.net.MalformedURLException;
import java.net.URL;

class ResolveURIFunction
implements Function {
    ResolveURIFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray) throws ParseException {
        if (convertibleExprArray.length < 1 || convertibleExprArray.length > 2) {
            throw new ParseException("expected 1 or 2 arguments");
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExprArray[0].makeStringExpr();
        final ConvertibleStringExpr convertibleStringExpr2 = convertibleExprArray.length == 1 ? null : convertibleExprArray[1].makeStringExpr();
        return new ConvertibleStringExpr(){

            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                String string = convertibleStringExpr.eval(xNode, exprContext);
                try {
                    new URL(string);
                    return string;
                }
                catch (MalformedURLException malformedURLException) {
                    URL uRL;
                    Object object;
                    if (convertibleStringExpr2 != null) {
                        object = convertibleStringExpr2.eval(xNode, exprContext);
                        try {
                            uRL = new URL((String)object);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            throw new EvalException("invalid argument to resolve-uri: '" + (String)object + "' malformed URL");
                        }
                    } else {
                        uRL = xNode.location();
                        if (uRL == null) {
                            throw new EvalException("resolve-uri cannot use the context node to resolve its relative URI argument: the context node has no location property");
                        }
                    }
                    try {
                        object = new URL(uRL, string);
                    }
                    catch (MalformedURLException malformedURLException3) {
                        throw new EvalException("invalid argument to resolve-uri: '" + string + "' malformed URL");
                    }
                    return ((URL)object).toExternalForm();
                }
            }
        };
    }
}

