/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.IdEntry;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.ElementXPointer;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xpath.DocumentManager;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NullNodeIterator;
import com.xmlmind.xmledit.xpath.OutermostExprContext;
import com.xmlmind.xmledit.xpath.SingleNodeIterator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;

public class SimpleExprContext
extends OutermostExprContext
implements Cloneable {
    protected static DocumentManager defaultDocumentManager = null;
    protected DocumentManager documentManager;
    protected IdentityHashMap idMaps;
    private static final HashMap EMPTY_HASH_MAP = new HashMap(1);

    public static void setDefaultDocumentManager(DocumentManager documentManager) {
        defaultDocumentManager = documentManager;
    }

    public static DocumentManager getDefaultDocumentManager() {
        return defaultDocumentManager;
    }

    public SimpleExprContext() {
        this(null);
    }

    public SimpleExprContext(DocumentManager documentManager) {
        this.setDocumentManager(documentManager);
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void reset() {
        if (this.idMaps != null) {
            this.idMaps.clear();
        }
    }

    public XNode findElementWithId(XNode xNode, String string) throws EvalException {
        HashMap hashMap = this.getIdMap(xNode);
        IdEntry idEntry = (IdEntry)hashMap.get(string);
        return idEntry == null ? null : idEntry.elements[0];
    }

    public boolean isElementWithId(XNode xNode, String string) throws EvalException {
        HashMap hashMap = this.getIdMap(xNode);
        IdEntry idEntry = (IdEntry)hashMap.get(string);
        return idEntry == null ? false : idEntry.elements[0] == xNode;
    }

    private final HashMap getIdMap(XNode xNode) {
        HashMap hashMap;
        Document document = (Document)xNode.document();
        if (document == null) {
            return EMPTY_HASH_MAP;
        }
        if (this.idMaps == null) {
            this.idMaps = new IdentityHashMap(3);
        }
        if ((hashMap = (HashMap)this.idMaps.get(document)) == null) {
            DocumentType documentType = DocumentTypeUtil.getDocumentType(document);
            if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
                hashMap = EMPTY_HASH_MAP;
            } else {
                hashMap = new HashMap();
                documentType.collectIds(document.getRootElement(), hashMap);
            }
            this.idMaps.put(document, hashMap);
        }
        return hashMap;
    }

    public NodeIterator getDocument(String string, URL uRL) throws EvalException {
        URL uRL2;
        DocumentManager documentManager;
        DocumentManager documentManager2 = documentManager = this.documentManager == null ? defaultDocumentManager : this.documentManager;
        if (documentManager == null) {
            return new NullNodeIterator();
        }
        try {
            uRL2 = XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new EvalException("malformed URL uriRef='" + string + "'," + " baseURL='" + uRL + "': " + MiscUtil.reason(malformedURLException));
        }
        Document document = documentManager.getDocument(URLUtil.trimFragment(uRL2));
        if (document == null) {
            return new NullNodeIterator();
        }
        String string2 = uRL2.getRef();
        if (string2 == null) {
            return new SingleNodeIterator(document);
        }
        ElementXPointer elementXPointer = ElementXPointer.parse(string2);
        if (elementXPointer == null) {
            throw new EvalException("invalid or unsupported fragment '" + string2 + "' in '" + string + "'");
        }
        Element element = DocumentTypeUtil.findElement(document, elementXPointer);
        if (element == null) {
            throw new EvalException("element specified by fragment '" + string2 + "' in '" + string + "' is not found");
        }
        return new SingleNodeIterator(element);
    }
}

