/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.ConvertibleVariantExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantExpr;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class SimpleFunctionCallExpr
extends ConvertibleVariantExpr {
    private Object object;
    private Method method;
    private Object[] methodArgs;

    SimpleFunctionCallExpr(Object object, Method method, VariantExpr[] variantExprArray) {
        this.object = object;
        this.method = method;
        this.methodArgs = new Object[3];
        this.methodArgs[0] = variantExprArray;
    }

    public Variant eval(XNode xNode, ExprContext exprContext) throws EvalException {
        this.methodArgs[1] = xNode;
        this.methodArgs[2] = exprContext;
        try {
            return (Variant)this.method.invoke(this.object, this.methodArgs);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvalException("cannot invoke '" + this.methodName() + "': illegal access");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvalException("cannot invoke '" + this.methodName() + "': illegal arguments");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof EvalException) {
                throw (EvalException)throwable;
            }
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getName();
            }
            throw new EvalException("cannot invoke '" + this.methodName() + "': " + string);
        }
        catch (ClassCastException classCastException) {
            throw new EvalException("cannot invoke '" + this.methodName() + "': does not return a Variant");
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }
}

