/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.ConvertibleExpr;
import com.xmlmind.xmledit.xpath.ConvertibleNumberExpr;
import com.xmlmind.xmledit.xpath.ConvertibleStringExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.Function;
import com.xmlmind.xmledit.xpath.NumberConstantExpr;
import com.xmlmind.xmledit.xpath.ParseException;

class SubstringFunction
implements Function {
    SubstringFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray) throws ParseException {
        if (convertibleExprArray.length < 2 || convertibleExprArray.length > 3) {
            throw new ParseException("expected 2 or 3 arguments");
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExprArray[0].makeStringExpr();
        final ConvertibleNumberExpr convertibleNumberExpr = convertibleExprArray[1].makeNumberExpr();
        final ConvertibleNumberExpr convertibleNumberExpr2 = convertibleExprArray.length == 2 ? new NumberConstantExpr(Double.POSITIVE_INFINITY) : convertibleExprArray[2].makeNumberExpr();
        return new ConvertibleStringExpr(){

            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                return SubstringFunction.substring(convertibleStringExpr.eval(xNode, exprContext), convertibleNumberExpr.eval(xNode, exprContext), convertibleNumberExpr2.eval(xNode, exprContext));
            }
        };
    }

    private static final String substring(String string, double d, double d2) {
        d = Math.floor(d + 0.5);
        double d3 = d + Math.floor(d2 + 0.5);
        int n = string.length();
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n) {
            if ((double)n2 >= d && (double)n2 < d3) {
                if (n3 < 0) {
                    n3 = n5;
                }
                if (SubstringFunction.isLowSurrogate(string.charAt(n5))) {
                    // empty if block
                }
                n4 = ++n5;
            } else if (SubstringFunction.isLowSurrogate(string.charAt(n5))) {
                ++n5;
            }
            ++n5;
            ++n2;
        }
        if (n3 >= 0) {
            return string.substring(n3, n4 + 1);
        }
        return "";
    }

    private static final boolean isLowSurrogate(char c) {
        return (c & 0xFC00) == 55296;
    }
}

