/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xpath.BooleanVariant;
import com.xmlmind.xmledit.xpath.Converter;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NodeSetVariant;
import com.xmlmind.xmledit.xpath.NumberVariant;
import com.xmlmind.xmledit.xpath.ObjectVariant;
import com.xmlmind.xmledit.xpath.SingleNodeIterator;
import com.xmlmind.xmledit.xpath.StringVariant;
import com.xmlmind.xmledit.xpath.Variant;

public abstract class VariantBase
implements Variant {
    public Variant makePermanent() throws EvalException {
        return this;
    }

    public NodeIterator convertToNodeSet() throws EvalException {
        throw new EvalException("cannot convert to node-set");
    }

    public double convertToNumber() throws EvalException {
        return Converter.toNumber(this.convertToString());
    }

    public boolean convertToPredicate(ExprContext exprContext) throws EvalException {
        return this.convertToBoolean();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNodeSet() {
        return false;
    }

    public static Variant create(Object object) {
        if (object instanceof String) {
            return new StringVariant((String)object);
        }
        if (object instanceof Number) {
            return new NumberVariant(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return new BooleanVariant((Boolean)object);
        }
        if (object instanceof NodeIterator) {
            return new NodeSetVariant((NodeIterator)object);
        }
        if (object instanceof XNode) {
            return new NodeSetVariant(new SingleNodeIterator((XNode)object));
        }
        if (object instanceof Variant) {
            return (Variant)object;
        }
        return new ObjectVariant(object);
    }
}

