/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xpath;

import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xpath.BooleanExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.NumberExpr;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.PathPattern;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.StringExpr;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantBase;
import com.xmlmind.xmledit.xpath.VariantExpr;
import java.util.ArrayList;
import java.util.HashMap;

public final class XPathUtil {
    public static String evalAsString(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsString(string, xNode, null);
    }

    public static String evalAsString(String string, XNode xNode, HashMap hashMap) throws ParseException, EvalException {
        StringExpr stringExpr = ExprParser.parseStringExpr(string, xNode.namespacePrefixMap(), true);
        return stringExpr.eval(xNode, XPathUtil.createExprContext(hashMap));
    }

    private static ExprContext createExprContext(final HashMap hashMap) {
        if (hashMap == null) {
            return new SimpleExprContext();
        }
        return new SimpleExprContext(){

            public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
                Object v = hashMap.get(name.getLocalPart());
                if (v == null) {
                    return null;
                }
                return VariantBase.create(v);
            }
        };
    }

    public static double evalAsNumber(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsNumber(string, xNode, null);
    }

    public static double evalAsNumber(String string, XNode xNode, HashMap hashMap) throws ParseException, EvalException {
        NumberExpr numberExpr = ExprParser.parseNumberExpr(string, xNode.namespacePrefixMap(), true);
        return numberExpr.eval(xNode, XPathUtil.createExprContext(hashMap));
    }

    public static boolean evalAsBoolean(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsBoolean(string, xNode, null);
    }

    public static boolean evalAsBoolean(String string, XNode xNode, HashMap hashMap) throws ParseException, EvalException {
        BooleanExpr booleanExpr = ExprParser.parseBooleanExpr(string, xNode.namespacePrefixMap(), true);
        return booleanExpr.eval(xNode, XPathUtil.createExprContext(hashMap));
    }

    public static XNode[] evalAsNodeSet(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsNodeSet(string, xNode, null);
    }

    public static XNode[] evalAsNodeSet(String string, XNode xNode, HashMap hashMap) throws ParseException, EvalException {
        XNode[] xNodeArray;
        NodeSetExpr nodeSetExpr = ExprParser.parseNodeSetExpr(string, xNode.namespacePrefixMap(), true);
        NodeIterator nodeIterator = nodeSetExpr.eval(xNode, XPathUtil.createExprContext(hashMap));
        ArrayList<XNode[]> arrayList = new ArrayList<XNode[]>();
        while ((xNodeArray = nodeIterator.next()) != null) {
            arrayList.add(xNodeArray);
        }
        xNodeArray = new XNode[arrayList.size()];
        arrayList.toArray(xNodeArray);
        return xNodeArray;
    }

    public static Variant evalAsVariant(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsVariant(string, xNode, null);
    }

    public static Variant evalAsVariant(String string, XNode xNode, HashMap hashMap) throws ParseException, EvalException {
        VariantExpr variantExpr = ExprParser.parseVariantExpr(string, xNode.namespacePrefixMap(), true);
        return variantExpr.eval(xNode, XPathUtil.createExprContext(hashMap));
    }

    public static boolean matches(XNode xNode, String string) throws ParseException, EvalException {
        return XPathUtil.matches(xNode, string, null);
    }

    public static boolean matches(XNode xNode, String string, HashMap hashMap) throws ParseException, EvalException {
        PathPattern pathPattern = ExprParser.parsePattern(string, xNode.namespacePrefixMap(), true);
        return pathPattern.matches(xNode, XPathUtil.createExprContext(hashMap));
    }
}

