/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.DateTimeUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.Date;

public class GMonthDayValue
extends Value {
    private DateTimeValue dateTime;

    public static GMonthDayValue parseGMonthDay(String string) throws InvalidDataException {
        GMonthDayValue gMonthDayValue;
        int[] nArray = new int[3];
        if (!string.startsWith("--")) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthDaySyntax", string));
        }
        int n = 2;
        int n2 = string.length();
        if (n + 2 >= n2 || string.charAt(n + 2) != '-') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthDaySyntax", string));
        }
        int n3 = DateTimeUtil.parseInt(string, n, n + 2);
        int n4 = DateTimeUtil.parseTimeZone(string, n += 3, nArray);
        if (n4 != n + 2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthDaySyntax", string));
        }
        int n5 = DateTimeUtil.parseInt(string, n, n4);
        try {
            gMonthDayValue = new GMonthDayValue(n3, n5, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthDaySyntax", string));
        }
        return gMonthDayValue;
    }

    public GMonthDayValue(int n, int n2, int n3, int n4, int n5) {
        this.dateTime = new DateTimeValue();
        this.dateTime.year = 1980;
        this.dateTime.hour = 0;
        this.dateTime.minute = 0;
        this.dateTime.second = 0.0;
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("invalid month");
        }
        if (n2 < 1 || n2 > DateTimeUtil.lastDayOfMonth(n, this.dateTime.year)) {
            throw new IllegalArgumentException("invalid day");
        }
        switch (n3) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n3 == -1 && n4 == 0 && n5 == 0) {
            n3 = 1;
        }
        this.dateTime.month = (byte)n;
        this.dateTime.day = (byte)n2;
        this.dateTime.tzSign = (byte)n3;
        this.dateTime.tzHour = (byte)n4;
        this.dateTime.tzMinute = (byte)n5;
    }

    private GMonthDayValue(DateTimeValue dateTimeValue) {
        this.dateTime = dateTimeValue;
    }

    public DateTimeValue getDateTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return this.dateTime.toDate();
    }

    public static GMonthDayValue fromDate(Date date) {
        return GMonthDayValue.fromDate(date, false);
    }

    public static GMonthDayValue fromDate(Date date, boolean bl) {
        DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, bl);
        dateTimeValue.year = 1980;
        dateTimeValue.hour = 0;
        dateTimeValue.minute = 0;
        dateTimeValue.second = 0.0;
        return new GMonthDayValue(dateTimeValue);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--");
        DateTimeUtil.appendPadded(this.dateTime.month, 2, stringBuffer);
        stringBuffer.append('-');
        DateTimeUtil.appendPadded(this.dateTime.day, 2, stringBuffer);
        DateTimeUtil.appendTimeZone(this.dateTime.tzSign, this.dateTime.tzHour, this.dateTime.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GMonthDayValue)) {
            return false;
        }
        GMonthDayValue gMonthDayValue = (GMonthDayValue)object;
        return this.dateTime.equals(gMonthDayValue.dateTime);
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof GMonthDayValue)) {
            return -2;
        }
        GMonthDayValue gMonthDayValue = (GMonthDayValue)value;
        return this.dateTime.compareTo(gMonthDayValue.dateTime);
    }
}

