/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.doctype.UnparsedEntities;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Pattern;
import com.xmlmind.xmledit.xsd.datatype.Value;

public class Restriction {
    private DataType type;

    public Restriction(DataType dataType) {
        this.type = dataType.copy();
        this.type.baseType = dataType;
    }

    public DataType getBaseType() {
        return this.type.baseType;
    }

    public void setLength(int n, boolean bl) throws InvalidTypeException {
        if (n < 0) {
            throw new IllegalArgumentException("negative length");
        }
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 1) != 0 && n != dataType.length) {
            throw new InvalidTypeException("length-valid-restriction", Msg.msg("badLengthFacet"));
        }
        Restriction.setFacet(this.type, 1, bl);
        this.type.length = n;
    }

    private static void setFacet(DataType dataType, int n, boolean bl) throws InvalidTypeException {
        if ((dataType.getSupportedFacets() & n) == 0) {
            throw new InvalidTypeException("cos-applicable-facets", Msg.msg("unsupportedFacet", DataType.getFacetName(n)));
        }
        dataType.facets |= n;
        if (bl) {
            dataType.fixedFacets |= n;
        }
    }

    public void setMinLength(int n, boolean bl) throws InvalidTypeException {
        if (n < 0) {
            throw new IllegalArgumentException("negative minLength");
        }
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 2) != 0) {
            if ((dataType.fixedFacets & 2) != 0 && n != dataType.minLength) {
                throw new InvalidTypeException("x-minLength-valid-restriction", Msg.msg("fixedFacet", "minLength"));
            }
            if (n < dataType.minLength) {
                throw new InvalidTypeException("minLength-valid-restriction", Msg.msg("badMinLengthFacet"));
            }
        }
        Restriction.setFacet(this.type, 2, bl);
        this.type.minLength = n;
    }

    public void setMaxLength(int n, boolean bl) throws InvalidTypeException {
        if (n < 0) {
            throw new IllegalArgumentException("negative maxLength");
        }
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 4) != 0) {
            if ((dataType.fixedFacets & 4) != 0 && n != dataType.maxLength) {
                throw new InvalidTypeException("x-maxLength-valid-restriction", Msg.msg("fixedFacet", "maxLength"));
            }
            if (n > dataType.maxLength) {
                throw new InvalidTypeException("maxLength-valid-restriction", Msg.msg("badMaxLengthFacet"));
            }
        }
        Restriction.setFacet(this.type, 4, bl);
        this.type.maxLength = n;
    }

    public void setPattern(Pattern pattern) throws InvalidTypeException {
        Restriction.setFacet(this.type, 8, false);
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 8) != 0) {
            this.type.pattern = new Pattern[dataType.pattern.length + 1];
            System.arraycopy(dataType.pattern, 0, this.type.pattern, 0, dataType.pattern.length);
            this.type.pattern[dataType.pattern.length] = pattern;
        } else {
            this.type.pattern = new Pattern[]{pattern};
        }
    }

    public void setEnumeration(String[] stringArray, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException, InvalidTypeException {
        Value[] valueArray = new Value[stringArray.length];
        DataType dataType = this.type.baseType;
        int n = 0;
        while (n < stringArray.length) {
            valueArray[n] = dataType.valueOf(stringArray[n], prefixToNamespace, unparsedEntities);
            ++n;
        }
        this.setEnumeration(valueArray);
    }

    public void setEnumeration(Value[] valueArray) throws InvalidTypeException {
        Restriction.setFacet(this.type, 16, false);
        this.type.enumeration = valueArray;
    }

    public void setWhiteSpace(int n, boolean bl) throws InvalidTypeException {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid whiteSpace");
        }
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x20) != 0) {
            if ((dataType.fixedFacets & 0x20) != 0 && n != dataType.whiteSpace) {
                throw new InvalidTypeException("x-whiteSpace-valid-restriction", Msg.msg("fixedFacet", "whiteSpace"));
            }
            boolean bl2 = false;
            switch (dataType.whiteSpace) {
                case 2: {
                    switch (n) {
                        case 0: 
                        case 1: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                case 1: {
                    if (n != 0) break;
                    bl2 = true;
                }
            }
            if (bl2) {
                throw new InvalidTypeException("whiteSpace-valid-restriction", Msg.msg("badWhiteSpaceFacet"));
            }
        }
        Restriction.setFacet(this.type, 32, bl);
        this.type.whiteSpace = n;
    }

    public void setMaxInclusive(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, boolean bl) throws InvalidDataException, InvalidTypeException {
        Value value = this.type.getRootType().valueOf(string, prefixToNamespace, unparsedEntities);
        this.setMaxInclusive(value, bl);
    }

    public void setMaxInclusive(Value value, boolean bl) throws InvalidTypeException {
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x40) != 0) {
            if ((dataType.fixedFacets & 0x40) != 0 && !value.equals(dataType.maxInclusive)) {
                throw new InvalidTypeException("x-maxInclusive-valid-restriction", Msg.msg("fixedFacet", "maxInclusive"));
            }
            if (!value.isLE(dataType.maxInclusive)) {
                throw new InvalidTypeException("maxInclusive-valid-restriction.1", Msg.msg("maxInclusiveGTParentMaxInclusive"));
            }
        }
        if ((dataType.facets & 0x80) != 0 && !value.isLT(dataType.maxExclusive)) {
            throw new InvalidTypeException("maxInclusive-valid-restriction.2", Msg.msg("maxInclusiveGEParentMaxExclusive"));
        }
        if ((dataType.facets & 0x200) != 0 && !value.isGE(dataType.minInclusive)) {
            throw new InvalidTypeException("maxInclusive-valid-restriction.3", Msg.msg("maxInclusiveLTParentMinInclusive"));
        }
        if ((dataType.facets & 0x100) != 0 && !value.isGT(dataType.minExclusive)) {
            throw new InvalidTypeException("maxInclusive-valid-restriction.4", Msg.msg("maxInclusiveLEParentMinExclusive"));
        }
        Restriction.setFacet(this.type, 64, bl);
        this.type.maxInclusive = value;
    }

    public void setMaxExclusive(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, boolean bl) throws InvalidDataException, InvalidTypeException {
        Value value = this.type.getRootType().valueOf(string, prefixToNamespace, unparsedEntities);
        this.setMaxExclusive(value, bl);
    }

    public void setMaxExclusive(Value value, boolean bl) throws InvalidTypeException {
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x80) != 0) {
            if ((dataType.fixedFacets & 0x80) != 0 && !value.equals(dataType.maxExclusive)) {
                throw new InvalidTypeException("x-maxExclusive-valid-restriction", Msg.msg("fixedFacet", "maxExclusive"));
            }
            if ((dataType.facets & 0x80) != 0 && !value.isLE(dataType.maxExclusive)) {
                throw new InvalidTypeException("maxExclusive-valid-restriction.1", Msg.msg("maxExclusiveGTParentMaxExclusive"));
            }
        }
        if ((dataType.facets & 0x40) != 0 && !value.isLE(dataType.maxInclusive)) {
            throw new InvalidTypeException("maxExclusive-valid-restriction.2", Msg.msg("maxExclusiveGTParentMaxInclusive"));
        }
        if ((dataType.facets & 0x200) != 0 && !value.isGT(dataType.minInclusive)) {
            throw new InvalidTypeException("maxExclusive-valid-restriction.3", Msg.msg("maxExclusiveLEParentMinInclusive"));
        }
        if ((dataType.facets & 0x100) != 0 && !value.isGT(dataType.minExclusive)) {
            throw new InvalidTypeException("maxExclusive-valid-restriction.4", Msg.msg("maxExclusiveLEParentMinExclusive"));
        }
        Restriction.setFacet(this.type, 128, bl);
        this.type.maxExclusive = value;
    }

    public void setMinExclusive(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, boolean bl) throws InvalidDataException, InvalidTypeException {
        Value value = this.type.getRootType().valueOf(string, prefixToNamespace, unparsedEntities);
        this.setMinExclusive(value, bl);
    }

    public void setMinExclusive(Value value, boolean bl) throws InvalidTypeException {
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x100) != 0) {
            if ((dataType.fixedFacets & 0x100) != 0 && !value.equals(dataType.minExclusive)) {
                throw new InvalidTypeException("x-minExclusive-valid-restriction", Msg.msg("fixedFacet", "minExclusive"));
            }
            if ((dataType.facets & 0x100) != 0 && !value.isGE(dataType.minExclusive)) {
                throw new InvalidTypeException("minExclusive-valid-restriction.1", Msg.msg("minExclusiveLTParentMinExclusive"));
            }
        }
        if ((dataType.facets & 0x40) != 0 && !value.isLE(dataType.maxInclusive)) {
            throw new InvalidTypeException("minExclusive-valid-restriction.2", Msg.msg("minExclusiveGTParentMaxInclusive"));
        }
        if ((dataType.facets & 0x200) != 0 && !value.isGE(dataType.minInclusive)) {
            throw new InvalidTypeException("minExclusive-valid-restriction.3", Msg.msg("minExclusiveLTParentMinInclusive"));
        }
        if ((dataType.facets & 0x80) != 0 && !value.isLT(dataType.maxExclusive)) {
            throw new InvalidTypeException("minExclusive-valid-restriction.4", Msg.msg("minExclusiveGEParentMaxExclusive"));
        }
        Restriction.setFacet(this.type, 256, bl);
        this.type.minExclusive = value;
    }

    public void setMinInclusive(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, boolean bl) throws InvalidDataException, InvalidTypeException {
        Value value = this.type.getRootType().valueOf(string, prefixToNamespace, unparsedEntities);
        this.setMinInclusive(value, bl);
    }

    public void setMinInclusive(Value value, boolean bl) throws InvalidTypeException {
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x200) != 0) {
            if ((dataType.fixedFacets & 0x200) != 0 && !value.equals(dataType.minInclusive)) {
                throw new InvalidTypeException("x-minInclusive-valid-restriction", Msg.msg("fixedFacet", "minInclusive"));
            }
            if ((dataType.facets & 0x200) != 0 && !value.isGE(dataType.minInclusive)) {
                throw new InvalidTypeException("minInclusive-valid-restriction.1", Msg.msg("minInclusiveLTParentMinInclusive"));
            }
        }
        if ((dataType.facets & 0x40) != 0 && !value.isLE(dataType.maxInclusive)) {
            throw new InvalidTypeException("minInclusive-valid-restriction.2", Msg.msg("minInclusiveGTParentMaxInclusive"));
        }
        if ((dataType.facets & 0x100) != 0 && !value.isGT(dataType.minExclusive)) {
            throw new InvalidTypeException("minInclusive-valid-restriction.3", Msg.msg("minInclusiveLEParentMinExclusive"));
        }
        if ((dataType.facets & 0x80) != 0 && !value.isLT(dataType.maxExclusive)) {
            throw new InvalidTypeException("minInclusive-valid-restriction.4", Msg.msg("minInclusiveGEParentMaxExclusive"));
        }
        Restriction.setFacet(this.type, 512, bl);
        this.type.minInclusive = value;
    }

    public void setTotalDigits(int n, boolean bl) throws InvalidTypeException {
        if (n <= 0) {
            throw new IllegalArgumentException("negative or null totalDigits");
        }
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x400) != 0) {
            if ((dataType.fixedFacets & 0x400) != 0 && n != dataType.totalDigits) {
                throw new InvalidTypeException("x-totalDigits-valid-restriction", Msg.msg("fixedFacet", "totalDigits"));
            }
            if (n > dataType.totalDigits) {
                throw new InvalidTypeException("totalDigits-valid-restriction", Msg.msg("badTotalDigitsFacet"));
            }
        }
        Restriction.setFacet(this.type, 1024, bl);
        this.type.totalDigits = n;
    }

    public void setFractionDigits(int n, boolean bl) throws InvalidTypeException {
        if (n < 0) {
            throw new IllegalArgumentException("negative fractionDigits");
        }
        DataType dataType = this.type.baseType;
        if ((dataType.facets & 0x800) != 0 && (dataType.fixedFacets & 0x800) != 0 && n != dataType.fractionDigits) {
            throw new InvalidTypeException("x-fractionDigits-valid-restriction", Msg.msg("fixedFacet", "fractionDigits"));
        }
        Restriction.setFacet(this.type, 2048, bl);
        this.type.fractionDigits = n;
    }

    public DataType derive() throws InvalidTypeException {
        return this.derive(null);
    }

    public DataType derive(Object object) throws InvalidTypeException {
        Restriction.checkFacets(this.type);
        this.type.checkFacets();
        DataType dataType = this.type;
        this.type = null;
        dataType.properties = object;
        return dataType;
    }

    private static void checkFacets(DataType dataType) throws InvalidTypeException {
        int n;
        if ((dataType.facets & 1) != 0 && ((dataType.facets & 2) != 0 || (dataType.facets & 4) != 0)) {
            throw new InvalidTypeException("length-minLength-maxLength", Msg.msg("lengthMinLengthBothSpecified"));
        }
        if ((dataType.facets & 2) != 0 && (dataType.facets & 4) != 0 && dataType.minLength > dataType.maxLength) {
            throw new InvalidTypeException("minLength-less-than-equal-to-maxLength", Msg.msg("minLengthGreaterThanMaxLength"));
        }
        if ((dataType.facets & 0x200) != 0 && (dataType.facets & 0x100) != 0) {
            throw new InvalidTypeException("minInclusive-minExclusive", Msg.msg("minInclusiveMinExclusiveBothSpecified"));
        }
        if ((dataType.facets & 0x40) != 0 && (dataType.facets & 0x80) != 0) {
            throw new InvalidTypeException("maxInclusive-maxExclusive", Msg.msg("maxInclusiveMaxExclusiveBothSpecified"));
        }
        if ((dataType.facets & 0x200) != 0 && (dataType.facets & 0x40) != 0 && (n = dataType.minInclusive.compareTo(dataType.maxInclusive)) != -1 && n != 0) {
            throw new InvalidTypeException("minInclusive-less-than-equal-to-maxInclusive", Msg.msg("minInclusiveNotLEMaxInclusive"));
        }
        if ((dataType.facets & 0x100) != 0 && (dataType.facets & 0x80) != 0 && (n = dataType.minExclusive.compareTo(dataType.maxExclusive)) != -1 && n != 0) {
            throw new InvalidTypeException("minExclusive-less-than-equal-to-maxExclusive", Msg.msg("minExclusiveNotLEMaxExclusive"));
        }
        if ((dataType.facets & 0x100) != 0 && (dataType.facets & 0x40) != 0 && dataType.minExclusive.compareTo(dataType.maxInclusive) != -1) {
            throw new InvalidTypeException("minExclusive-less-than-maxInclusive", Msg.msg("minExclusiveNotLTMaxInclusive"));
        }
        if ((dataType.facets & 0x200) != 0 && (dataType.facets & 0x80) != 0 && dataType.minInclusive.compareTo(dataType.maxExclusive) != -1) {
            throw new InvalidTypeException("minInclusive-less-than-maxExclusive", Msg.msg("minInclusiveNotLTMaxExclusive"));
        }
        if ((dataType.facets & 0x400) != 0 && (dataType.facets & 0x800) != 0 && dataType.fractionDigits > dataType.totalDigits) {
            throw new InvalidTypeException("fractionDigits-totalDigits", Msg.msg("fractionDigitsGreaterThanTotalDigits"));
        }
    }
}

