/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.dtdtoxsd;

import com.jclark.xml.parse.AttributeDefinition;
import com.jclark.xml.parse.ElementType;
import com.jclark.xml.parse.EndPrologEvent;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.io.Application;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.ParserImpl;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.ENTITIESType;
import com.xmlmind.xmledit.xsd.datatype.ENTITYType;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.NMTOKENSType;
import com.xmlmind.xmledit.xsd.datatype.NMTOKENType;
import com.xmlmind.xmledit.xsd.datatype.NOTATIONType;
import com.xmlmind.xmledit.xsd.datatype.Restriction;
import com.xmlmind.xmledit.xsd.datatype.StringType;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTD;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDUtil;
import com.xmlmind.xmledit.xsd.dtdtoxsd.Msg;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.Notation;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.ParticleParser;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.Wildcard;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class DTDLoader {
    private ParticleParser particleParser = new ParticleParser(true);
    private DTD schema;
    private Hashtable attributeEntries;
    private AttributeEntry attributeProbe;
    private Hashtable undeclaredElementNames;
    private Vector errors;
    private String[] errorList;
    private Vector warnings;
    private String[] warningList;
    private static final String[] NO_MESSAGES = new String[0];
    private static final SequenceParticle ANY_SEQUENCE = new SequenceParticle(new Particle[]{new WildcardParticle(Wildcard.ANY, 1, 1)}, 0, -1);

    public DTD load(File file) throws IOException {
        return this.load(FileUtil.fileToURL(file));
    }

    public DTD load(URL uRL) throws IOException {
        final com.jclark.xml.parse.DTD[] dTDArray = new com.jclark.xml.parse.DTD[1];
        ParserImpl parserImpl = new ParserImpl();
        parserImpl.setApplication((Application)new ApplicationImpl(){

            public void endProlog(EndPrologEvent endPrologEvent) throws IOException {
                dTDArray[0] = endPrologEvent.getDTD();
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8' ?>\n");
        stringBuffer.append("<!DOCTYPE dummy SYSTEM ");
        String string = uRL.toExternalForm();
        char c = string.indexOf(34) < 0 ? (char)'\"' : '\'';
        stringBuffer.append(c);
        stringBuffer.append(string);
        stringBuffer.append(c);
        stringBuffer.append(">\n");
        stringBuffer.append("<dummy/>\n");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        URL uRL2 = FileUtil.fileToURL("bytes");
        OpenEntity openEntity = new OpenEntity((InputStream)byteArrayInputStream, uRL2.toExternalForm(), uRL2);
        parserImpl.parseDocument(openEntity);
        if (!DTDUtil.isGrammar(dTDArray[0])) {
            return null;
        }
        return this.load(dTDArray[0]);
    }

    public DTD load(com.jclark.xml.parse.DTD dTD) {
        DTD dTD2;
        this.schema = new DTD(DTDUtil.getDocumentTypeName(dTD), DTDUtil.getPublicId(dTD), DTDUtil.getSystemId(dTD), DTDUtil.getExternalSubsetURL(dTD));
        this.schema.setSourceURLs(DTDUtil.getSourceURLs(dTD));
        this.attributeEntries = new Hashtable();
        this.attributeProbe = new AttributeEntry();
        this.undeclaredElementNames = new Hashtable();
        this.errors = new Vector();
        this.errorList = null;
        this.warnings = new Vector();
        this.warningList = null;
        this.addNotations(dTD);
        this.addElementTypes(dTD);
        this.checkUndeclaredElements();
        int n = this.errors.size();
        if (n == 0) {
            dTD2 = this.schema;
            this.errorList = NO_MESSAGES;
        } else {
            dTD2 = null;
            this.errorList = new String[n];
            this.errors.copyInto(this.errorList);
        }
        int n2 = this.warnings.size();
        if (n2 == 0) {
            this.warningList = NO_MESSAGES;
        } else {
            this.warningList = new String[n2];
            this.warnings.copyInto(this.warningList);
        }
        this.schema = null;
        this.attributeEntries = null;
        this.attributeProbe = null;
        this.undeclaredElementNames = null;
        this.errors = null;
        this.warnings = null;
        return dTD2;
    }

    public String[] getErrors() {
        return this.errorList;
    }

    public String[] getWarnings() {
        return this.warningList;
    }

    private void addNotations(com.jclark.xml.parse.DTD dTD) {
        Enumeration enumeration = dTD.entityNames((byte)2);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Entity entity = dTD.getEntity((byte)2, string);
            Name name = Name.get(string);
            if (this.schema.getNotation(name) != null) {
                this.errors.addElement(Msg.msg("notationAlreadyDeclared", string));
                continue;
            }
            Notation notation = new Notation(name, entity.getPublicId(), entity.getSystemId(), entity.getBase());
            this.schema.addNotation(notation);
        }
    }

    private void addElementTypes(com.jclark.xml.parse.DTD dTD) {
        Enumeration enumeration = dTD.elementTypeNames();
        block9: while (enumeration.hasMoreElements()) {
            int n;
            Object object;
            Serializable serializable;
            Object object2;
            String string = (String)enumeration.nextElement();
            Name name = Name.get(string);
            ElementType elementType = dTD.getElementType(string);
            ComplexType complexType = new ComplexType(null, ComplexType.ANY, 1, false, 0, 0);
            boolean bl = false;
            switch (elementType.getContentType()) {
                case -1: {
                    this.undeclaredElementNames.put(name, name);
                    this.warnings.addElement(Msg.msg("undeclaredElementType", string));
                    continue block9;
                }
                case 2: {
                    break;
                }
                case 0: {
                    complexType.setContentType(ANY_SEQUENCE, true);
                    break;
                }
                case 1: {
                    bl = true;
                }
                case 3: {
                    object2 = elementType.getContentSpec();
                    try {
                        serializable = bl ? this.particleParser.parseMixedContent((String)object2) : this.particleParser.parseElementContent((String)object2);
                        complexType.setContentType((Particle)serializable, bl);
                    }
                    catch (ParticleParser.ParseException parseException) {
                        this.errors.addElement(Msg.msg("invalidContentSpec", object2, string, parseException.getMessage()));
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unknown content type " + elementType.getContentType());
                }
            }
            serializable = new Vector();
            object2 = new int[2];
            Enumeration enumeration2 = elementType.attributeNames();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                object = elementType.getAttributeDefinition(string2);
                this.declareAttribute(string, string2, (AttributeDefinition)object, complexType, (Vector)serializable, (int[])object2);
            }
            if (object2[0] > true) {
                this.errors.addElement(Msg.msg("elementTypeWithSeveralIds", string));
            }
            if (object2[1] > true) {
                this.errors.addElement(Msg.msg("elementTypeWithSeveralNotations", string));
            }
            if ((n = ((Vector)serializable).size()) > 0) {
                object = new AttributeUse[n];
                ((Vector)serializable).copyInto((Object[])object);
                complexType.setAttributeUses((AttributeUse[])object);
            }
            if (this.schema.getElementDeclaration(name) != null) {
                this.errors.addElement(Msg.msg("elementTypeAlreadyDeclared", string));
                continue;
            }
            object = new ElementDeclaration(name, complexType, null, false, false, 0, false);
            this.schema.addElementDeclaration((ElementDeclaration)object);
        }
    }

    private void declareAttribute(String string, String string2, AttributeDefinition attributeDefinition, ComplexType complexType, Vector vector, int[] nArray) {
        Serializable serializable;
        Object object;
        Object[] objectArray;
        boolean bl;
        boolean bl2;
        byte by = attributeDefinition.getType();
        String string3 = attributeDefinition.getDefaultValue();
        if (attributeDefinition.isRequired()) {
            if (string3 == null) {
                bl2 = true;
                bl = false;
            } else {
                bl2 = false;
                bl = true;
            }
        } else {
            bl2 = false;
            bl = false;
        }
        Enumeration enumeration = attributeDefinition.allowedValues();
        if (enumeration == null) {
            objectArray = null;
        } else {
            object = new Vector();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (by == 9 && this.schema.getNotation((Name)(serializable = Name.get(string4))) == null) {
                    this.errors.addElement(Msg.msg("undeclaredNotationInAttribute", string4, string2, string));
                    continue;
                }
                ((Vector)object).addElement(string4);
            }
            int n = ((Vector)object).size();
            if (n > 0) {
                objectArray = new String[n];
                ((Vector)object).copyInto(objectArray);
            } else {
                objectArray = null;
            }
        }
        switch (by) {
            case 1: {
                if (string3 != null) {
                    this.errors.addElement(Msg.msg("idAttributeWithDefault", string2, string));
                }
                nArray[0] = nArray[0] + 1;
                break;
            }
            case 9: {
                if (complexType.getContentType() == 0) {
                    this.errors.addElement(Msg.msg("emptyContentWithNotationAttribute", string, string2));
                }
                nArray[1] = nArray[1] + 1;
            }
        }
        object = this.getAttributeEntry(string, string2, by, (String[])objectArray, string3, bl, bl2);
        if (object == null) {
            return;
        }
        AttributeDeclaration attributeDeclaration = ((AttributeEntry)object).declaration;
        serializable = ((AttributeEntry)object).use;
        if (complexType.getAttributeDeclaration(attributeDeclaration.getName()) != null) {
            this.warnings.addElement(Msg.msg("attributeAlreadyDeclared", string2, string));
        } else {
            complexType.addAttributeDeclaration(attributeDeclaration);
            vector.addElement(serializable);
        }
    }

    private AttributeEntry getAttributeEntry(String string, String string2, int n, String[] stringArray, String string3, boolean bl, boolean bl2) {
        this.attributeProbe.init(string2, n, stringArray, string3, bl, bl2);
        AttributeEntry attributeEntry = (AttributeEntry)this.attributeEntries.get(this.attributeProbe);
        if (attributeEntry == null) {
            Value[] valueArray;
            DataType dataType;
            switch (n) {
                case 1: {
                    dataType = IDType.BASE;
                    break;
                }
                case 2: {
                    dataType = IDREFType.BASE;
                    break;
                }
                case 3: {
                    dataType = IDREFSType.BASE;
                    break;
                }
                case 4: {
                    dataType = ENTITYType.BASE;
                    break;
                }
                case 5: {
                    dataType = ENTITIESType.BASE;
                    break;
                }
                case 6: {
                    dataType = NMTOKENType.BASE;
                    break;
                }
                case 7: {
                    dataType = NMTOKENSType.BASE;
                    break;
                }
                case 9: {
                    valueArray = new Value[stringArray.length];
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        try {
                            valueArray[n2] = NOTATIONType.BASE.valueOf(stringArray[n2], null);
                        }
                        catch (InvalidDataException invalidDataException) {
                            this.errors.addElement(Msg.msg("invalidEnumValue", stringArray[n2], string2, string, invalidDataException.getMessage()));
                            return null;
                        }
                        ++n2;
                    }
                    Restriction restriction = new Restriction(NOTATIONType.BASE);
                    try {
                        restriction.setEnumeration(valueArray);
                        dataType = restriction.derive();
                        break;
                    }
                    catch (InvalidTypeException invalidTypeException) {
                        invalidTypeException.printStackTrace();
                        return null;
                    }
                }
                case 8: {
                    valueArray = new Value[stringArray.length];
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        try {
                            valueArray[n2] = NMTOKENType.BASE.valueOf(stringArray[n2], null);
                        }
                        catch (InvalidDataException invalidDataException) {
                            this.errors.addElement(Msg.msg("invalidEnumValue", stringArray[n2], string2, string, invalidDataException.getMessage()));
                            return null;
                        }
                        ++n2;
                    }
                    Restriction restriction = new Restriction(NMTOKENType.BASE);
                    try {
                        restriction.setEnumeration(valueArray);
                        dataType = restriction.derive();
                        break;
                    }
                    catch (InvalidTypeException invalidTypeException) {
                        invalidTypeException.printStackTrace();
                        return null;
                    }
                }
                default: {
                    dataType = StringType.BASE;
                }
            }
            if (string3 == null) {
                valueArray = null;
            } else {
                try {
                    valueArray = dataType.valueOf(string3, null);
                }
                catch (InvalidDataException invalidDataException) {
                    this.errors.addElement(Msg.msg("invalidDefaultValue", string3, string2, string, invalidDataException.getMessage()));
                    return null;
                }
            }
            attributeEntry = new AttributeEntry(string2, n, stringArray, string3, bl, bl2);
            Name name = Name.parse(string2, true, null);
            if (name == null) {
                name = Name.get(string2);
            }
            attributeEntry.declaration = new AttributeDeclaration(name, dataType, (Value)valueArray, bl);
            attributeEntry.use = new AttributeUse(name, bl2);
            this.attributeEntries.put(attributeEntry, attributeEntry);
        }
        return attributeEntry;
    }

    private void checkUndeclaredElements() {
        Enumeration enumeration = this.schema.getElementDeclarations();
        while (enumeration.hasMoreElements()) {
            ElementDeclaration elementDeclaration = (ElementDeclaration)enumeration.nextElement();
            Particle particle = ((ComplexType)elementDeclaration.getType()).getParticle();
            if (particle == null) continue;
            this.traverseParticle(particle);
        }
    }

    private void traverseParticle(Particle particle) {
        switch (particle.getType()) {
            case 3: {
                Name name = ((ElementParticle)particle).getElementName();
                if (this.schema.getElementDeclaration(name) != null || this.undeclaredElementNames.contains(name)) break;
                this.undeclaredElementNames.put(name, name);
                this.warnings.addElement(Msg.msg("undeclaredElementType", name.getLocalPart()));
                break;
            }
            case 0: {
                this.traverseParticles(((SequenceParticle)particle).getParticles());
                break;
            }
            case 1: {
                this.traverseParticles(((ChoiceParticle)particle).getParticles());
                break;
            }
            case 2: {
                this.traverseParticles(((AllParticle)particle).getParticles());
            }
        }
    }

    private void traverseParticles(Particle[] particleArray) {
        int n = 0;
        while (n < particleArray.length) {
            this.traverseParticle(particleArray[n]);
            ++n;
        }
    }

    private static final class AttributeEntry {
        public String name;
        public int type;
        public String[] enumValues;
        public String defaultValue;
        public boolean isFixedValue;
        public boolean required;
        public AttributeDeclaration declaration;
        public AttributeUse use;

        public AttributeEntry() {
        }

        public AttributeEntry(String string, int n, String[] stringArray, String string2, boolean bl, boolean bl2) {
            this.init(string, n, stringArray, string2, bl, bl2);
        }

        public void init(String string, int n, String[] stringArray, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.type = n;
            this.enumValues = stringArray;
            this.defaultValue = string2;
            this.isFixedValue = bl;
            this.required = bl2;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AttributeEntry)) {
                return false;
            }
            AttributeEntry attributeEntry = (AttributeEntry)object;
            if (this.type != attributeEntry.type || this.isFixedValue != attributeEntry.isFixedValue || this.required != attributeEntry.required || !this.name.equals(attributeEntry.name)) {
                return false;
            }
            if (this.defaultValue == null && attributeEntry.defaultValue != null || this.defaultValue != null && !this.defaultValue.equals(attributeEntry.defaultValue)) {
                return false;
            }
            if (this.enumValues == null && attributeEntry.enumValues != null || this.enumValues != null && (attributeEntry.enumValues == null || attributeEntry.enumValues.length != this.enumValues.length)) {
                return false;
            }
            if (this.enumValues != null) {
                int n = 0;
                while (n < this.enumValues.length) {
                    if (!this.enumValues[n].equals(attributeEntry.enumValues[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
    }
}

