/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.Wildcard;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.util.Hashtable;

final class AnyInfo
extends Info {
    public Wildcard wildcard = Wildcard.ANY;
    public int minOccurs = 1;
    public int maxOccurs = 1;

    public AnyInfo(Info info) {
        super(info);
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        NameWildcard nameWildcard = Info.getNameWildcardAttribute(element, Info._NAMESPACE, schemaInfo.targetNamespace, null);
        int n = Info.getProcessContentsAttribute(element, Info._PROCESS_CONTENTS, -1);
        this.minOccurs = Info.getNonNegativeIntAttribute(element, Info._MIN_OCCURS, 1);
        this.maxOccurs = Info.getMaxOccursAttribute(element, Info._MAX_OCCURS, 1);
        if (nameWildcard != null || n != -1) {
            if (nameWildcard == null) {
                nameWildcard = NameWildcard.ANY;
            }
            if (n == -1) {
                n = 0;
            }
            this.wildcard = new Wildcard(nameWildcard, n);
        }
    }

    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        particleArray[n] = this.minOccurs == 0 && this.maxOccurs == 0 ? null : new WildcardParticle(this.wildcard, this.minOccurs, this.maxOccurs);
        return true;
    }

    public boolean toParticle2(Hashtable hashtable, LoadState loadState) {
        return true;
    }
}

