/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.RedefineInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SimpleTypeInfo;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import java.util.Vector;

final class AttributeInfo
extends Info {
    public Name ref = null;
    public String default_ = null;
    public String fixed = null;
    public int use = 0;
    public Name type = null;
    public SimpleTypeInfo typeInfo = null;

    public AttributeInfo(Info info) {
        super(info);
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        Element element2;
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        Namespace namespace = this.getTargetNamespace(element, true, schemaInfo);
        this.name = Info.getNCNameAttribute(element, Info._NAME, namespace, null);
        this.ref = this.getQNameAttribute(element, Info._REF, null);
        if (this.ref != null) {
            this.checkImportedNamespaces(this.ref, schemaInfo, schemaErrors2);
        }
        this.default_ = element.getAttribute(Info._DEFAULT);
        this.fixed = element.getAttribute(Info._FIXED);
        this.use = Info.getUseAttribute(element, Info._USE, 0);
        this.type = this.getQNameAttribute(element, Info._TYPE, null);
        if (this.type != null) {
            this.checkImportedNamespaces(this.type, schemaInfo, schemaErrors2);
        }
        if ((element2 = Info.getChild(element, Info.XSD_SIMPLE_TYPE)) != null) {
            this.typeInfo = new SimpleTypeInfo(this);
            this.typeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
        if (this.default_ != null && this.fixed != null) {
            schemaErrors2.append(this, "src-attribute.1", "inconsistentFixed");
        }
        if (this.default_ != null && this.use != 0) {
            schemaErrors2.append(this, "src-attribute.2", "inconsistentUse");
        }
        if (!(this.parent instanceof SchemaInfo) && !(this.parent instanceof RedefineInfo)) {
            if (this.name == null && this.ref == null) {
                schemaErrors2.append(this, "src-attribute.3.1", "missingName");
            } else if (this.name != null && this.ref != null) {
                schemaErrors2.append(this, "src-attribute.3.1", "inconsistentName");
            }
            if (this.ref != null && (this.typeInfo != null || element.hasAttribute(Info._FORM) || this.type != null)) {
                schemaErrors2.append(this, "src-attribute.3.2", "inconsistentForm");
            }
        }
        if (this.type != null && this.typeInfo != null) {
            schemaErrors2.append(this, "src-attribute.4", "inconsistentType");
        }
    }

    public AttributeDeclaration toAttributeDeclaration(LoadState loadState) {
        if (this.name.getNamespace() == Namespace.XSI) {
            loadState.errors.append(this, "no-xsi", "xsiAttributeDeclaration");
            return null;
        }
        SimpleType simpleType = this.typeInfo != null ? (SimpleType)this.typeInfo.toType(loadState) : (this.type != null ? loadState.getSimpleType(this.type, this, "a-props-correct.1") : SimpleType.ANY);
        if (simpleType == null) {
            return null;
        }
        DataType dataType = simpleType.getDataType();
        Value value = null;
        boolean bl = false;
        if (this.default_ != null || this.fixed != null) {
            String string;
            if (this.fixed != null) {
                string = this.fixed;
                bl = true;
            } else {
                string = this.default_;
            }
            try {
                value = dataType.valueOf(string, this);
            }
            catch (InvalidDataException invalidDataException) {
                loadState.errors.append(this, "a-props-correct.2", "invalidValueConstraint", string, invalidDataException.getMessage(), invalidDataException.getConstraint());
                return null;
            }
            if (dataType instanceof IDType) {
                loadState.errors.append(this, "a-props-correct.3", "idWithDefault", "attribute");
                return null;
            }
        }
        return new AttributeDeclaration(this.name, dataType, value, bl);
    }

    public boolean toAttributeUse(Vector vector, Vector vector2, ComplexType complexType, LoadState loadState) {
        if (this.use == 2) {
            vector2.addElement(this.ref == null ? this.name : this.ref);
            return true;
        }
        if (this.ref == null) {
            AttributeDeclaration attributeDeclaration = this.toAttributeDeclaration(loadState);
            if (attributeDeclaration == null) {
                return false;
            }
            complexType.addAttributeDeclaration(attributeDeclaration);
            vector.addElement(new AttributeUse(this.name, this.use == 1));
        } else {
            AttributeDeclaration attributeDeclaration = loadState.getAttributeDeclaration(this.ref, this, "au-props-correct.1");
            if (attributeDeclaration == null) {
                return false;
            }
            DataType dataType = attributeDeclaration.getDataType();
            Value value = null;
            boolean bl = false;
            if (this.default_ != null || this.fixed != null) {
                String string;
                if (this.fixed != null) {
                    string = this.fixed;
                    bl = true;
                } else {
                    string = this.default_;
                }
                try {
                    value = dataType.valueOf(string, this);
                }
                catch (InvalidDataException invalidDataException) {
                    loadState.errors.append(this, "au-props-correct.1", "invalidValueConstraint", string, invalidDataException.getMessage(), invalidDataException.getConstraint());
                    return false;
                }
                Value value2 = attributeDeclaration.getDefaultValue();
                boolean bl2 = attributeDeclaration.isFixedValue();
                if (bl2 && bl && !value2.equals(value)) {
                    loadState.errors.append(this, "au-props-correct.2", "inconsistentFixedValue", string, this.ref.format(false, this));
                    return false;
                }
                if (bl2 != bl || value2 == null || !value2.equals(value)) {
                    complexType.addAttributeDeclaration(new AttributeDeclaration(this.ref, dataType, value, bl));
                }
            }
            vector.addElement(new AttributeUse(this.ref, this.use == 1));
        }
        return true;
    }
}

