/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Path;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.validate.IdentityConstraint;

abstract class IdentityConstraintInfo
extends Info {
    public XPath selector = null;
    public XPath[] fields = null;

    protected IdentityConstraintInfo(Info info) {
        super(info);
    }

    public void add(XPath xPath) {
        if (this.fields == null) {
            this.fields = new XPath[]{xPath};
            return;
        }
        XPath[] xPathArray = new XPath[this.fields.length + 1];
        System.arraycopy(this.fields, 0, xPathArray, 0, this.fields.length);
        xPathArray[this.fields.length] = xPath;
        this.fields = xPathArray;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = Info.getNCNameAttribute(element, Info._NAME, schemaInfo.targetNamespace, null);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                String string;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_FIELD) {
                    string = element2.getAttribute(Info._XPATH);
                    if (string != null) {
                        XPath xPath = XPath.fromString(string, element2);
                        if (xPath == null || !IdentityConstraintInfo.checkXPath(xPath, false)) {
                            schemaErrors2.append(this, "c-fields-xpaths", "invalidXPath", string);
                        } else {
                            this.add(xPath);
                        }
                    }
                } else if (name == Info.XSD_SELECTOR && (string = element2.getAttribute(Info._XPATH)) != null) {
                    this.selector = XPath.fromString(string, element2);
                    if (this.selector == null || !IdentityConstraintInfo.checkXPath(this.selector, true)) {
                        schemaErrors2.append(this, "c-selector-xpath", "invalidXPath", string);
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    private static boolean checkXPath(XPath xPath, boolean bl) {
        Path[] pathArray = xPath.getPaths();
        int n = 0;
        while (n < pathArray.length) {
            Path path = pathArray[n];
            if (path.isAbsolute() || bl && path.isSelectingAttributes()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean sameXPaths(IdentityConstraintInfo identityConstraintInfo) {
        if (this.selector == null && identityConstraintInfo.selector != null || this.selector != null && !this.selector.equals(identityConstraintInfo.selector)) {
            return false;
        }
        if (this.fields == null || identityConstraintInfo.fields == null) {
            return this.fields == identityConstraintInfo.fields;
        }
        if (this.fields.length != identityConstraintInfo.fields.length) {
            return false;
        }
        int n = 0;
        while (n < this.fields.length) {
            XPath xPath = this.fields[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < identityConstraintInfo.fields.length) {
                if (xPath.equals(identityConstraintInfo.fields[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public abstract IdentityConstraint toIdentityConstraint(LoadState var1);
}

