/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import java.io.IOException;
import java.net.URL;

final class ImportInfo
extends Info {
    public Namespace namespace = Namespace.NONE;
    public URL schemaLocation = null;

    public ImportInfo(Info info) {
        super(info);
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        String string = Info.getNamespaceURIAttribute(element, Info._NAMESPACE, null);
        if (string != null) {
            this.namespace = Namespace.get(string);
        }
        this.schemaLocation = Info.getResolvedURLAttribute(element, Info._SCHEMA_LOCATION, this.getLocation(), null);
        if (this.namespace == schemaInfo.targetNamespace) {
            schemaErrors2.append(this, "src-import.1", "invalidImport", this.namespace, schemaInfo.targetNamespace);
        } else {
            schemaInfo.addImportedNamespace(this.namespace);
            SchemaInfo schemaInfo2 = null;
            boolean bl = false;
            LinearHashtable linearHashtable = loadContext.getImportedSchemas(this.namespace);
            if (linearHashtable != null) {
                if (this.schemaLocation == null) {
                    if (linearHashtable.size() == 1) {
                        schemaInfo2 = (SchemaInfo)linearHashtable.elements().nextElement();
                    }
                } else {
                    schemaInfo2 = (SchemaInfo)linearHashtable.get(this.schemaLocation);
                }
            }
            if (schemaInfo2 == null) {
                if (this.schemaLocation == null) {
                    schemaErrors.append(this, "x-src-import", "cannotImport");
                    return;
                }
                if (loadContext.isSchemaBeingLoaded(this.schemaLocation)) {
                    return;
                }
                try {
                    schemaInfo2 = Info.loadSchema(this.schemaLocation, null, loadContext, schemaErrors, schemaErrors2);
                }
                catch (IOException iOException) {
                    schemaErrors2.append(this, "x-src-import.1", "cannotLoadSchema", this.schemaLocation, iOException.getMessage());
                    return;
                }
                bl = true;
            }
            if (schemaInfo2 != null) {
                if (this.namespace != schemaInfo2.targetNamespace) {
                    schemaErrors2.append(this, "src-import.3", "unexpectedTargetNamespace", this.namespace, this.schemaLocation, schemaInfo2.targetNamespace);
                } else {
                    if (bl) {
                        loadContext.registerImportedSchema(this.namespace, this.schemaLocation, schemaInfo2);
                    }
                    Info.moveInfo(schemaInfo2, schemaInfo, schemaErrors2);
                }
            }
        }
    }
}

