/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.load.AttributeGroupInfo;
import com.xmlmind.xmledit.xsd.load.AttributeInfo;
import com.xmlmind.xmledit.xsd.load.ElementInfo;
import com.xmlmind.xmledit.xsd.load.GroupInfo;
import com.xmlmind.xmledit.xsd.load.InfoLoader;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.NotationInfo;
import com.xmlmind.xmledit.xsd.load.RedefineInfo;
import com.xmlmind.xmledit.xsd.load.SchemaError;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.SchemaUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class Info
implements NamespacePrefixMap {
    public static final int EXTENSION = 1;
    public static final int RESTRICTION = 2;
    public static final int SUBSTITUTION = 4;
    public static final int LIST = 8;
    public static final int UNION = 16;
    public static final int OPTIONAL = 0;
    public static final int REQUIRED = 1;
    public static final int PROHIBITED = 2;
    public Info parent;
    public Element peerElement;
    public Name name = null;
    public static final Name XSD_ALL = Name.get(Namespace.XSD, "all");
    public static final Name XSD_ANNOTATION = Name.get(Namespace.XSD, "annotation");
    public static final Name XSD_ANY_ATTRIBUTE = Name.get(Namespace.XSD, "anyAttribute");
    public static final Name XSD_ATTRIBUTE = Name.get(Namespace.XSD, "attribute");
    public static final Name XSD_ATTRIBUTE_GROUP = Name.get(Namespace.XSD, "attributeGroup");
    public static final Name XSD_CHOICE = Name.get(Namespace.XSD, "choice");
    public static final Name XSD_COMPLEX_TYPE = Name.get(Namespace.XSD, "complexType");
    public static final Name XSD_ELEMENT = Name.get(Namespace.XSD, "element");
    public static final Name XSD_GROUP = Name.get(Namespace.XSD, "group");
    public static final Name XSD_IMPORT = Name.get(Namespace.XSD, "import");
    public static final Name XSD_INCLUDE = Name.get(Namespace.XSD, "include");
    public static final Name XSD_NOTATION = Name.get(Namespace.XSD, "notation");
    public static final Name XSD_REDEFINE = Name.get(Namespace.XSD, "redefine");
    public static final Name XSD_SCHEMA = Name.get(Namespace.XSD, "schema");
    public static final Name XSD_SEQUENCE = Name.get(Namespace.XSD, "sequence");
    public static final Name XSD_SIMPLE_TYPE = Name.get(Namespace.XSD, "simpleType");
    public static final Name XSD_UNIQUE = Name.get(Namespace.XSD, "unique");
    public static final Name XSD_KEY = Name.get(Namespace.XSD, "key");
    public static final Name XSD_KEYREF = Name.get(Namespace.XSD, "keyref");
    public static final Name XSD_SELECTOR = Name.get(Namespace.XSD, "selector");
    public static final Name XSD_FIELD = Name.get(Namespace.XSD, "field");
    public static final Name XSD_COMPLEX_CONTENT = Name.get(Namespace.XSD, "complexContent");
    public static final Name XSD_SIMPLE_CONTENT = Name.get(Namespace.XSD, "simpleContent");
    public static final Name XSD_RESTRICTION = Name.get(Namespace.XSD, "restriction");
    public static final Name XSD_EXTENSION = Name.get(Namespace.XSD, "extension");
    public static final Name XSD_LIST = Name.get(Namespace.XSD, "list");
    public static final Name XSD_UNION = Name.get(Namespace.XSD, "union");
    public static final Name XSD_LENGTH = Name.get(Namespace.XSD, "length");
    public static final Name XSD_MIN_LENGTH = Name.get(Namespace.XSD, "minLength");
    public static final Name XSD_MAX_LENGTH = Name.get(Namespace.XSD, "maxLength");
    public static final Name XSD_PATTERN = Name.get(Namespace.XSD, "pattern");
    public static final Name XSD_ENUMERATION = Name.get(Namespace.XSD, "enumeration");
    public static final Name XSD_WHITE_SPACE = Name.get(Namespace.XSD, "whiteSpace");
    public static final Name XSD_MAX_INCLUSIVE = Name.get(Namespace.XSD, "maxInclusive");
    public static final Name XSD_MAX_EXCLUSIVE = Name.get(Namespace.XSD, "maxExclusive");
    public static final Name XSD_MIN_EXCLUSIVE = Name.get(Namespace.XSD, "minExclusive");
    public static final Name XSD_MIN_INCLUSIVE = Name.get(Namespace.XSD, "minInclusive");
    public static final Name XSD_TOTAL_DIGITS = Name.get(Namespace.XSD, "totalDigits");
    public static final Name XSD_FRACTION_DIGITS = Name.get(Namespace.XSD, "fractionDigits");
    public static final Name XSD_ANY = Name.get(Namespace.XSD, "any");
    public static final Name XSD_ANY_TYPE = Name.get(Namespace.XSD, "anyType");
    public static final Name _ATTRIBUTE_FORM_DEFAULT = Name.get(Namespace.NONE, "attributeFormDefault");
    public static final Name _BLOCK_DEFAULT = Name.get(Namespace.NONE, "blockDefault");
    public static final Name _DEFAULT = Name.get(Namespace.NONE, "default");
    public static final Name _ELEMENT_FORM_DEFAULT = Name.get(Namespace.NONE, "elementFormDefault");
    public static final Name _FINAL_DEFAULT = Name.get(Namespace.NONE, "finalDefault");
    public static final Name _FIXED = Name.get(Namespace.NONE, "fixed");
    public static final Name _FORM = Name.get(Namespace.NONE, "form");
    public static final Name _MAX_OCCURS = Name.get(Namespace.NONE, "maxOccurs");
    public static final Name _MIN_OCCURS = Name.get(Namespace.NONE, "minOccurs");
    public static final Name _NAME = Name.get(Namespace.NONE, "name");
    public static final Name _NAMESPACE = Name.get(Namespace.NONE, "namespace");
    public static final Name _PROCESS_CONTENTS = Name.get(Namespace.NONE, "processContents");
    public static final Name _PUBLIC = Name.get(Namespace.NONE, "public");
    public static final Name _REF = Name.get(Namespace.NONE, "ref");
    public static final Name _SCHEMA_LOCATION = Name.get(Namespace.NONE, "schemaLocation");
    public static final Name _SYSTEM = Name.get(Namespace.NONE, "system");
    public static final Name _TARGET_NAMESPACE = Name.get(Namespace.NONE, "targetNamespace");
    public static final Name _TYPE = Name.get(Namespace.NONE, "type");
    public static final Name _USE = Name.get(Namespace.NONE, "use");
    public static final Name _REFER = Name.get(Namespace.NONE, "refer");
    public static final Name _XPATH = Name.get(Namespace.NONE, "xpath");
    public static final Name _ABSTRACT = Name.get(Namespace.NONE, "abstract");
    public static final Name _BLOCK = Name.get(Namespace.NONE, "block");
    public static final Name _FINAL = Name.get(Namespace.NONE, "final");
    public static final Name _NILLABLE = Name.get(Namespace.NONE, "nillable");
    public static final Name _SUBSTITUTION_GROUP = Name.get(Namespace.NONE, "substitutionGroup");
    public static final Name _BASE = Name.get(Namespace.NONE, "base");
    public static final Name _ITEM_TYPE = Name.get(Namespace.NONE, "itemType");
    public static final Name _MEMBER_TYPES = Name.get(Namespace.NONE, "memberTypes");
    public static final Name _VALUE = Name.get(Namespace.NONE, "value");
    public static final Name _MIXED = Name.get(Namespace.NONE, "mixed");
    protected static LinearHashtable nameToFacet = new LinearHashtable();

    protected Info(Info info) {
        this.parent = info;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        this.peerElement = element;
    }

    public final String getType() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46) + 1;
        return Character.toLowerCase(string.charAt(n)) + string.substring(n + 1, string.length() - 4);
    }

    public final URL getLocation() {
        return this.peerElement.getLocation();
    }

    public Namespace prefixToNamespace(String string) {
        return this.peerElement.prefixToNamespace(string);
    }

    public String[] namespaceToPrefixes(Namespace namespace) {
        return this.peerElement.namespaceToPrefixes(namespace);
    }

    public final SchemaInfo getSchema() {
        Info info = this;
        while (info.parent != null) {
            info = info.parent;
        }
        return (SchemaInfo)info;
    }

    public final URL getSchemaURL() {
        return this.getSchema().getLocation();
    }

    protected static SchemaInfo loadSchema(URL uRL, Namespace namespace, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) throws IOException {
        InfoLoader infoLoader = new InfoLoader();
        SchemaInfo schemaInfo = null;
        schemaInfo = infoLoader.load(uRL, namespace, loadContext);
        SchemaError[] schemaErrorArray = infoLoader.getWarnings();
        int n = 0;
        while (n < schemaErrorArray.length) {
            schemaErrors.append(schemaErrorArray[n]);
            ++n;
        }
        if (schemaInfo == null) {
            SchemaError[] schemaErrorArray2 = infoLoader.getErrors();
            int n2 = 0;
            while (n2 < schemaErrorArray2.length) {
                schemaErrors2.append(schemaErrorArray2[n2]);
                ++n2;
            }
        }
        return schemaInfo;
    }

    protected static void moveInfo(SchemaInfo schemaInfo, SchemaInfo schemaInfo2, SchemaErrors schemaErrors) {
        Info info;
        Info info2;
        schemaInfo2.preferredPrefixes = PreferredPrefix.merge(schemaInfo2.preferredPrefixes, schemaInfo.preferredPrefixes);
        schemaInfo2.sourceURLs = SchemaUtil.mergeURLs(schemaInfo2.sourceURLs, schemaInfo.sourceURLs);
        Enumeration enumeration = schemaInfo.elementInfo.elements();
        while (enumeration.hasMoreElements()) {
            info2 = (ElementInfo)enumeration.nextElement();
            info = schemaInfo2.elementInfo.put(((ElementInfo)info2).name, info2);
            if (info == null || info.getSchemaURL().equals(info2.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateElement", ((ElementInfo)info2).name.format(false, info2));
        }
        schemaInfo.elementInfo.clear();
        enumeration = schemaInfo.attributeInfo.elements();
        while (enumeration.hasMoreElements()) {
            info2 = (AttributeInfo)enumeration.nextElement();
            info = (AttributeInfo)schemaInfo2.attributeInfo.put(((AttributeInfo)info2).name, info2);
            if (info == null || info.getSchemaURL().equals(info2.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateAttribute", ((AttributeInfo)info2).name.format(false, info2));
        }
        schemaInfo.attributeInfo.clear();
        enumeration = schemaInfo.typeInfo.elements();
        while (enumeration.hasMoreElements()) {
            info2 = (TypeInfo)enumeration.nextElement();
            info = (TypeInfo)schemaInfo2.typeInfo.put(((TypeInfo)info2).name, info2);
            if (info == null || info.getSchemaURL().equals(info2.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateType", ((TypeInfo)info2).name.format(false, info2));
        }
        schemaInfo.typeInfo.clear();
        enumeration = schemaInfo.groupInfo.elements();
        while (enumeration.hasMoreElements()) {
            info2 = (GroupInfo)enumeration.nextElement();
            info = (GroupInfo)schemaInfo2.groupInfo.put(((GroupInfo)info2).name, info2);
            if (info == null || info.getSchemaURL().equals(info2.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateGroup", ((GroupInfo)info2).name.format(false, info2));
        }
        schemaInfo.groupInfo.clear();
        enumeration = schemaInfo.attributeGroupInfo.elements();
        while (enumeration.hasMoreElements()) {
            info2 = (AttributeGroupInfo)enumeration.nextElement();
            info = (AttributeGroupInfo)schemaInfo2.attributeGroupInfo.put(((AttributeGroupInfo)info2).name, info2);
            if (info == null || info.getSchemaURL().equals(info2.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateAttributeGroup", ((AttributeGroupInfo)info2).name.format(false, info2));
        }
        schemaInfo.attributeGroupInfo.clear();
        enumeration = schemaInfo.notationInfo.elements();
        while (enumeration.hasMoreElements()) {
            info2 = (NotationInfo)enumeration.nextElement();
            info = (NotationInfo)schemaInfo2.notationInfo.put(((NotationInfo)info2).name, info2);
            if (info == null || info.getSchemaURL().equals(info2.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateNotation", ((NotationInfo)info2).name.format(false, info2));
        }
        schemaInfo.notationInfo.clear();
    }

    protected static Element getChild(Element element, Name name) {
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 4 && (element2 = (Element)node).getName() == name) {
                return element2;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected Namespace getTargetNamespace(Element element, boolean bl, SchemaInfo schemaInfo) {
        String string = element.getAttribute(_FORM);
        boolean bl2 = false;
        if (string != null) {
            bl2 = Info.getFormAttribute(element, _FORM, false);
        }
        Namespace namespace = this.parent instanceof SchemaInfo || this.parent instanceof RedefineInfo || element.hasAttribute(_REF) ? schemaInfo.targetNamespace : (string != null && bl2 || string == null && (!bl && schemaInfo.elementFormQualified || bl && schemaInfo.attributeFormQualified) ? schemaInfo.targetNamespace : Namespace.NONE);
        return namespace;
    }

    protected static Name getNCNameAttribute(Element element, Name name, Namespace namespace, Name name2) {
        String string = element.getAttribute(name);
        if (string == null) {
            return name2;
        }
        if (!XMLUtil.isNCName(string = string.trim())) {
            return name2;
        }
        return Name.get(namespace, string);
    }

    protected static String getNamespaceURIAttribute(Element element, Name name, String string) {
        String string2 = element.getAnyURIAttribute(name, null);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string2;
    }

    protected static URL getResolvedURLAttribute(Element element, Name name, URL uRL, URL uRL2) {
        String string = element.getAnyURIAttribute(name, null);
        if (string == null) {
            return uRL2;
        }
        URL uRL3 = null;
        try {
            uRL3 = XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL3 == null ? uRL2 : uRL3;
    }

    protected static NameWildcard getNameWildcardAttribute(Element element, Name name, Namespace namespace, NameWildcard nameWildcard) {
        Object object;
        String string = element.getAttribute(name);
        if (string == null) {
            return nameWildcard;
        }
        String[] stringArray = XMLUtil.splitList(string);
        if (stringArray.length == 0) {
            return nameWildcard;
        }
        if (stringArray.length == 1 && "##any".equals(stringArray[0])) {
            return NameWildcard.ANY;
        }
        if (stringArray.length == 1 && "##other".equals(stringArray[0])) {
            return new NameWildcard(namespace);
        }
        LinearHashtable linearHashtable = new LinearHashtable();
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if ("##targetNamespace".equals(object)) {
                linearHashtable.put(namespace, namespace);
            } else if ("##local".equals(object)) {
                linearHashtable.put(Namespace.NONE, Namespace.NONE);
            } else {
                Namespace namespace2 = Namespace.get((String)object);
                linearHashtable.put(namespace2, namespace2);
            }
            ++n;
        }
        object = new Namespace[linearHashtable.size()];
        linearHashtable.copyElementsInto((Object[])object);
        return new NameWildcard((Namespace[])object);
    }

    protected static int getProcessContentsAttribute(Element element, Name name, int n) {
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        if ("skip".equals(string = string.trim())) {
            return 2;
        }
        if ("lax".equals(string)) {
            return 1;
        }
        if ("strict".equals(string)) {
            return 0;
        }
        return n;
    }

    protected static int getNonNegativeIntAttribute(Element element, Name name, int n) {
        int n2;
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        string = string.trim();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        return n2 < 0 ? n : n2;
    }

    protected static int getMaxOccursAttribute(Element element, Name name, int n) {
        int n2;
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        if ("unbounded".equals(string = string.trim())) {
            return -1;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        return n2 < 0 ? n : n2;
    }

    protected Name getQNameAttribute(Element element, Name name, Name name2) {
        String string = element.getAttribute(name);
        if (string == null) {
            return name2;
        }
        Name name3 = Name.parse(string = string.trim(), false, element);
        if (name3 == null) {
            return name2;
        }
        if (name3.getNamespace() == Namespace.NONE) {
            SchemaInfo schemaInfo = this.getSchema();
            if (schemaInfo.inheritsTargetNamespace) {
                name3 = Name.get(schemaInfo.targetNamespace, name3.getLocalPart());
            }
        }
        return name3;
    }

    protected Name[] getQNamesAttribute(Element element, Name name, Name[] nameArray) {
        String string = element.getAttribute(name);
        if (string == null) {
            return nameArray;
        }
        String[] stringArray = XMLUtil.splitList(string);
        if (stringArray.length == 0) {
            return nameArray;
        }
        Name[] nameArray2 = new Name[stringArray.length];
        SchemaInfo schemaInfo = null;
        int n = 0;
        while (n < stringArray.length) {
            Name name2 = Name.parse(stringArray[n], false, element);
            if (name2 == null) {
                return nameArray;
            }
            if (name2.getNamespace() == Namespace.NONE) {
                if (schemaInfo == null) {
                    schemaInfo = this.getSchema();
                }
                if (schemaInfo.inheritsTargetNamespace) {
                    name2 = Name.get(schemaInfo.targetNamespace, name2.getLocalPart());
                }
            }
            nameArray2[n] = name2;
            ++n;
        }
        return nameArray2;
    }

    protected boolean checkImportedNamespaces(Name[] nameArray, SchemaInfo schemaInfo, SchemaErrors schemaErrors) {
        boolean bl = true;
        int n = 0;
        while (n < nameArray.length) {
            if (!this.checkImportedNamespaces(nameArray[n], schemaInfo, schemaErrors)) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    protected boolean checkImportedNamespaces(Name name, SchemaInfo schemaInfo, SchemaErrors schemaErrors) {
        Namespace namespace = name.getNamespace();
        if (namespace != Namespace.XSD && namespace != schemaInfo.targetNamespace && !schemaInfo.isImportedNamespace(namespace)) {
            schemaErrors.append(this, "src-resolve.4", "cannotResolveQNameToComponent", name.format(false, this), namespace, name.getLocalPart());
            return false;
        }
        return true;
    }

    protected static int getUseAttribute(Element element, Name name, int n) {
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        if ("optional".equals(string = string.trim())) {
            return 0;
        }
        if ("required".equals(string)) {
            return 1;
        }
        if ("prohibited".equals(string)) {
            return 2;
        }
        return n;
    }

    protected static boolean getFormAttribute(Element element, Name name, boolean bl) {
        String string = element.getAttribute(name);
        if (string == null) {
            return bl;
        }
        if ("qualified".equals(string = string.trim())) {
            return true;
        }
        if ("unqualified".equals(string)) {
            return false;
        }
        return bl;
    }

    protected static int getBlockAttribute(Element element, Name name, int n) {
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        String[] stringArray = XMLUtil.splitList(string);
        if (stringArray.length == 0) {
            return n;
        }
        if (stringArray.length == 1 && "#all".equals(stringArray[0])) {
            return 7;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string2 = stringArray[n3];
            if ("extension".equals(string2)) {
                n2 |= 1;
            } else if ("restriction".equals(string2)) {
                n2 |= 2;
            } else if ("substitution".equals(string2)) {
                n2 |= 4;
            } else {
                return n;
            }
            ++n3;
        }
        return n2;
    }

    protected static int getFinalAttribute(Element element, Name name, int n) {
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        String[] stringArray = XMLUtil.splitList(string);
        if (stringArray.length == 0) {
            return n;
        }
        if (stringArray.length == 1 && "#all".equals(stringArray[0])) {
            return 27;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string2 = stringArray[n3];
            if ("extension".equals(string2)) {
                n2 |= 1;
            } else if ("restriction".equals(string2)) {
                n2 |= 2;
            } else if ("list".equals(string2)) {
                n2 |= 8;
            } else if ("union".equals(string2)) {
                n2 |= 0x10;
            } else {
                return n;
            }
            ++n3;
        }
        return n2;
    }

    protected static boolean getBooleanAttribute(Element element, Name name, boolean bl) {
        String string = element.getAttribute(name);
        if (string == null) {
            return bl;
        }
        if ("true".equals(string = string.trim())) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        if ("1".equals(string)) {
            return true;
        }
        if ("0".equals(string)) {
            return false;
        }
        return bl;
    }

    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        loadState.errors.append(this, null, "notAParticleInfo", this.getType());
        return false;
    }

    protected boolean checkOccurs(int n, int n2, LoadState loadState) {
        if (n2 == -1) {
            return true;
        }
        if (n > n2) {
            loadState.errors.append(this, "p-props-correct.2.1", "minOccursGTMaxOccurs", new Integer(n), new Integer(n2));
            return false;
        }
        return true;
    }

    public boolean toParticle2(Hashtable hashtable, LoadState loadState) {
        loadState.errors.append(this, null, "notAParticleInfo", this.getType());
        return false;
    }

    static {
        String[] stringArray = DataType.facetNames;
        int[] nArray = DataType.facetMasks;
        int n = 0;
        while (n < stringArray.length) {
            NameToFacetEntry nameToFacetEntry = new NameToFacetEntry(stringArray[n], nArray[n]);
            nameToFacet.put(nameToFacetEntry.name, nameToFacetEntry);
            ++n;
        }
    }

    protected static class NameToFacetEntry {
        public Name name;
        public int facet;

        public NameToFacetEntry(String string, int n) {
            this.name = Name.get(Namespace.XSD, string);
            this.facet = n;
        }
    }
}

