/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xsd.load.AttributeGroupInfo;
import com.xmlmind.xmledit.xsd.load.AttributeInfo;
import com.xmlmind.xmledit.xsd.load.ComplexTypeInfo;
import com.xmlmind.xmledit.xsd.load.ElementInfo;
import com.xmlmind.xmledit.xsd.load.GroupInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.NamedComponent;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SubstitutionGroup;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.XMLSchema;
import com.xmlmind.xmledit.xsd.validate.XMLSchemaForSchemas;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class LoadState {
    public static final String MISSING_COMPONENT = "missingComponent";
    public static final String CIRCULAR_COMPONENT = "circularComponent";
    public static final String INVALID_COMPONENT = "invalidComponent";
    public SchemaInfo schemaInfo;
    public XMLSchema schema;
    public SchemaErrors errors;
    public SchemaErrors warnings;
    public Vector localComplexTypes;
    public Hashtable identityConstraints;
    private Hashtable circularComponents;
    private Hashtable badComponents;
    private NamedComponent namedComponentProbe;
    private Hashtable substitutionGroups;
    private SubstitutionGroup subGroupProbe;

    public LoadState(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        this.schema = schemaInfo.targetNamespace == Namespace.XSD ? new XMLSchemaForSchemas() : new XMLSchema(schemaInfo.targetNamespace);
        this.errors = new SchemaErrors();
        this.warnings = new SchemaErrors();
        this.localComplexTypes = new Vector();
        this.identityConstraints = new Hashtable();
        this.circularComponents = new Hashtable();
        this.badComponents = new Hashtable();
        this.namedComponentProbe = new NamedComponent();
        this.initSubstitutionGroups();
    }

    private void initSubstitutionGroups() {
        Object object;
        Object object2;
        SubstitutionGroup substitutionGroup;
        SubstitutionGroup substitutionGroup2;
        SubstitutionGroup[] substitutionGroupArray;
        this.substitutionGroups = new Hashtable();
        this.subGroupProbe = new SubstitutionGroup();
        Enumeration enumeration = this.schemaInfo.elementInfo.elements();
        while (enumeration.hasMoreElements()) {
            ElementInfo elementInfo;
            substitutionGroupArray = (SubstitutionGroup[])enumeration.nextElement();
            if (substitutionGroupArray.substitutionGroup == null || (elementInfo = this.getElementInfo(substitutionGroupArray.substitutionGroup, (Info)substitutionGroupArray, "e-props-correct.1")) == null) continue;
            if ((elementInfo.block & 4) != 0) {
                this.errors.append((Info)substitutionGroupArray, "cos-equiv-derived-ok-rec.1", "disallowedSubstitution", substitutionGroupArray.substitutionGroup.format(false, (NamespaceToPrefixes)substitutionGroupArray));
                continue;
            }
            substitutionGroup2 = this.getSubstitutionGroup(elementInfo);
            if (substitutionGroup2 == null) {
                substitutionGroup2 = new SubstitutionGroup(elementInfo);
                this.substitutionGroups.put(substitutionGroup2, substitutionGroup2);
            }
            substitutionGroup2.addMember((ElementInfo)substitutionGroupArray);
        }
        substitutionGroupArray = new SubstitutionGroup[this.substitutionGroups.size()];
        int n = 0;
        enumeration = this.substitutionGroups.elements();
        while (enumeration.hasMoreElements()) {
            substitutionGroup2 = (SubstitutionGroup)enumeration.nextElement();
            substitutionGroupArray[n++] = new SubstitutionGroup(substitutionGroup2);
        }
        int n2 = 0;
        while (n2 < substitutionGroupArray.length) {
            substitutionGroup = substitutionGroupArray[n2];
            object2 = substitutionGroup.head;
            object = substitutionGroup.members;
            int n3 = 0;
            while (n3 < ((ElementInfo[])object).length) {
                this.addToSubstitutionGroups(object[n3], (ElementInfo)object2);
                ++n3;
            }
            ++n2;
        }
        n = 0;
        enumeration = this.substitutionGroups.elements();
        while (enumeration.hasMoreElements()) {
            substitutionGroup = (SubstitutionGroup)enumeration.nextElement();
            substitutionGroupArray[n++] = substitutionGroup;
        }
        int n4 = 0;
        while (n4 < substitutionGroupArray.length) {
            object2 = substitutionGroupArray[n4];
            object = ((SubstitutionGroup)object2).head;
            ElementInfo[] elementInfoArray = ((SubstitutionGroup)object2).members;
            int n5 = 0;
            if (!object.abstract_) {
                ++n5;
            }
            int n6 = 0;
            while (n6 < elementInfoArray.length) {
                if (!elementInfoArray[n6].abstract_) {
                    ++n5;
                }
                ++n6;
            }
            if (n5 == 0) {
                this.subGroupProbe.head = object;
                this.substitutionGroups.remove(this.subGroupProbe);
            }
            ++n4;
        }
    }

    public SubstitutionGroup getSubstitutionGroup(ElementInfo elementInfo) {
        this.subGroupProbe.head = elementInfo;
        return (SubstitutionGroup)this.substitutionGroups.get(this.subGroupProbe);
    }

    private void addToSubstitutionGroups(ElementInfo elementInfo, ElementInfo elementInfo2) {
        while (elementInfo2.substitutionGroup != null) {
            ElementInfo elementInfo3 = (ElementInfo)this.schemaInfo.elementInfo.get(elementInfo2.substitutionGroup);
            if (elementInfo3 == null) {
                return;
            }
            if (elementInfo == elementInfo3) {
                return;
            }
            SubstitutionGroup substitutionGroup = this.getSubstitutionGroup(elementInfo3);
            if (substitutionGroup == null) {
                return;
            }
            substitutionGroup.addMember(elementInfo);
            elementInfo2 = elementInfo3;
        }
        return;
    }

    public boolean isBadComponent(int n, Name name) {
        this.namedComponentProbe.type = n;
        this.namedComponentProbe.name = name;
        return this.badComponents.containsKey(this.namedComponentProbe);
    }

    public void addBadComponent(int n, Name name, String string, Info info, String string2) {
        if (this.isBadComponent(n, name)) {
            return;
        }
        NamedComponent namedComponent = new NamedComponent(n, name);
        this.badComponents.put(namedComponent, namedComponent);
        if (string == MISSING_COMPONENT) {
            this.warnings.append(info, string2, MISSING_COMPONENT, NamedComponent.TYPE_NAMES[n], name.format(false, info));
        } else if (string != INVALID_COMPONENT) {
            this.errors.append(info, string2, string, NamedComponent.TYPE_NAMES[n], name.format(false, info));
        }
    }

    public boolean isCircularComponent(int n, Name name) {
        this.namedComponentProbe.type = n;
        this.namedComponentProbe.name = name;
        return this.circularComponents.containsKey(this.namedComponentProbe);
    }

    public boolean detectCircularComponent(int n, Name name, Info info, String string) {
        if (this.isCircularComponent(n, name)) {
            this.addBadComponent(n, name, CIRCULAR_COMPONENT, info, string);
            return true;
        }
        NamedComponent namedComponent = new NamedComponent(n, name);
        this.circularComponents.put(namedComponent, namedComponent);
        return false;
    }

    public void undetectCircularComponent(int n, Name name) {
        this.namedComponentProbe.type = n;
        this.namedComponentProbe.name = name;
        this.circularComponents.remove(this.namedComponentProbe);
    }

    public SimpleType getSimpleType(Name name, Info info, String string) {
        Type type = this.getType(name, info, string);
        if (type != null && !(type instanceof SimpleType)) {
            this.errors.append(info, string, "unexpectedComplexType", name.format(false, info));
            return null;
        }
        return (SimpleType)type;
    }

    public Type getType(Name name, Info info, String string) {
        if (this.isBadComponent(0, name)) {
            return null;
        }
        Type type = this.schema.findType(name);
        if (type != null) {
            return type;
        }
        TypeInfo typeInfo = (TypeInfo)this.schemaInfo.typeInfo.get(name);
        if (typeInfo == null) {
            this.addBadComponent(0, name, MISSING_COMPONENT, info, string);
            return null;
        }
        if (this.detectCircularComponent(0, name, info, string)) {
            return null;
        }
        Type type2 = typeInfo instanceof ComplexTypeInfo ? ((ComplexTypeInfo)typeInfo).toComplexType(this) : typeInfo.toType(this);
        this.undetectCircularComponent(0, name);
        if (type2 == null) {
            this.addBadComponent(0, name, INVALID_COMPONENT, info, string);
            return null;
        }
        this.schema.addType(type2);
        return type2;
    }

    public AttributeDeclaration getAttributeDeclaration(Name name, Info info, String string) {
        if (this.isBadComponent(2, name)) {
            return null;
        }
        AttributeDeclaration attributeDeclaration = this.schema.getAttributeDeclaration(name);
        if (attributeDeclaration != null) {
            return attributeDeclaration;
        }
        AttributeInfo attributeInfo = (AttributeInfo)this.schemaInfo.attributeInfo.get(name);
        if (attributeInfo == null) {
            this.addBadComponent(2, name, MISSING_COMPONENT, info, string);
            return null;
        }
        AttributeDeclaration attributeDeclaration2 = attributeInfo.toAttributeDeclaration(this);
        if (attributeDeclaration2 == null) {
            this.addBadComponent(2, name, INVALID_COMPONENT, info, string);
            return null;
        }
        this.schema.addAttributeDeclaration(attributeDeclaration2);
        return attributeDeclaration2;
    }

    public ElementDeclaration getElementDeclaration(Name name, Info info, String string) {
        if (this.isBadComponent(1, name)) {
            return null;
        }
        ElementDeclaration elementDeclaration = this.schema.getElementDeclaration(name);
        if (elementDeclaration != null) {
            return elementDeclaration;
        }
        ElementInfo elementInfo = (ElementInfo)this.schemaInfo.elementInfo.get(name);
        if (elementInfo == null) {
            this.addBadComponent(1, name, MISSING_COMPONENT, info, string);
            return null;
        }
        ElementDeclaration elementDeclaration2 = elementInfo.toElementDeclaration(this);
        if (elementDeclaration2 == null) {
            this.addBadComponent(1, name, INVALID_COMPONENT, info, string);
            return null;
        }
        this.schema.addElementDeclaration(elementDeclaration2);
        return elementDeclaration2;
    }

    public ElementInfo getElementInfo(Name name, Info info, String string) {
        if (this.isBadComponent(1, name)) {
            return null;
        }
        ElementInfo elementInfo = (ElementInfo)this.schemaInfo.elementInfo.get(name);
        if (elementInfo == null) {
            this.addBadComponent(1, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return elementInfo;
    }

    public GroupInfo getGroupInfo(Name name, Info info, String string) {
        if (this.isBadComponent(3, name)) {
            return null;
        }
        GroupInfo groupInfo = (GroupInfo)this.schemaInfo.groupInfo.get(name);
        if (groupInfo == null) {
            this.addBadComponent(3, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return groupInfo;
    }

    public AttributeGroupInfo getAttributeGroupInfo(Name name, Info info, String string) {
        if (this.isBadComponent(4, name)) {
            return null;
        }
        AttributeGroupInfo attributeGroupInfo = (AttributeGroupInfo)this.schemaInfo.attributeGroupInfo.get(name);
        if (attributeGroupInfo == null) {
            this.addBadComponent(4, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return attributeGroupInfo;
    }

    public TypeInfo getTypeInfo(Name name, Info info, String string) {
        if (this.isBadComponent(0, name)) {
            return null;
        }
        TypeInfo typeInfo = (TypeInfo)this.schemaInfo.typeInfo.get(name);
        if (typeInfo == null) {
            this.addBadComponent(0, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return typeInfo;
    }
}

