/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.load.AllInfo;
import com.xmlmind.xmledit.xsd.load.AnyInfo;
import com.xmlmind.xmledit.xsd.load.ChoiceInfo;
import com.xmlmind.xmledit.xsd.load.ElementInfo;
import com.xmlmind.xmledit.xsd.load.GroupInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SequenceInfo;
import com.xmlmind.xmledit.xsd.validate.Particle;
import java.util.Hashtable;

abstract class ModelGroupInfo
extends Info {
    public Info[] particleInfo = null;
    public int minOccurs = 1;
    public int maxOccurs = 1;
    private static final Info[] NO_PARTICLE_INFO = new Info[0];

    protected ModelGroupInfo(Info info) {
        super(info);
    }

    public void add(Info info) {
        if (this.particleInfo == null) {
            this.particleInfo = new Info[]{info};
            return;
        }
        Info[] infoArray = new Info[this.particleInfo.length + 1];
        System.arraycopy(this.particleInfo, 0, infoArray, 0, this.particleInfo.length);
        infoArray[this.particleInfo.length] = info;
        this.particleInfo = infoArray;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.minOccurs = Info.getNonNegativeIntAttribute(element, Info._MIN_OCCURS, 1);
        this.maxOccurs = Info.getMaxOccursAttribute(element, Info._MAX_OCCURS, 1);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Info info;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_ELEMENT) {
                    info = new ElementInfo(this);
                    ((ElementInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(info);
                } else if (name == Info.XSD_SEQUENCE) {
                    info = new SequenceInfo(this);
                    ((ModelGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(info);
                } else if (name == Info.XSD_CHOICE) {
                    info = new ChoiceInfo(this);
                    ((ModelGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(info);
                } else if (name == Info.XSD_ALL) {
                    info = new AllInfo(this);
                    ((ModelGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(info);
                } else if (name == Info.XSD_GROUP) {
                    info = new GroupInfo(this);
                    ((GroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(info);
                } else if (name == Info.XSD_ANY) {
                    info = new AnyInfo(this);
                    ((AnyInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(info);
                }
            }
            node = node.getNextSibling();
        }
    }

    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            particleArray[n] = null;
            return true;
        }
        Info[] infoArray = this.particleInfo;
        if (infoArray == null) {
            infoArray = NO_PARTICLE_INFO;
        }
        Particle[] particleArray2 = new Particle[infoArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < infoArray.length) {
            if (!infoArray[n3].toParticle(particleArray2, n2, loadState)) {
                return false;
            }
            if (particleArray2[n2] != null) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            particleArray[n] = null;
        } else {
            if (n2 != particleArray2.length) {
                Particle[] particleArray3 = new Particle[n2];
                System.arraycopy(particleArray2, 0, particleArray3, 0, n2);
                particleArray2 = particleArray3;
            }
            particleArray[n] = this.createParticle(particleArray2, this.minOccurs, this.maxOccurs, loadState);
            if (particleArray[n] == null) {
                return false;
            }
        }
        return true;
    }

    protected abstract Particle createParticle(Particle[] var1, int var2, int var3, LoadState var4);

    public boolean toParticle2(Hashtable hashtable, LoadState loadState) {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return true;
        }
        if (this.particleInfo != null) {
            int n = 0;
            while (n < this.particleInfo.length) {
                if (!this.particleInfo[n].toParticle2(hashtable, loadState)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }
}

