/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.load.AttributeGroupInfo;
import com.xmlmind.xmledit.xsd.load.ComplexTypeInfo;
import com.xmlmind.xmledit.xsd.load.GroupInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.ModelGroupInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SimpleTypeInfo;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import java.io.IOException;
import java.net.URL;

final class RedefineInfo
extends Info {
    public URL schemaLocation = null;
    private static int redefineCounter = 0;

    public RedefineInfo(Info info) {
        super(info);
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.schemaLocation = Info.getResolvedURLAttribute(element, Info._SCHEMA_LOCATION, this.getLocation(), null);
        if (this.schemaLocation == null) {
            schemaErrors2.append(this, "x-src-redefine.1", "invalidSchemaLocation");
            return;
        }
        if (loadContext.isSchemaBeingLoaded(this.schemaLocation)) {
            return;
        }
        SchemaInfo schemaInfo2 = null;
        try {
            schemaInfo2 = Info.loadSchema(this.schemaLocation, schemaInfo.targetNamespace, loadContext, schemaErrors, schemaErrors2);
        }
        catch (IOException iOException) {
            schemaErrors2.append(this, "x-src-redefine.1", "cannotLoadSchema", this.schemaLocation, iOException.getMessage());
            return;
        }
        if (schemaInfo2 != null && schemaInfo2.targetNamespace != schemaInfo.targetNamespace) {
            schemaErrors2.append(this, "src-redefine.2", "unexpectedTargetNamespace", schemaInfo.targetNamespace, this.schemaLocation, schemaInfo2.targetNamespace);
            schemaInfo2 = null;
        }
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Info info;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_SIMPLE_TYPE) {
                    info = new SimpleTypeInfo(this);
                    ((SimpleTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (schemaInfo2 != null && !RedefineInfo.redefineSimpleType(schemaInfo2, (SimpleTypeInfo)info, schemaErrors2)) {
                        bl = true;
                    }
                } else if (name == Info.XSD_COMPLEX_TYPE) {
                    info = new ComplexTypeInfo(this);
                    ((ComplexTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (schemaInfo2 != null && !RedefineInfo.redefineComplexType(schemaInfo2, (ComplexTypeInfo)info, schemaErrors2)) {
                        bl = true;
                    }
                } else if (name == Info.XSD_GROUP) {
                    info = new GroupInfo(this);
                    ((GroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (schemaInfo2 != null && !RedefineInfo.redefineGroup(schemaInfo2, (GroupInfo)info, schemaErrors2)) {
                        bl = true;
                    }
                } else if (name == Info.XSD_ATTRIBUTE_GROUP) {
                    info = new AttributeGroupInfo(this);
                    ((AttributeGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (schemaInfo2 != null && !RedefineInfo.redefineAttributeGroup(schemaInfo2, (AttributeGroupInfo)info, schemaErrors2)) {
                        bl = true;
                    }
                }
            }
            node = node.getNextSibling();
        }
        if (schemaInfo2 != null && !bl) {
            Info.moveInfo(schemaInfo2, schemaInfo, schemaErrors2);
        }
    }

    private static boolean redefineSimpleType(SchemaInfo schemaInfo, SimpleTypeInfo simpleTypeInfo, SchemaErrors schemaErrors) {
        Name name;
        Name name2 = simpleTypeInfo.name;
        if (name2 == null) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)schemaInfo.typeInfo.get(name2);
        if (typeInfo == null) {
            schemaErrors.append(simpleTypeInfo, "src-expredef.1", "missingRedefinedComponent", "simpleType", name2.format(false, simpleTypeInfo), schemaInfo.getLocation());
            return false;
        }
        if (simpleTypeInfo.derivation != 2 || simpleTypeInfo.base != name2) {
            schemaErrors.append(simpleTypeInfo, "src-redefine.5", "invalidSimpleTypeRedefinition", name2.format(false, simpleTypeInfo));
            return false;
        }
        schemaInfo.typeInfo.remove(name2);
        typeInfo.name = name = RedefineInfo.redefinedName(name2);
        schemaInfo.typeInfo.put(name, typeInfo);
        simpleTypeInfo.base = name;
        schemaInfo.typeInfo.put(name2, simpleTypeInfo);
        return true;
    }

    private static boolean redefineComplexType(SchemaInfo schemaInfo, ComplexTypeInfo complexTypeInfo, SchemaErrors schemaErrors) {
        Name name;
        Name name2 = complexTypeInfo.name;
        if (name2 == null) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)schemaInfo.typeInfo.get(name2);
        if (typeInfo == null) {
            schemaErrors.append(complexTypeInfo, "src-expredef.1", "missingRedefinedComponent", "simpleType|complexType", name2.format(false, complexTypeInfo), schemaInfo.getLocation());
            return false;
        }
        if (complexTypeInfo.base != name2) {
            schemaErrors.append(complexTypeInfo, "src-redefine.5", "invalidComplexTypeRedefinition", name2.format(false, complexTypeInfo));
            return false;
        }
        schemaInfo.typeInfo.remove(name2);
        typeInfo.name = name = RedefineInfo.redefinedName(name2);
        schemaInfo.typeInfo.put(name, typeInfo);
        complexTypeInfo.base = name;
        schemaInfo.typeInfo.put(name2, complexTypeInfo);
        return true;
    }

    private static boolean redefineGroup(SchemaInfo schemaInfo, GroupInfo groupInfo, SchemaErrors schemaErrors) {
        Name name = groupInfo.name;
        if (name == null) {
            return false;
        }
        GroupInfo groupInfo2 = (GroupInfo)schemaInfo.groupInfo.get(name);
        GroupSelfReference groupSelfReference = new GroupSelfReference();
        if (groupInfo.modelGroupInfo != null) {
            RedefineInfo.findGroupSelfReference(name, groupInfo.modelGroupInfo, groupSelfReference);
            if (groupSelfReference.count > 0) {
                Name name2;
                if (groupSelfReference.count > 1) {
                    schemaErrors.append(groupInfo, "src-redefine.6.1.1", "severalSelfReferences", "group", name.format(false, groupInfo));
                    return false;
                }
                if (groupSelfReference.groupInfo.minOccurs != 1 || groupSelfReference.groupInfo.maxOccurs != 1) {
                    schemaErrors.append(groupInfo, "src-redefine.6.1.2", "invalidGroupSelfReference", name.format(false, groupInfo));
                    return false;
                }
                if (groupInfo2 == null) {
                    schemaErrors.append(groupInfo, "src-expredef.2", "missingRedefinedComponent", "group", name.format(false, groupInfo), schemaInfo.getLocation());
                    return false;
                }
                schemaInfo.groupInfo.remove(name);
                groupInfo2.name = name2 = RedefineInfo.redefinedName(name);
                schemaInfo.groupInfo.put(name2, groupInfo2);
                groupSelfReference.groupInfo.ref = name2;
            }
        }
        if (groupSelfReference.count == 0 && groupInfo2 == null) {
            schemaErrors.append(groupInfo, "src-redefine.6.2.1", "missingRedefinedComponent", "group", name.format(false, groupInfo), schemaInfo.getLocation());
            return false;
        }
        schemaInfo.groupInfo.put(name, groupInfo);
        return true;
    }

    private static void findGroupSelfReference(Name name, ModelGroupInfo modelGroupInfo, GroupSelfReference groupSelfReference) {
        Info[] infoArray = modelGroupInfo.particleInfo;
        if (infoArray == null) {
            return;
        }
        int n = 0;
        while (n < infoArray.length) {
            Info info = infoArray[n];
            if (info instanceof GroupInfo) {
                GroupInfo groupInfo = (GroupInfo)info;
                if (groupInfo.ref == name) {
                    groupSelfReference.groupInfo = groupInfo;
                    ++groupSelfReference.count;
                }
            } else if (info instanceof ModelGroupInfo) {
                RedefineInfo.findGroupSelfReference(name, (ModelGroupInfo)info, groupSelfReference);
            }
            ++n;
        }
    }

    private static boolean redefineAttributeGroup(SchemaInfo schemaInfo, AttributeGroupInfo attributeGroupInfo, SchemaErrors schemaErrors) {
        Name name = attributeGroupInfo.name;
        if (name == null) {
            return false;
        }
        AttributeGroupInfo attributeGroupInfo2 = (AttributeGroupInfo)schemaInfo.attributeGroupInfo.get(name);
        int n = 0;
        if (attributeGroupInfo.attributeGroupInfo != null) {
            AttributeGroupInfo[] attributeGroupInfoArray = attributeGroupInfo.attributeGroupInfo;
            AttributeGroupInfo attributeGroupInfo3 = null;
            int n2 = 0;
            while (n2 < attributeGroupInfoArray.length) {
                if (attributeGroupInfoArray[n2].ref == name) {
                    attributeGroupInfo3 = attributeGroupInfoArray[n2];
                    ++n;
                }
                ++n2;
            }
            if (n > 0) {
                Name name2;
                if (n > 1) {
                    schemaErrors.append(attributeGroupInfo, "src-redefine.7.1", "severalSelfReferences", "attributeGroup", name.format(false, attributeGroupInfo));
                    return false;
                }
                if (attributeGroupInfo2 == null) {
                    schemaErrors.append(attributeGroupInfo, "src-expredef.2", "missingRedefinedComponent", "attributeGroup", name.format(false, attributeGroupInfo), schemaInfo.getLocation());
                    return false;
                }
                schemaInfo.attributeGroupInfo.remove(name);
                attributeGroupInfo2.name = name2 = RedefineInfo.redefinedName(name);
                schemaInfo.attributeGroupInfo.put(name2, attributeGroupInfo2);
                attributeGroupInfo3.ref = name2;
            }
        }
        if (n == 0 && attributeGroupInfo2 == null) {
            schemaErrors.append(attributeGroupInfo, "src-redefine.7.2.1", "missingRedefinedComponent", "attributeGroup", name.format(false, attributeGroupInfo), schemaInfo.getLocation());
            return false;
        }
        schemaInfo.attributeGroupInfo.put(name, attributeGroupInfo);
        return true;
    }

    private static Name redefinedName(Name name) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("__");
        stringBuffer.append(redefineCounter++);
        stringBuffer.append("__");
        stringBuffer.append(name.getLocalPart());
        return Name.get(name.getNamespace(), stringBuffer.toString());
    }

    private static class GroupSelfReference {
        public int count;
        public GroupInfo groupInfo;

        private GroupSelfReference() {
        }
    }
}

