/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xsd.load.AttributeGroupInfo;
import com.xmlmind.xmledit.xsd.load.AttributeInfo;
import com.xmlmind.xmledit.xsd.load.ComplexTypeInfo;
import com.xmlmind.xmledit.xsd.load.ElementInfo;
import com.xmlmind.xmledit.xsd.load.GroupInfo;
import com.xmlmind.xmledit.xsd.load.ImportInfo;
import com.xmlmind.xmledit.xsd.load.IncludeInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.NotationInfo;
import com.xmlmind.xmledit.xsd.load.RedefineInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SimpleTypeInfo;
import java.net.URL;
import java.util.Hashtable;
import java.util.IdentityHashMap;

final class SchemaInfo
extends Info {
    public Namespace targetNamespace;
    public boolean inheritsTargetNamespace;
    public boolean attributeFormQualified = false;
    public boolean elementFormQualified = false;
    public int blockDefault = 0;
    public int finalDefault = 0;
    public Hashtable typeInfo = new Hashtable();
    public Hashtable elementInfo = new Hashtable();
    public Hashtable attributeInfo = new Hashtable();
    public Hashtable groupInfo = new Hashtable();
    public Hashtable attributeGroupInfo = new Hashtable();
    public Hashtable notationInfo = new Hashtable();
    public PrefixEntry[] preferredPrefixes = null;
    public URL[] sourceURLs = null;
    public IdentityHashMap importedNamespaces = null;

    public SchemaInfo(Namespace namespace) {
        super(null);
        this.targetNamespace = namespace;
        this.inheritsTargetNamespace = namespace != Namespace.NONE;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.preferredPrefixes = SchemaInfo.loadPreferredPrefixes(element);
        URL uRL = element.getLocation();
        this.sourceURLs = uRL != null ? new URL[]{uRL} : new URL[0];
        String string = Info.getNamespaceURIAttribute(element, Info._TARGET_NAMESPACE, null);
        if (string != null) {
            this.targetNamespace = Namespace.get(string);
            this.inheritsTargetNamespace = false;
        }
        this.elementFormQualified = Info.getFormAttribute(element, Info._ELEMENT_FORM_DEFAULT, false);
        this.attributeFormQualified = Info.getFormAttribute(element, Info._ATTRIBUTE_FORM_DEFAULT, false);
        this.blockDefault = Info.getBlockAttribute(element, Info._BLOCK_DEFAULT, 0);
        this.finalDefault = Info.getFinalAttribute(element, Info._FINAL_DEFAULT, 0);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Info info;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_ELEMENT) {
                    info = new ElementInfo(this);
                    ((ElementInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((ElementInfo)info).name != null && this.elementInfo.put(((ElementInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateElement", ((ElementInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_ATTRIBUTE) {
                    info = new AttributeInfo(this);
                    ((AttributeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((AttributeInfo)info).name != null && this.attributeInfo.put(((AttributeInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateAttribute", ((AttributeInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_SIMPLE_TYPE) {
                    info = new SimpleTypeInfo(this);
                    ((SimpleTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((SimpleTypeInfo)info).name != null && schemaInfo.typeInfo.put(((SimpleTypeInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateType", ((SimpleTypeInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_COMPLEX_TYPE) {
                    info = new ComplexTypeInfo(this);
                    ((ComplexTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((ComplexTypeInfo)info).name != null && this.typeInfo.put(((ComplexTypeInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateType", ((ComplexTypeInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_GROUP) {
                    info = new GroupInfo(this);
                    ((GroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((GroupInfo)info).name != null && this.groupInfo.put(((GroupInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateGroup", ((GroupInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_ATTRIBUTE_GROUP) {
                    info = new AttributeGroupInfo(this);
                    ((AttributeGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((AttributeGroupInfo)info).name != null && this.attributeGroupInfo.put(((AttributeGroupInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateAttributeGroup", ((AttributeGroupInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_NOTATION) {
                    info = new NotationInfo(this);
                    ((NotationInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    if (((NotationInfo)info).name != null && this.notationInfo.put(((NotationInfo)info).name, info) != null) {
                        schemaErrors2.append(info, "sch-props-correct.2", "duplicateNotation", ((NotationInfo)info).name.format(false, info));
                    }
                } else if (name == Info.XSD_INCLUDE) {
                    info = new IncludeInfo(this);
                    ((IncludeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                } else if (name == Info.XSD_IMPORT) {
                    info = new ImportInfo(this);
                    ((ImportInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                } else if (name == Info.XSD_REDEFINE) {
                    info = new RedefineInfo(this);
                    ((RedefineInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                }
            }
            node = node.getNextSibling();
        }
    }

    private static PrefixEntry[] loadPreferredPrefixes(Element element) {
        PreferredPrefix preferredPrefix = new PreferredPrefix();
        Document.loadPreferredPrefixes(element, false, false, preferredPrefix);
        return preferredPrefix.getAll();
    }

    public void addImportedNamespace(Namespace namespace) {
        if (this.importedNamespaces == null) {
            this.importedNamespaces = new IdentityHashMap();
        }
        this.importedNamespaces.put(namespace, namespace);
    }

    public boolean isImportedNamespace(Namespace namespace) {
        if (this.importedNamespaces == null) {
            return false;
        }
        return this.importedNamespaces.containsKey(namespace);
    }
}

