/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.jclark.xml.parse.OpenEntity;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceURLPair;
import com.xmlmind.xmledit.xsd.load.AttributeInfo;
import com.xmlmind.xmledit.xsd.load.ComplexTypeInfo;
import com.xmlmind.xmledit.xsd.load.ElementInfo;
import com.xmlmind.xmledit.xsd.load.IdentityConstraintInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.InfoLoader;
import com.xmlmind.xmledit.xsd.load.KeyInfo;
import com.xmlmind.xmledit.xsd.load.KeyrefInfo;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.NotationInfo;
import com.xmlmind.xmledit.xsd.load.SchemaError;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SimpleTypeInfo;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import com.xmlmind.xmledit.xsd.load.UniqueInfo;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.MultiXMLSchema;
import com.xmlmind.xmledit.xsd.validate.Notation;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.XMLSchema;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public final class SchemaLoader {
    private SchemaError[] errorList;
    private SchemaError[] warningList;

    public XMLSchema load(File file) throws IOException {
        return this.load(FileUtil.fileToURL(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLSchema load(URL uRL) throws IOException {
        XMLSchema xMLSchema;
        InputStream inputStream = uRL.openStream();
        try {
            xMLSchema = this.load(new OpenEntity(inputStream, uRL.toExternalForm(), uRL));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return xMLSchema;
    }

    public XMLSchema load(OpenEntity openEntity) throws IOException {
        DocumentLoader documentLoader = InfoLoader.createDocumentLoader();
        Document document = documentLoader.load(openEntity);
        return this.load(document);
    }

    public XMLSchema load(Document document) {
        this.errorList = SchemaErrors.NO_ERRORS;
        this.warningList = SchemaErrors.NO_ERRORS;
        InfoLoader infoLoader = new InfoLoader();
        LoadContext loadContext = new LoadContext();
        SchemaInfo schemaInfo = infoLoader.load(document, null, loadContext);
        if (schemaInfo == null) {
            this.warningList = infoLoader.getWarnings();
            this.errorList = infoLoader.getErrors();
            return null;
        }
        LoadState loadState = new LoadState(schemaInfo);
        SchemaError[] schemaErrorArray = infoLoader.getWarnings();
        int n = 0;
        while (n < schemaErrorArray.length) {
            loadState.warnings.append(schemaErrorArray[n]);
            ++n;
        }
        this.load(loadState);
        XMLSchema xMLSchema = loadState.schema;
        this.warningList = loadState.warnings.toArray();
        this.errorList = loadState.errors.toArray();
        if (this.errorList.length > 0) {
            xMLSchema = null;
        }
        return xMLSchema;
    }

    public MultiXMLSchema load(NamespaceURLPair[] namespaceURLPairArray) {
        Serializable serializable;
        Namespace[] namespaceArray;
        Object object;
        Document document = new Document();
        Element element = new Element(Info.XSD_SCHEMA);
        element.putAttribute(Info._TARGET_NAMESPACE, "not:a:target:namespace");
        document.appendChild(element);
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        int n = 0;
        while (n < namespaceURLPairArray.length) {
            object = namespaceURLPairArray[n];
            if (!arrayList.contains(((NamespaceURLPair)object).namespace)) {
                arrayList.add(((NamespaceURLPair)object).namespace);
            }
            namespaceArray = new Element(Info.XSD_IMPORT);
            if (((NamespaceURLPair)object).namespace != Namespace.NONE) {
                namespaceArray.putAttribute(Info._NAMESPACE, ((NamespaceURLPair)object).namespace.getURI());
            }
            namespaceArray.putAttribute(Info._SCHEMA_LOCATION, ((NamespaceURLPair)object).url.toExternalForm());
            element.appendChild((Node)namespaceArray);
            ++n;
        }
        object = this.load(document);
        if (object == null) {
            return null;
        }
        namespaceArray = new Namespace[arrayList.size()];
        arrayList.toArray(namespaceArray);
        MultiXMLSchema multiXMLSchema = new MultiXMLSchema(namespaceArray);
        Enumeration enumeration = ((Schema)object).getElementDeclarations();
        while (enumeration.hasMoreElements()) {
            serializable = (ElementDeclaration)enumeration.nextElement();
            multiXMLSchema.addElementDeclaration((ElementDeclaration)serializable);
        }
        enumeration = ((Schema)object).getAttributeDeclarations();
        while (enumeration.hasMoreElements()) {
            serializable = (AttributeDeclaration)enumeration.nextElement();
            multiXMLSchema.addAttributeDeclaration((AttributeDeclaration)serializable);
        }
        enumeration = ((Schema)object).getTypes();
        while (enumeration.hasMoreElements()) {
            serializable = (Type)enumeration.nextElement();
            multiXMLSchema.addType((Type)serializable);
        }
        enumeration = ((Schema)object).getNotations();
        while (enumeration.hasMoreElements()) {
            serializable = (Notation)enumeration.nextElement();
            multiXMLSchema.addNotation((Notation)serializable);
        }
        multiXMLSchema.setPreferredPrefixes(((Schema)object).getPreferredPrefixes());
        multiXMLSchema.setSourceURLs(((Schema)object).getSourceURLs());
        return multiXMLSchema;
    }

    public SchemaError[] getErrors() {
        return this.errorList;
    }

    public SchemaError[] getWarnings() {
        return this.warningList;
    }

    private void load(LoadState loadState) {
        Serializable serializable;
        Info info;
        Serializable serializable2;
        Object object;
        SchemaInfo schemaInfo = loadState.schemaInfo;
        XMLSchema xMLSchema = loadState.schema;
        xMLSchema.setPreferredPrefixes(schemaInfo.preferredPrefixes);
        xMLSchema.setSourceURLs(schemaInfo.sourceURLs);
        Enumeration enumeration = schemaInfo.notationInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (NotationInfo)enumeration.nextElement();
            serializable2 = ((NotationInfo)object).toNotation(loadState);
            if (serializable2 == null) continue;
            xMLSchema.addNotation((Notation)serializable2);
        }
        enumeration = schemaInfo.typeInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (TypeInfo)enumeration.nextElement();
            serializable2 = object instanceof SimpleTypeInfo ? loadState.getType(((TypeInfo)object).name, (Info)object, "st-props-correct.1") : loadState.getType(((TypeInfo)object).name, (Info)object, "ct-props-correct.1");
        }
        enumeration = schemaInfo.typeInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (TypeInfo)enumeration.nextElement();
            if (!(object instanceof ComplexTypeInfo) || (serializable2 = (ComplexType)loadState.getType(((TypeInfo)object).name, (Info)object, "ct-props-correct.1")) == null || serializable2 == ComplexType.ANY || ((ComplexTypeInfo)object).toComplexType2((ComplexType)serializable2, loadState)) continue;
            loadState.addBadComponent(0, ((TypeInfo)object).name, "invalidComponent", (Info)object, "ct-props-correct.1");
        }
        enumeration = schemaInfo.attributeInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (AttributeInfo)enumeration.nextElement();
            loadState.getAttributeDeclaration(((AttributeInfo)object).name, (Info)object, "a-props-correct.1");
        }
        enumeration = schemaInfo.elementInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (ElementInfo)enumeration.nextElement();
            loadState.getElementDeclaration(((ElementInfo)object).name, (Info)object, "e-props-correct.1");
        }
        enumeration = schemaInfo.elementInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (ElementInfo)enumeration.nextElement();
            serializable2 = loadState.getElementDeclaration(((ElementInfo)object).name, (Info)object, "e-props-correct.1");
            if (serializable2 == null) continue;
            ((ElementInfo)object).toElementDeclaration2((ElementDeclaration)serializable2, loadState);
        }
        enumeration = schemaInfo.typeInfo.elements();
        while (enumeration.hasMoreElements()) {
            object = (TypeInfo)enumeration.nextElement();
            if (!(object instanceof ComplexTypeInfo) || (serializable2 = (ComplexType)loadState.getType(((TypeInfo)object).name, (Info)object, "ct-props-correct.1")) == null || serializable2 == ComplexType.ANY) continue;
            ((ComplexTypeInfo)object).toComplexType3((ComplexType)serializable2, loadState);
        }
        object = loadState.localComplexTypes;
        int n = ((Vector)object).size();
        int n2 = 0;
        while (n2 < n) {
            info = (ComplexTypeInfo)((Vector)object).elementAt(n2);
            serializable = (ComplexType)((Vector)object).elementAt(n2 + 1);
            ((ComplexTypeInfo)info).toComplexType3((ComplexType)serializable, loadState);
            n2 += 2;
        }
        enumeration = loadState.identityConstraints.elements();
        while (enumeration.hasMoreElements()) {
            info = (IdentityConstraintInfo)enumeration.nextElement();
            if (!(info instanceof KeyrefInfo)) continue;
            serializable = ((KeyrefInfo)info).refer;
            IdentityConstraintInfo identityConstraintInfo = (IdentityConstraintInfo)loadState.identityConstraints.get(serializable);
            if (identityConstraintInfo == null || !(identityConstraintInfo instanceof KeyInfo) && !(identityConstraintInfo instanceof UniqueInfo)) {
                loadState.errors.append(info, "c-props-correct.2", "badKeyref1");
                continue;
            }
            if (identityConstraintInfo.fields.length == ((IdentityConstraintInfo)info).fields.length) continue;
            loadState.errors.append(info, "c-props-correct.2", "badKeyref2");
        }
    }
}

