/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.ListType;
import com.xmlmind.xmledit.xsd.datatype.NOTATIONType;
import com.xmlmind.xmledit.xsd.datatype.Restriction;
import com.xmlmind.xmledit.xsd.datatype.UnionType;
import com.xmlmind.xmledit.xsd.load.FacetInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.ListInfo;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.RestrictionInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import com.xmlmind.xmledit.xsd.load.UnionInfo;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import java.io.Serializable;

final class SimpleTypeInfo
extends TypeInfo {
    public int final_ = 0;
    public int derivation = 2;
    public Name base = null;
    public SimpleTypeInfo baseTypeInfo = null;
    public FacetInfo[] facetInfo = null;
    public Name itemType = null;
    public SimpleTypeInfo itemTypeInfo = null;
    public Name[] memberTypes = null;
    public SimpleTypeInfo[] memberTypeInfo = null;
    private SimpleType created = null;

    public SimpleTypeInfo(Info info) {
        super(info);
    }

    public void add(FacetInfo facetInfo) {
        if (this.facetInfo == null) {
            this.facetInfo = new FacetInfo[]{facetInfo};
            return;
        }
        FacetInfo[] facetInfoArray = new FacetInfo[this.facetInfo.length + 1];
        System.arraycopy(this.facetInfo, 0, facetInfoArray, 0, this.facetInfo.length);
        facetInfoArray[this.facetInfo.length] = facetInfo;
        this.facetInfo = facetInfoArray;
    }

    public void add(SimpleTypeInfo simpleTypeInfo) {
        if (this.memberTypeInfo == null) {
            this.memberTypeInfo = new SimpleTypeInfo[]{simpleTypeInfo};
            return;
        }
        SimpleTypeInfo[] simpleTypeInfoArray = new SimpleTypeInfo[this.memberTypeInfo.length + 1];
        System.arraycopy(this.memberTypeInfo, 0, simpleTypeInfoArray, 0, this.memberTypeInfo.length);
        simpleTypeInfoArray[this.memberTypeInfo.length] = simpleTypeInfo;
        this.memberTypeInfo = simpleTypeInfoArray;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = Info.getNCNameAttribute(element, Info._NAME, schemaInfo.targetNamespace, null);
        this.final_ = Info.getFinalAttribute(element, Info._FINAL, schemaInfo.finalDefault);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_RESTRICTION) {
                    this.derivation = 2;
                    this.initRestriction(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_LIST) {
                    this.derivation = 8;
                    this.initList(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_UNION) {
                    this.derivation = 16;
                    this.initUnion(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
            }
            node = node.getNextSibling();
        }
        switch (this.derivation) {
            case 2: {
                if (this.base == null && this.baseTypeInfo == null) {
                    schemaErrors2.append(this, "src-simple-type.2", "missingBase");
                    break;
                }
                if (this.base == null || this.baseTypeInfo == null) break;
                schemaErrors2.append(this, "src-simple-type.2", "inconsistentBase");
                break;
            }
            case 8: {
                if (this.itemType == null && this.itemTypeInfo == null) {
                    schemaErrors2.append(this, "src-simple-type.3", "missingItemType");
                    break;
                }
                if (this.itemType == null || this.itemTypeInfo == null) break;
                schemaErrors2.append(this, "src-simple-type.3", "inconsistentItemType");
                break;
            }
            case 16: {
                if (this.memberTypes != null || this.memberTypeInfo != null) break;
                schemaErrors2.append(this, "x-src-simple-type", "missingMemberTypes");
            }
        }
    }

    private void initRestriction(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        RestrictionInfo restrictionInfo = new RestrictionInfo(this);
        restrictionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.base = this.getQNameAttribute(element, Info._BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_SIMPLE_TYPE) {
                    this.baseTypeInfo = new SimpleTypeInfo(restrictionInfo);
                    this.baseTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                } else {
                    String string;
                    Info.NameToFacetEntry nameToFacetEntry = (Info.NameToFacetEntry)Info.nameToFacet.get(name);
                    if (nameToFacetEntry != null && (string = element2.getAttribute(Info._VALUE)) != null) {
                        boolean bl = Info.getBooleanAttribute(element2, Info._FIXED, false);
                        FacetInfo facetInfo = new FacetInfo(restrictionInfo, nameToFacetEntry.facet, string, bl);
                        facetInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                        this.add(facetInfo);
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    private void initList(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        Element element2;
        ListInfo listInfo = new ListInfo(this);
        listInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.itemType = this.getQNameAttribute(element, Info._ITEM_TYPE, null);
        if (this.itemType != null) {
            this.checkImportedNamespaces(this.itemType, schemaInfo, schemaErrors2);
        }
        if ((element2 = Info.getChild(element, Info.XSD_SIMPLE_TYPE)) != null) {
            this.itemTypeInfo = new SimpleTypeInfo(listInfo);
            this.itemTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
    }

    private void initUnion(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        UnionInfo unionInfo = new UnionInfo(this);
        unionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.memberTypes = this.getQNamesAttribute(element, Info._MEMBER_TYPES, null);
        if (this.memberTypes != null) {
            this.checkImportedNamespaces(this.memberTypes, schemaInfo, schemaErrors2);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 4 && (element2 = (Element)node).getName() == Info.XSD_SIMPLE_TYPE) {
                SimpleTypeInfo simpleTypeInfo = new SimpleTypeInfo(unionInfo);
                simpleTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(simpleTypeInfo);
            }
            node = node.getNextSibling();
        }
    }

    public Type toType(LoadState loadState) {
        if (this.created == null) {
            this.created = this.toSimpleType(loadState);
        }
        return this.created;
    }

    private SimpleType toSimpleType(LoadState loadState) {
        DataType dataType;
        int n;
        SimpleType simpleType = this.derivation == 2 ? (this.base != null ? loadState.getSimpleType(this.base, this, "st-props-correct.1") : (this.baseTypeInfo != null ? (SimpleType)this.baseTypeInfo.toType(loadState) : SimpleType.ANY)) : SimpleType.ANY;
        if (simpleType == null) {
            return null;
        }
        switch (this.derivation) {
            case 8: {
                n = 4;
                break;
            }
            case 16: {
                n = 8;
                break;
            }
            default: {
                n = 2;
            }
        }
        int n2 = 0;
        if ((this.final_ & 1) != 0) {
            n2 |= 1;
        }
        if ((this.final_ & 2) != 0) {
            n2 |= 2;
        }
        if ((this.final_ & 8) != 0) {
            n2 |= 4;
        }
        if ((this.final_ & 0x10) != 0) {
            n2 |= 8;
        }
        SimpleType simpleType2 = new SimpleType(this.name, simpleType, n, false, n2, 0);
        switch (this.derivation) {
            case 8: {
                dataType = this.deriveByList(simpleType2, loadState);
                break;
            }
            case 16: {
                dataType = this.deriveByUnion(simpleType2, loadState);
                break;
            }
            default: {
                n = 2;
                dataType = this.deriveByRestriction(simpleType.getDataType(), simpleType2, loadState);
                if (dataType == null || !(dataType instanceof NOTATIONType) || TypeInfo.checkNotations(dataType, this, "st-props-correct.1", loadState)) break;
                dataType = null;
            }
        }
        if (dataType == null) {
            return null;
        }
        if ((simpleType.getProhibitedDerivations() & 2) != 0) {
            loadState.errors.append(this, "st-props-correct.3", "prohibitedRestriction");
            return null;
        }
        if (dataType instanceof ListType) {
            SimpleType simpleType3 = (SimpleType)((ListType)dataType).getItemType().getProperties();
            if ((simpleType3.getProhibitedDerivations() & 4) != 0) {
                loadState.errors.append(this, "st-props-correct.4.2.1", "prohibitedDerivationByList");
                return null;
            }
        } else if (dataType instanceof UnionType) {
            DataType[] dataTypeArray = ((UnionType)dataType).getMemberTypes();
            int n3 = 0;
            while (n3 < dataTypeArray.length) {
                SimpleType simpleType4 = (SimpleType)dataTypeArray[n3].getProperties();
                if ((simpleType4.getProhibitedDerivations() & 8) != 0) {
                    loadState.errors.append(this, "st-props-correct.4.2.2", "prohibitedDerivationByUnion");
                    return null;
                }
                ++n3;
            }
        }
        simpleType2.setDataType(dataType);
        return simpleType2;
    }

    private DataType deriveByRestriction(DataType dataType, SimpleType simpleType, LoadState loadState) {
        Restriction restriction = new Restriction(dataType);
        DataType dataType2 = null;
        try {
            if (this.facetInfo != null) {
                TypeInfo.applyFacets(restriction, this.facetInfo);
            }
            dataType2 = restriction.derive(simpleType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByRestriction", illegalArgumentException.getMessage());
            return null;
        }
        catch (InvalidDataException invalidDataException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByRestriction2", invalidDataException.getMessage(), invalidDataException.getConstraint());
            return null;
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByRestriction2", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType2;
    }

    private DataType deriveByList(SimpleType simpleType, LoadState loadState) {
        SimpleType simpleType2 = this.itemType != null ? loadState.getSimpleType(this.itemType, this, "st-props-correct.1") : (SimpleType)this.itemTypeInfo.toType(loadState);
        if (simpleType2 == null) {
            return null;
        }
        ListType listType = new ListType(simpleType2.getDataType());
        Restriction restriction = new Restriction(listType);
        DataType dataType = null;
        try {
            dataType = restriction.derive(simpleType);
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByList", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType;
    }

    private DataType deriveByUnion(SimpleType simpleType, LoadState loadState) {
        Serializable serializable;
        Object object;
        int n;
        int n2 = 0;
        if (this.memberTypes != null) {
            n2 += this.memberTypes.length;
        }
        if (this.memberTypeInfo != null) {
            n2 += this.memberTypeInfo.length;
        }
        SimpleType[] simpleTypeArray = new SimpleType[n2];
        n2 = 0;
        if (this.memberTypes != null) {
            n = 0;
            while (n < this.memberTypes.length) {
                object = this.memberTypes[n];
                serializable = loadState.getSimpleType((Name)object, this, "st-props-correct.1");
                if (serializable != null) {
                    simpleTypeArray[n2++] = serializable;
                }
                ++n;
            }
        }
        if (this.memberTypeInfo != null) {
            n = 0;
            while (n < this.memberTypeInfo.length) {
                object = this.memberTypeInfo[n];
                serializable = (SimpleType)((SimpleTypeInfo)object).toType(loadState);
                if (serializable != null) {
                    simpleTypeArray[n2++] = serializable;
                }
                ++n;
            }
        }
        if (n2 != simpleTypeArray.length) {
            return null;
        }
        DataType[] dataTypeArray = new DataType[n2];
        int n3 = 0;
        while (n3 < n2) {
            dataTypeArray[n3] = simpleTypeArray[n3].getDataType();
            ++n3;
        }
        serializable = new UnionType(dataTypeArray);
        Restriction restriction = new Restriction((DataType)serializable);
        DataType dataType = null;
        try {
            dataType = restriction.derive(simpleType);
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByUnion", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType;
    }
}

