/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceURLPair;
import com.xmlmind.xmledit.xsd.load.SchemaError;
import com.xmlmind.xmledit.xsd.load.SchemaLoader;
import com.xmlmind.xmledit.xsd.validate.DocumentationGenerator;
import com.xmlmind.xmledit.xsd.validate.MultiXMLSchema;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SchemaUtil;
import com.xmlmind.xmledit.xsd.validate.SerializedSchemas;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.XMLSchema;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class Validate {
    private SchemaLoader schemaLoader = new SchemaLoader();
    private DocumentLoader xmlDocLoader = new DocumentLoader();
    private boolean verbose = false;
    private SerializedSchemas inSchemas = null;
    private SerializedSchemas outSchemas = null;
    private File docDir = null;
    private String docCSS = null;
    private PrintWriter report;
    private Schema globalSchema = null;

    public static void main(final String[] stringArray) {
        Thread thread = new Thread(){

            public void run() {
                Validate validate = new Validate();
                validate.run(stringArray);
            }
        };
        thread.start();
    }

    private static void usage() {
        System.out.println("usage: java com.xmlmind.xmledit.xsd.load.Validate ?options? ?xml_doc ... xml_doc?\nOptions are:\n  -o <file> Generate report in file <file>.\n        Default: output report to console.\n  -s <schema> Use schema <schema> to validate XML documents.\n        Default: use what is specified by xsi:schemaLocation\n        and xsi:noNamespaceSchemaLocation.\n  -ss <namespace> <schema> Same as '-s' except that first\n        parameter specifies the target namespace\n        of the schema.\n        This target namespace is mandatory if the schema is\n        to be deserialized.\n        It is possible to specify several '-s' and '-ss'\n        options.\n  -r <dir> Load serialized schemas from directory <dir>\n        if found there, otherwise load schemas from\n        their XML sources.\n  -w <dir> Serialize loaded schemas to directory <dir>.\n  -gendoc <dir> Generate documentation in directory <dir>.\n  -css <URL> Add link to specified CSS URL in generated\n        documentation.\n  -v Be verbose. Default: be quiet.\n");
        System.exit(1);
    }

    private Validate() {
        this.xmlDocLoader.setNamespaceMode(1);
        this.xmlDocLoader.setAddedProperties(19);
    }

    private void run(String[] stringArray) {
        int n = this.configure(stringArray);
        int n2 = 0;
        int n3 = n;
        while (n3 < stringArray.length) {
            if (!this.validate(stringArray[n3])) {
                n2 = 3;
            }
            ++n3;
        }
        this.report.flush();
        this.report.close();
        System.exit(n2);
    }

    private int configure(String[] stringArray) {
        NamespaceURLPair[] namespaceURLPairArray;
        Object object;
        String string = null;
        ArrayList arrayList = new ArrayList();
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if ("-o".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string = stringArray[++n];
            } else if ("-s".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                this.addSchemaLocation(null, stringArray[++n], arrayList);
            } else if ("-ss".equals(object)) {
                if (n + 2 >= stringArray.length) {
                    Validate.usage();
                }
                this.addSchemaLocation(stringArray[n + 1], stringArray[n + 2], arrayList);
                n += 2;
            } else if ("-r".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string2 = stringArray[++n];
            } else if ("-w".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string3 = stringArray[++n];
            } else if ("-gendoc".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                this.docDir = new File(stringArray[++n]);
                if (!this.docDir.isDirectory()) {
                    Validate.usage();
                }
            } else if ("-css".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                this.docCSS = stringArray[++n].trim();
                if (this.docCSS.length() == 0) {
                    Validate.usage();
                }
            } else if ("-v".equals(object)) {
                this.verbose = true;
            } else {
                if (((String)object).indexOf(45) != 0) break;
                Validate.usage();
            }
            ++n;
        }
        object = null;
        if (string == null) {
            object = System.out;
        } else {
            try {
                object = new FileOutputStream(string);
            }
            catch (IOException iOException) {
                System.err.println("cannot create '" + string + "': " + iOException.getMessage());
                System.exit(1);
            }
        }
        this.report = new PrintWriter((OutputStream)object);
        if (string2 != null) {
            try {
                this.inSchemas = new SerializedSchemas(string2);
            }
            catch (Exception exception) {
                System.err.println("cannot initialize serialized schemas '" + string2 + "': " + exception.getMessage());
                System.exit(1);
            }
        }
        if (string3 != null) {
            namespaceURLPairArray = new File(string3);
            try {
                this.outSchemas = this.inSchemas != null && this.inSchemas.getDirectory().getCanonicalPath().equals(namespaceURLPairArray.getCanonicalPath()) ? this.inSchemas : new SerializedSchemas((File)namespaceURLPairArray);
            }
            catch (Exception exception) {
                System.err.println("cannot initialize serialized schemas '" + string3 + "': " + exception.getMessage());
                System.exit(1);
            }
        }
        if (arrayList.size() > 0) {
            namespaceURLPairArray = new NamespaceURLPair[arrayList.size()];
            arrayList.toArray(namespaceURLPairArray);
            this.globalSchema = this.loadSchemas(namespaceURLPairArray);
            if (this.globalSchema == null) {
                this.report.flush();
                this.report.close();
                System.exit(2);
            }
            if (this.docDir != null) {
                if (!this.generateDocumentation(this.globalSchema, this.docDir) && n >= stringArray.length) {
                    this.report.flush();
                    this.report.close();
                    System.exit(2);
                }
                this.docDir = null;
            }
        }
        return n;
    }

    private void addSchemaLocation(String string, String string2, ArrayList arrayList) {
        File file;
        Namespace namespace = null;
        if (string != null) {
            if ((string = string.trim()).length() == 0 || "-".equals(string)) {
                System.err.println("'" + string + "' invalid target namespace");
                Validate.usage();
            } else {
                namespace = Namespace.get(string);
            }
        }
        if (!(file = new File(string2)).isFile()) {
            System.err.println("'" + string2 + "' is not a file");
            Validate.usage();
        }
        arrayList.add(new NamespaceURLPair(namespace, FileUtil.fileToURL(file)));
    }

    private boolean generateDocumentation(Schema schema, File file) {
        long l = 0L;
        if (this.verbose) {
            System.err.print("Generating documentation in '" + file + "'");
            l = System.currentTimeMillis();
        }
        DocumentationGenerator documentationGenerator = new DocumentationGenerator(schema);
        if (this.docCSS != null) {
            documentationGenerator.setCSS(this.docCSS);
        }
        boolean bl = false;
        try {
            documentationGenerator.generateAll(file);
            bl = true;
        }
        catch (IOException iOException) {
            System.err.println("cannot generate documentation in '" + file + "': " + iOException.getMessage());
        }
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        return bl;
    }

    private Schema loadSchemas(NamespaceURLPair[] namespaceURLPairArray) {
        if (namespaceURLPairArray.length == 1) {
            return this.loadSchema(namespaceURLPairArray[0].namespace, namespaceURLPairArray[0].url);
        }
        MultiXMLSchema multiXMLSchema = null;
        String string = null;
        long l = 0L;
        if (this.verbose) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < namespaceURLPairArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\'');
                stringBuffer.append(namespaceURLPairArray[n].url.toExternalForm());
                stringBuffer.append('\'');
                ++n;
            }
            string = stringBuffer.toString();
            System.err.print("Loading schemas " + string);
            l = System.currentTimeMillis();
        }
        multiXMLSchema = this.schemaLoader.load(namespaceURLPairArray);
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        this.reportSchemaErrors(this.schemaLoader);
        return multiXMLSchema;
    }

    private Schema loadSchema(Namespace namespace, URL uRL) {
        XMLSchema xMLSchema;
        block15: {
            xMLSchema = null;
            if (this.inSchemas != null && namespace != null) {
                String string = namespace.getURI();
                SerializedSchemas.Entry entry = this.inSchemas.get(string);
                if (entry != null) {
                    try {
                        long l = 0L;
                        if (this.verbose) {
                            System.err.print("Deserializing schema '" + string + "'");
                            l = System.currentTimeMillis();
                        }
                        xMLSchema = (XMLSchema)entry.loadSchema();
                        if (this.verbose) {
                            l = System.currentTimeMillis() - l;
                            System.err.println(" (" + l + "ms)");
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("cannot deserialize schema '" + string + "': " + exception.getClass().getName() + ": " + exception.getMessage());
                        xMLSchema = null;
                    }
                }
                if (xMLSchema != null) {
                    return xMLSchema;
                }
            }
            try {
                long l = 0L;
                if (this.verbose) {
                    System.err.print("Loading schema '" + uRL + "'");
                    l = System.currentTimeMillis();
                }
                xMLSchema = this.schemaLoader.load(uRL);
                if (this.verbose) {
                    l = System.currentTimeMillis() - l;
                    System.err.println(" (" + l + "ms)");
                }
                this.reportSchemaErrors(this.schemaLoader);
            }
            catch (IOException iOException) {
                System.err.println("cannot load schema '" + uRL + "': " + iOException.getMessage());
                xMLSchema = null;
            }
            if (this.outSchemas == null || xMLSchema == null || (namespace = xMLSchema.getTargetNamespace()) == Namespace.NONE) break block15;
            String string = namespace.getURI();
            try {
                long l = 0L;
                if (this.verbose) {
                    System.err.print("Serializing schema '" + string + "'");
                    l = System.currentTimeMillis();
                }
                this.outSchemas.save(string, xMLSchema, null);
                if (this.verbose) {
                    l = System.currentTimeMillis() - l;
                    System.err.println(" (" + l + "ms)");
                }
            }
            catch (Exception exception) {
                System.err.println("cannot serialize schema '" + string + "': " + exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
        return xMLSchema;
    }

    private void reportSchemaErrors(SchemaLoader schemaLoader) {
        SchemaError[] schemaErrorArray;
        SchemaError[] schemaErrorArray2 = schemaLoader.getErrors();
        if (schemaErrorArray2.length > 0) {
            this.docDir = null;
            int n = 0;
            while (n < schemaErrorArray2.length) {
                SchemaError schemaError = schemaErrorArray2[n];
                this.report.print(schemaError.getLocation());
                this.report.print(":E:");
                this.report.print(schemaError.getLineNumber());
                this.report.print(':');
                this.report.print(schemaError.getColumnNumber());
                this.report.print(": ");
                this.report.print(schemaError.message);
                if (schemaError.constraint != null) {
                    this.report.print(" [");
                    this.report.print(schemaError.constraint);
                    this.report.println(']');
                }
                ++n;
            }
        }
        if ((schemaErrorArray = schemaLoader.getWarnings()).length > 0) {
            int n = 0;
            while (n < schemaErrorArray.length) {
                SchemaError schemaError = schemaErrorArray[n];
                this.report.print(schemaError.getLocation());
                this.report.print(":W:");
                this.report.print(schemaError.getLineNumber());
                this.report.print(':');
                this.report.print(schemaError.getColumnNumber());
                this.report.print(": ");
                this.report.print(schemaError.message);
                if (schemaError.constraint != null) {
                    this.report.print(" [");
                    this.report.print(schemaError.constraint);
                    this.report.println(']');
                }
                ++n;
            }
            this.report.println();
        }
    }

    private boolean validate(String string) {
        Schema schema;
        Document document = null;
        try {
            long l = 0L;
            if (this.verbose) {
                System.err.print("Loading XML document '" + string + "'");
                l = System.currentTimeMillis();
            }
            document = this.xmlDocLoader.load(new File(string));
            if (this.verbose) {
                l = System.currentTimeMillis() - l;
                System.err.println(" (" + l + "ms)");
            }
        }
        catch (IOException iOException) {
            System.err.println("cannot load '" + string + "': " + iOException.getMessage());
            return false;
        }
        if (this.globalSchema != null) {
            schema = this.globalSchema;
        } else {
            schema = this.loadLocalSchemas(document);
            if (schema == null) {
                return false;
            }
            if (this.docDir != null) {
                this.generateDocumentation(schema, this.docDir);
                this.docDir = null;
            }
        }
        long l = 0L;
        if (this.verbose) {
            System.err.print("Validating '" + string + "'");
            l = System.currentTimeMillis();
        }
        ValidationError[] validationErrorArray = schema.validate(document);
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        if (validationErrorArray.length > 0) {
            int n = 0;
            while (n < validationErrorArray.length) {
                String string2;
                String string3;
                String string4;
                ValidationError validationError = validationErrorArray[n];
                Element element = validationError.element;
                URL uRL = element.getLocation();
                int[] nArray = (int[])element.getProperty("LINE_COLUMN");
                String string5 = string4 = uRL == null ? "" : uRL.toString();
                if (nArray == null) {
                    string3 = "";
                    string2 = "";
                } else {
                    string2 = Integer.toString(nArray[0]);
                    string3 = Integer.toString(nArray[1]);
                }
                this.report.print(string4);
                this.report.print(":E:");
                this.report.print(string2);
                this.report.print(':');
                this.report.print(string3);
                this.report.print(": ");
                this.report.print(validationError.message);
                if (validationError.constraint != null) {
                    this.report.print(" [");
                    this.report.print(validationError.constraint);
                    this.report.println(']');
                }
                ++n;
            }
            this.report.println();
            return false;
        }
        return true;
    }

    private Schema loadLocalSchemas(Document document) {
        NamespaceURLPair[] namespaceURLPairArray;
        try {
            namespaceURLPairArray = SchemaUtil.getSchemaLocations(document);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("invalid schema locations specified on '" + document.getLocation() + "' root element: " + malformedURLException.getMessage());
            return null;
        }
        if (namespaceURLPairArray.length == 0) {
            System.err.println("no schema locations specified on '" + document.getLocation() + "' root element");
            return null;
        }
        return this.loadSchemas(namespaceURLPairArray);
    }
}

