/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.xsd.validate.Particle;
import java.util.ArrayList;

public final class ChoiceParticle
extends Particle {
    private Particle[] particles;

    public ChoiceParticle(Particle[] particleArray, int n, int n2) {
        super(n, n2);
        this.particles = particleArray;
    }

    public int getType() {
        return 1;
    }

    public Particle[] getParticles() {
        return this.particles;
    }

    public int rangeMin() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.particles.length) {
            int n3;
            Particle particle = this.particles[n2];
            switch (particle.getType()) {
                case 3: 
                case 4: {
                    n3 = particle.minOccurs;
                    break;
                }
                default: {
                    n3 = particle.rangeMin();
                }
            }
            if (n3 < n) {
                n = n3;
            }
            ++n2;
        }
        return n == Integer.MAX_VALUE ? 0 : this.minOccurs * n;
    }

    public int rangeMax() {
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (n2 < this.particles.length) {
            int n3;
            Particle particle = this.particles[n2];
            switch (particle.getType()) {
                case 3: 
                case 4: {
                    n3 = particle.maxOccurs;
                    break;
                }
                default: {
                    n3 = particle.rangeMax();
                }
            }
            if (n3 == -1 || n3 > 0 && this.maxOccurs == -1) {
                return -1;
            }
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n == Integer.MIN_VALUE ? 0 : this.maxOccurs * n;
    }

    public Particle simplify() {
        Particle[] particleArray;
        if (this.minOccurs == 0 && this.maxOccurs == 0 || this.particles.length == 0) {
            return null;
        }
        ArrayList<Particle> arrayList = new ArrayList<Particle>();
        int n = 0;
        while (n < this.particles.length) {
            Particle particle = this.particles[n].simplify();
            if (particle != null) {
                if (particle instanceof ChoiceParticle && particle.minOccurs == 1 && particle.maxOccurs == 1) {
                    particleArray = ((ChoiceParticle)particle).particles;
                    int n2 = 0;
                    while (n2 < particleArray.length) {
                        arrayList.add(particleArray[n2]);
                        ++n2;
                    }
                } else {
                    arrayList.add(particle);
                }
            }
            ++n;
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1 && this.minOccurs == 1 && this.maxOccurs == 1) {
            return (Particle)arrayList.get(0);
        }
        particleArray = new Particle[n3];
        arrayList.toArray(particleArray);
        return new ChoiceParticle(particleArray, this.minOccurs, this.maxOccurs);
    }

    protected void toString(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        int n = 0;
        while (n < this.particles.length) {
            if (n > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(this.particles[n]);
            ++n;
        }
        stringBuffer.append(')');
    }
}

