/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.NameRE;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import com.xmlmind.xmledit.xsd.validate.Wildcard;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Enumeration;

public class ComplexType
extends Type {
    public static final int EMPTY = 0;
    public static final int DATA = 1;
    public static final int ELEMENT_ONLY = 2;
    public static final int MIXED = 3;
    private static final SequenceParticle EMPTY_SEQUENCE = new SequenceParticle(new Particle[0], 1, 1);
    private static final AttributeUse[] NO_ATTRIBUTE_USES = new AttributeUse[0];
    private static final Name[] NO_NAMES = new Name[0];
    private static final Wildcard[] NO_WILDCARDS = new Wildcard[0];
    private static final Enumeration NO_DECLARATION_ENUMERATION = new LinearHashtable().elements();
    public static final Name XSD_ANY_TYPE = Name.get(Namespace.XSD, "anyType");
    public static final ComplexType ANY = ComplexType.createAnyType();
    private AttributeUse[] attributeUses = NO_ATTRIBUTE_USES;
    private Wildcard attributeWildcard = null;
    private LinearHashtable attributeDeclarations = null;
    private int contentType = 0;
    private DataType dataType = null;
    private Particle particle = null;
    private Name[] elementFields = NO_NAMES;
    private Wildcard[] elementWildcards = NO_WILDCARDS;
    private LinearHashtable elementDeclarations = null;
    private transient NameRE nameRE = null;

    private static final ComplexType createAnyType() {
        ComplexType complexType = new ComplexType(XSD_ANY_TYPE, null, 1, false, 0, 0);
        complexType.setAttributeWildcard(Wildcard.ANY);
        complexType.setContentType(new SequenceParticle(new Particle[]{new WildcardParticle(Wildcard.ANY, 1, 1)}, 0, -1), true);
        return complexType;
    }

    public ComplexType(Name name, Type type, int n, boolean bl, int n2, int n3) {
        super(name, type, n, bl, n2, n3);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.name == XSD_ANY_TYPE ? ANY : this;
    }

    public void setAttributeUses(AttributeUse[] attributeUseArray) {
        this.attributeUses = attributeUseArray;
    }

    public void setAttributeWildcard(Wildcard wildcard) {
        this.attributeWildcard = wildcard;
    }

    public void addAttributeDeclaration(AttributeDeclaration attributeDeclaration) {
        if (this.attributeDeclarations == null) {
            this.attributeDeclarations = new LinearHashtable();
        }
        this.attributeDeclarations.put(attributeDeclaration.getName(), attributeDeclaration);
    }

    public void setContentType(Particle particle, boolean bl) {
        if ((particle = particle.simplify()) == null) {
            if (!bl) {
                this.resetContentType();
                return;
            }
            particle = EMPTY_SEQUENCE;
        }
        this.contentType = bl ? 3 : 2;
        this.particle = particle;
        this.dataType = null;
        LinearHashtable linearHashtable = new LinearHashtable();
        LinearHashtable linearHashtable2 = new LinearHashtable();
        ComplexType.traverseParticle(particle, linearHashtable, linearHashtable2);
        int n = linearHashtable.size();
        if (n == 0) {
            this.elementFields = NO_NAMES;
        } else {
            this.elementFields = new Name[n];
            linearHashtable.copyElementsInto(this.elementFields);
        }
        n = linearHashtable2.size();
        if (n == 0) {
            this.elementWildcards = NO_WILDCARDS;
        } else {
            this.elementWildcards = new Wildcard[n];
            linearHashtable2.copyElementsInto(this.elementWildcards);
        }
    }

    private static final void traverseParticle(Particle particle, LinearHashtable linearHashtable, LinearHashtable linearHashtable2) {
        switch (particle.getType()) {
            case 0: {
                ComplexType.traverseParticles(((SequenceParticle)particle).getParticles(), linearHashtable, linearHashtable2);
                break;
            }
            case 1: {
                ComplexType.traverseParticles(((ChoiceParticle)particle).getParticles(), linearHashtable, linearHashtable2);
                break;
            }
            case 2: {
                ComplexType.traverseParticles(((AllParticle)particle).getParticles(), linearHashtable, linearHashtable2);
                break;
            }
            case 4: {
                Wildcard wildcard = ((WildcardParticle)particle).getWildcard();
                linearHashtable2.put(wildcard, wildcard);
                break;
            }
            default: {
                Name name = ((ElementParticle)particle).getElementName();
                linearHashtable.put(name, name);
            }
        }
    }

    private static final void traverseParticles(Particle[] particleArray, LinearHashtable linearHashtable, LinearHashtable linearHashtable2) {
        int n = 0;
        while (n < particleArray.length) {
            ComplexType.traverseParticle(particleArray[n], linearHashtable, linearHashtable2);
            ++n;
        }
    }

    public void setContentType(DataType dataType) {
        this.contentType = 1;
        this.dataType = dataType;
        this.particle = null;
        this.elementFields = NO_NAMES;
        this.elementWildcards = NO_WILDCARDS;
    }

    public void resetContentType() {
        this.contentType = 0;
        this.dataType = null;
        this.particle = null;
        this.elementFields = NO_NAMES;
        this.elementWildcards = NO_WILDCARDS;
    }

    public void addElementDeclaration(ElementDeclaration elementDeclaration) {
        if (this.elementDeclarations == null) {
            this.elementDeclarations = new LinearHashtable();
        }
        this.elementDeclarations.put(elementDeclaration.getName(), elementDeclaration);
    }

    public AttributeUse getAttributeUse(Name name) {
        int n = 0;
        while (n < this.attributeUses.length) {
            if (this.attributeUses[n].getName() == name) {
                return this.attributeUses[n];
            }
            ++n;
        }
        return null;
    }

    public AttributeUse[] getAttributeUses() {
        return this.attributeUses;
    }

    public Wildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    public boolean containsAttributeField(Name name) {
        int n = 0;
        while (n < this.attributeUses.length) {
            if (this.attributeUses[n].getName() == name) {
                return true;
            }
            ++n;
        }
        return this.attributeWildcard != null && this.attributeWildcard.match(name);
    }

    public AttributeDeclaration getAttributeDeclaration(Name name) {
        return this.attributeDeclarations == null ? null : (AttributeDeclaration)this.attributeDeclarations.get(name);
    }

    public int getAttributeDeclarationCount() {
        return this.attributeDeclarations == null ? 0 : this.attributeDeclarations.size();
    }

    public Enumeration getAttributeDeclarations() {
        if (this.attributeDeclarations == null) {
            return NO_DECLARATION_ENUMERATION;
        }
        return this.attributeDeclarations.elements();
    }

    public Name[] getElementFields() {
        return this.elementFields;
    }

    public Wildcard[] getElementWildcards() {
        return this.elementWildcards;
    }

    public boolean containsElementField(Name name) {
        int n = 0;
        while (n < this.elementFields.length) {
            if (this.elementFields[n] == name) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.elementWildcards.length) {
            if (this.elementWildcards[n2].match(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getContentType() {
        return this.contentType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public ElementDeclaration getElementDeclaration(Name name) {
        return this.elementDeclarations == null ? null : (ElementDeclaration)this.elementDeclarations.get(name);
    }

    public int getElementDeclarationCount() {
        return this.elementDeclarations == null ? 0 : this.elementDeclarations.size();
    }

    public Enumeration getElementDeclarations() {
        if (this.elementDeclarations == null) {
            return NO_DECLARATION_ENUMERATION;
        }
        return this.elementDeclarations.elements();
    }

    protected Object validate(Element element, String string, boolean bl, Schema schema, ValidationErrors validationErrors) {
        boolean bl2;
        int n;
        int n2;
        Serializable serializable;
        Object object;
        if (this.isAbstract) {
            validationErrors.append(element, "cvc-complex-type.1", Msg.msg("typeIsAbstract"));
            return null;
        }
        StringBuffer stringBuffer = null;
        Name[] nameArray = null;
        int n3 = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                case 0: {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(((Text)node).getTextChars());
                    break;
                }
                default: {
                    if (nameArray == null) {
                        nameArray = new Name[element.getChildCount()];
                    }
                    nameArray[n3++] = ((Element)node).getName();
                }
            }
            node = node.getNextSibling();
        }
        Object object2 = Type.VALID;
        if (!Type.isNilled(element)) {
            switch (this.contentType) {
                case 0: {
                    if (stringBuffer == null && nameArray == null) break;
                    validationErrors.append(element, "cvc-complex-type.2.1", Msg.msg("elementNotEmpty"));
                    object2 = null;
                    break;
                }
                case 1: {
                    if (nameArray != null) {
                        validationErrors.append(element, "cvc-complex-type.2.2", Msg.msg("elementHasChildElements"));
                        return null;
                    }
                    String string2 = stringBuffer == null || stringBuffer.length() == 0 ? (string == null ? "" : string) : stringBuffer.toString();
                    try {
                        object2 = this.dataType.valueOf(string2, element);
                    }
                    catch (InvalidDataException invalidDataException) {
                        validationErrors.append(element, "cvc-complex-type.2.2", Msg.msg("elementContainsInvalidData", invalidDataException.getMessage(), invalidDataException.getConstraint()));
                        object2 = null;
                    }
                    break;
                }
                case 2: {
                    String string2;
                    if (stringBuffer != null) {
                        string2 = stringBuffer.toString();
                        int n4 = string2.length();
                        int n5 = 0;
                        block24: while (n5 < n4) {
                            switch (string2.charAt(n5)) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    break;
                                }
                                default: {
                                    validationErrors.append(element, "cvc-complex-type.2.3", Msg.msg("elementContainsText"));
                                    object2 = null;
                                    break block24;
                                }
                            }
                            ++n5;
                        }
                    }
                    if (nameArray == null) {
                        nameArray = NO_NAMES;
                    }
                    if (this.checkNameSequence(nameArray, n3)) break;
                    validationErrors.append(element, "cvc-complex-type.2.4", Msg.msg("invalidChildElementSequence"));
                    object2 = null;
                    break;
                }
                case 3: {
                    if (nameArray == null) {
                        object2 = stringBuffer == null ? (string == null ? "" : string) : stringBuffer.toString();
                        nameArray = NO_NAMES;
                    }
                    if (this.checkNameSequence(nameArray, n3)) break;
                    validationErrors.append(element, "cvc-complex-type.2.4", Msg.msg("invalidChildElementSequence"));
                    object2 = null;
                }
            }
        }
        int n6 = 0;
        if (element.getAttributeCount() > 0) {
            Enumeration enumeration = element.getAttributes();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                object = attribute.name;
                if (object == Name.XSI_TYPE || object == Name.XSI_NIL || object == Name.XSI_SCHEMA_LOCATION || object == Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION) continue;
                serializable = null;
                boolean bl3 = false;
                n2 = 0;
                while (n2 < this.attributeUses.length) {
                    AttributeUse attributeUse = this.attributeUses[n2];
                    if (attributeUse.getName() == object) {
                        bl3 = true;
                        serializable = this.getAttributeDeclaration((Name)object);
                        if (serializable != null) break;
                        serializable = schema.getAttributeDeclaration((Name)object);
                        break;
                    }
                    ++n2;
                }
                n = 0;
                bl2 = false;
                if (!bl3 && this.attributeWildcard != null && this.attributeWildcard.match((Name)object)) {
                    bl2 = true;
                    switch (this.attributeWildcard.getProcessContents()) {
                        case 2: {
                            n = 1;
                            break;
                        }
                        case 1: {
                            serializable = this.getAttributeDeclaration((Name)object);
                            if (serializable == null) {
                                serializable = schema.getAttributeDeclaration((Name)object);
                            }
                            if (serializable != null) break;
                            n = 1;
                            break;
                        }
                        default: {
                            serializable = this.getAttributeDeclaration((Name)object);
                            if (serializable != null) break;
                            serializable = schema.getAttributeDeclaration((Name)object);
                        }
                    }
                }
                if (serializable == null) {
                    if (n != 0) continue;
                    if (bl3 || bl2) {
                        validationErrors.append(element, "cvc-attribute.1", Msg.msg("undeclaredAttribute", ((Name)object).format(true, element)));
                    } else {
                        validationErrors.append(element, "cvc-complex-type.3", Msg.msg("notAnAttribute", ((Name)object).format(true, element)));
                    }
                    object2 = null;
                    continue;
                }
                if (((AttributeDeclaration)serializable).validate(attribute.value, element, schema, validationErrors) == null) {
                    ValidationError validationError = validationErrors.getLast();
                    validationError.element = element;
                    object2 = null;
                }
                if (bl3 || !(((AttributeDeclaration)serializable).getDataType() instanceof IDType)) continue;
                ++n6;
            }
        }
        if (n6 > 1) {
            validationErrors.append(element, "cvc-complex-type.5.1", Msg.msg("severalIDAttributes"));
            object2 = null;
        }
        boolean bl4 = false;
        int n7 = 0;
        while (n7 < this.attributeUses.length) {
            object = this.attributeUses[n7];
            serializable = ((AttributeUse)object).getName();
            if (((AttributeUse)object).isRequired() && element.getAttribute((Name)serializable) == null) {
                validationErrors.append(element, "cvc-complex-type.4", Msg.msg("missingRequiredAttribute", ((Name)serializable).format(true, element)));
                object2 = null;
            }
            if (n6 == 1 && !bl4) {
                AttributeDeclaration attributeDeclaration = this.getAttributeDeclaration((Name)serializable);
                if (attributeDeclaration == null) {
                    attributeDeclaration = schema.getAttributeDeclaration((Name)serializable);
                }
                if (attributeDeclaration != null && attributeDeclaration.getDataType() instanceof IDType) {
                    bl4 = true;
                }
            }
            ++n7;
        }
        if (n6 == 1 && bl4) {
            validationErrors.append(element, "cvc-complex-type.5.2", Msg.msg("idAttributeSuppliedByWildcard"));
            object2 = null;
        }
        if (bl) {
            node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 4) {
                    object = (Element)node;
                    serializable = ((Element)object).getName();
                    ElementDeclaration elementDeclaration = null;
                    n2 = 0;
                    n = 0;
                    while (n < this.elementFields.length) {
                        if (serializable == this.elementFields[n]) {
                            n2 = 1;
                            elementDeclaration = this.getElementDeclaration((Name)serializable);
                            if (elementDeclaration != null) break;
                            elementDeclaration = schema.getElementDeclaration((Name)serializable);
                            break;
                        }
                        ++n;
                    }
                    bl2 = false;
                    boolean bl5 = false;
                    if (n2 == 0) {
                        int n8 = 0;
                        block30: while (n8 < this.elementWildcards.length) {
                            Wildcard wildcard = this.elementWildcards[n8];
                            if (wildcard.match((Name)serializable)) {
                                bl5 = true;
                                switch (wildcard.getProcessContents()) {
                                    case 2: {
                                        bl2 = true;
                                        break;
                                    }
                                    case 1: {
                                        elementDeclaration = this.getElementDeclaration((Name)serializable);
                                        if (elementDeclaration == null) {
                                            elementDeclaration = schema.getElementDeclaration((Name)serializable);
                                        }
                                        if (elementDeclaration != null) break block30;
                                        bl2 = true;
                                        break;
                                    }
                                    default: {
                                        elementDeclaration = this.getElementDeclaration((Name)serializable);
                                        if (elementDeclaration != null) break block30;
                                        elementDeclaration = schema.getElementDeclaration((Name)serializable);
                                        break;
                                    }
                                }
                                break;
                            }
                            ++n8;
                        }
                    }
                    if (elementDeclaration == null) {
                        if (!bl2) {
                            if (n2 != 0 || bl5) {
                                validationErrors.append(element, "cvc-elt.1", Msg.msg("undeclaredChild", ((Name)serializable).format(false, element)));
                            } else {
                                validationErrors.append(element, "cvc-complex-type", Msg.msg("notAChild", ((Name)serializable).format(false, element)));
                            }
                            object2 = null;
                        }
                    } else if (elementDeclaration.validate((Element)object, true, schema, validationErrors) == null) {
                        object2 = null;
                    }
                }
                node = node.getNextSibling();
            }
        }
        return object2;
    }

    public final boolean checkNameSequence(Name[] nameArray, int n) {
        block2: {
            if (this.nameRE != null) break block2;
            try {
                this.nameRE = new NameRE(this.particle);
            }
            catch (NameRE.InvalidParticleException invalidParticleException) {
                invalidParticleException.printStackTrace();
            }
        }
        return this.nameRE.match(nameArray, n);
    }

    public boolean isValidDerivation(Type type, int n) {
        if (this == type) {
            return true;
        }
        if ((n & this.derivationMethod) != 0) {
            return false;
        }
        if (this.baseType == null) {
            return false;
        }
        if (this.baseType == type) {
            return true;
        }
        return this.baseType != ANY && this.baseType.isValidDerivation(type, n);
    }
}

