/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.CommentItem;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Item;
import com.xmlmind.xmledit.doctype.ProcessingInstructionItem;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.TextItem;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.AnyURIType;
import com.xmlmind.xmledit.xsd.datatype.BooleanType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.ListType;
import com.xmlmind.xmledit.xsd.datatype.QNameType;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.FieldImpl;
import com.xmlmind.xmledit.xsd.validate.NameList;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.SimpleList;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.Wildcard;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;

final class ElementTypeImpl
implements ElementType {
    private static final Name A_NAME = Name.get(Namespace.get("http://www.xmlmind.com/xmleditor/namespace/private"), "x");
    private static final FieldImpl[] NO_FIELDS = new FieldImpl[0];
    private static LinearHashtable NO_FIELD_MAP = new LinearHashtable();
    private static final FieldImpl[] XSI_FIELDS1 = new FieldImpl[]{new FieldImpl(Name.XSI_TYPE, false), new FieldImpl(Name.XSI_SCHEMA_LOCATION, false), new FieldImpl(Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION, false)};
    private static LinearHashtable XSI_FIELD_MAP1 = new LinearHashtable();
    private static final FieldImpl[] XSI_FIELDS2 = new FieldImpl[]{XSI_FIELDS1[0], XSI_FIELDS1[1], XSI_FIELDS1[2], new FieldImpl(Name.XSI_NIL, false)};
    private static LinearHashtable XSI_FIELD_MAP2 = new LinearHashtable();
    private static final XSIAttributeType XSI_NIL_ATTRIBUTE;
    private static final XSIAttributeType XSI_TYPE_ATTRIBUTE;
    private static final XSIAttributeType XSI_SCHEMA_LOCATION_ATTRIBUTE;
    private static final XSIAttributeType XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIBUTE;
    private static final Traversal.Handler typePropertyTrimmer;
    private static ParticleWeightCompare particleWeightCompare;
    private Schema schema;
    private ElementDeclaration decl;
    private Type type;
    private int contentType = -1;
    private FieldImpl[] attributeFields = null;
    private LinearHashtable nameToAttributeField = null;
    private int firstAttributeWildcard = -1;
    private int requiredAttributeCount = -1;
    private FieldImpl[] childElementFields = null;
    private LinearHashtable nameToChildElementField = null;
    private int firstChildElementWildcard = -1;
    private SimpleList nameOrItemList = new SimpleList();
    private NameList nameList = new NameList();
    private static final CompareWildcardFieldBySpecificity compareWildcardFieldBySpecificity;
    private static final SpaceItem SPACE_ITEM;

    public ElementTypeImpl(Schema schema, ElementDeclaration elementDeclaration, Type type) {
        this.schema = schema;
        this.decl = elementDeclaration;
        if (type == null) {
            type = elementDeclaration.getType();
        }
        this.type = type;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ElementDeclaration getElementDeclaration() {
        return this.decl;
    }

    public Type getType() {
        return this.type;
    }

    public int getElementContentType() {
        if (this.contentType < 0) {
            this.initContentType();
        }
        return this.contentType;
    }

    private void initContentType() {
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            this.contentType = complexType.getContentType();
            if (this.contentType == 3 && ElementTypeImpl.isMixed2(complexType.getParticle())) {
                this.contentType = 4;
            }
        } else {
            this.contentType = 1;
        }
    }

    private static final boolean isMixed2(Particle particle) {
        if (particle == null) {
            return true;
        }
        switch (particle.getType()) {
            case 1: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                if (particleArray.length != 0) break;
                return true;
            }
            case 0: {
                Particle[] particleArray = ((SequenceParticle)particle).getParticles();
                if (particleArray.length != 0) break;
                return true;
            }
            case 2: {
                Particle[] particleArray = ((AllParticle)particle).getParticles();
                if (particleArray.length != 0) break;
                return true;
            }
        }
        return ElementTypeImpl.isUnconstrainedChoice(particle);
    }

    private static final boolean isUnconstrainedChoice(Particle particle) {
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        switch (particle.getType()) {
            case 1: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                if (n == 1 && n2 == 1) {
                    return particleArray.length == 1 && ElementTypeImpl.isUnconstrainedChoice(particleArray[0]);
                }
                if (n == 0 && n2 == -1) {
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < particleArray.length) {
                        Particle particle2 = particleArray[n3];
                        if (!ElementTypeImpl.isUnconstrainedChoice2(particle2)) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    return bl;
                }
                return false;
            }
            case 0: {
                Particle[] particleArray = ((SequenceParticle)particle).getParticles();
                if (particleArray.length != 1) {
                    return false;
                }
                if (n == 1 && n2 == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice(particleArray[0]);
                }
                if (n == 0 && n2 == -1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
            case 2: {
                Particle[] particleArray = ((AllParticle)particle).getParticles();
                if (particleArray.length != 1) {
                    return false;
                }
                if (n == 1 && n2 == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice(particleArray[0]);
                }
                if (n == 0 && n2 == -1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
        }
        return n == 0 && n2 == -1;
    }

    private static final boolean isUnconstrainedChoice2(Particle particle) {
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        if (n != 0 && n != 1 || n2 != 1 && n2 != -1) {
            return false;
        }
        switch (particle.getType()) {
            case 1: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                boolean bl = true;
                int n3 = 0;
                while (n3 < particleArray.length) {
                    Particle particle2 = particleArray[n3];
                    if (!ElementTypeImpl.isUnconstrainedChoice2(particle2)) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                return bl;
            }
            case 0: {
                Particle[] particleArray = ((SequenceParticle)particle).getParticles();
                if (particleArray.length == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
            case 2: {
                Particle[] particleArray = ((AllParticle)particle).getParticles();
                if (particleArray.length == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
        }
        return true;
    }

    public DataType getElementDataType() {
        return this.type.getDataType();
    }

    public Object getElementDefaultValue() {
        return this.decl.getDefaultValue();
    }

    public Object getElementFixedValue() {
        return this.decl.isFixedValue() ? this.decl.getDefaultValue() : null;
    }

    public Field[] getAttributeFields() {
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        return this.attributeFields;
    }

    private void initAttributeFields() {
        boolean bl = this.schema.isDTD();
        if (this.type instanceof ComplexType) {
            FieldImpl[] fieldImplArray;
            ComplexType complexType = (ComplexType)this.type;
            AttributeUse[] attributeUseArray = complexType.getAttributeUses();
            Wildcard wildcard = complexType.getAttributeWildcard();
            int n = attributeUseArray.length;
            boolean bl2 = false;
            if (!bl) {
                bl2 = this.decl.isNillable();
                n = bl2 ? (n += XSI_FIELDS2.length) : (n += XSI_FIELDS1.length);
            }
            this.firstAttributeWildcard = n++;
            if (wildcard != null) {
                // empty if block
            }
            this.attributeFields = new FieldImpl[n];
            this.nameToAttributeField = new LinearHashtable();
            this.requiredAttributeCount = 0;
            int n2 = attributeUseArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FieldImpl fieldImpl;
                fieldImplArray = attributeUseArray[n3];
                Name name = fieldImplArray.getName();
                boolean bl3 = fieldImplArray.isRequired();
                this.attributeFields[n3] = fieldImpl = new FieldImpl(name, bl3);
                this.nameToAttributeField.put(name, fieldImpl);
                if (bl3) {
                    ++this.requiredAttributeCount;
                }
                ++n3;
            }
            if (!bl) {
                fieldImplArray = bl2 ? XSI_FIELDS2 : XSI_FIELDS1;
                System.arraycopy(fieldImplArray, 0, this.attributeFields, n2, fieldImplArray.length);
                n2 += fieldImplArray.length;
                int n4 = 0;
                while (n4 < fieldImplArray.length) {
                    FieldImpl fieldImpl = fieldImplArray[n4];
                    this.nameToAttributeField.put(fieldImpl.name, fieldImpl);
                    ++n4;
                }
            }
            if (wildcard != null) {
                this.attributeFields[n2] = new FieldImpl(wildcard.getNameWildcard(), false);
            }
        } else {
            if (bl) {
                this.attributeFields = NO_FIELDS;
                this.nameToAttributeField = NO_FIELD_MAP;
            } else if (this.decl.isNillable()) {
                this.attributeFields = XSI_FIELDS2;
                this.nameToAttributeField = XSI_FIELD_MAP2;
            } else {
                this.attributeFields = XSI_FIELDS1;
                this.nameToAttributeField = XSI_FIELD_MAP1;
            }
            this.requiredAttributeCount = 0;
            this.firstAttributeWildcard = this.attributeFields.length;
        }
    }

    public void getAttributeFields(Name name, List list) {
        FieldImpl fieldImpl;
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        if ((fieldImpl = (FieldImpl)this.nameToAttributeField.get(name)) != null) {
            list.add(fieldImpl);
        }
        if (this.firstAttributeWildcard < this.attributeFields.length && this.attributeFields[this.firstAttributeWildcard].nameWildcard.match(name)) {
            list.add(this.attributeFields[this.firstAttributeWildcard]);
        }
    }

    public boolean isRequiredAttribute(Field field) {
        return ((FieldImpl)field).required;
    }

    public Data getAttributeDefaultValue(Name name) {
        FieldImpl fieldImpl;
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        if ((fieldImpl = (FieldImpl)this.nameToAttributeField.get(name)) == null) {
            return null;
        }
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name);
            if (attributeDeclaration == null) {
                attributeDeclaration = this.schema.getAttributeDeclaration(name);
            }
            if (attributeDeclaration == null) {
                return null;
            }
            return attributeDeclaration.getDefaultValue();
        }
        return null;
    }

    public Field[] getChildElementFields() {
        if (this.childElementFields == null) {
            this.initChildElementFields();
        }
        return this.childElementFields;
    }

    private void initChildElementFields() {
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            Name[] nameArray = complexType.getElementFields();
            Wildcard[] wildcardArray = complexType.getElementWildcards();
            int n = nameArray.length;
            this.childElementFields = new FieldImpl[n + wildcardArray.length];
            this.nameToChildElementField = new LinearHashtable();
            this.firstChildElementWildcard = n;
            int n2 = 0;
            while (n2 < n) {
                FieldImpl fieldImpl;
                Name name = nameArray[n2];
                this.childElementFields[n2] = fieldImpl = new FieldImpl(name);
                this.nameToChildElementField.put(name, fieldImpl);
                ++n2;
            }
            int n3 = 0;
            while (n3 < wildcardArray.length) {
                this.childElementFields[n++] = new FieldImpl(wildcardArray[n3].getNameWildcard());
                ++n3;
            }
            if (wildcardArray.length > 1) {
                Arrays.sort(this.childElementFields, nameArray.length, nameArray.length + wildcardArray.length, compareWildcardFieldBySpecificity);
            }
        } else {
            this.childElementFields = NO_FIELDS;
            this.nameToChildElementField = NO_FIELD_MAP;
            this.firstChildElementWildcard = NO_FIELDS.length;
        }
    }

    public void getChildElementFields(Name name, List list) {
        FieldImpl fieldImpl;
        if (this.childElementFields == null) {
            this.initChildElementFields();
        }
        if ((fieldImpl = (FieldImpl)this.nameToChildElementField.get(name)) != null) {
            list.add(fieldImpl);
        }
        int n = this.firstChildElementWildcard;
        while (n < this.childElementFields.length) {
            if (this.childElementFields[n].nameWildcard.match(name)) {
                list.add(this.childElementFields[n]);
            }
            ++n;
        }
    }

    public boolean canCheckAttributeStructure() {
        return true;
    }

    public boolean checkStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return this.checkAttributeStructure(fieldArray, n, itemArray, n2) && this.checkElementStructure(fieldArray, n, itemArray, n2);
    }

    public boolean checkAttributeStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        this.fieldsToNames(fieldArray, n, this.nameOrItemList);
        return this.checkAttributes(this.nameOrItemList, null);
    }

    public boolean checkElementStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        this.fieldsToNames(itemArray, n2, this.nameOrItemList);
        return this.checkChildNodes(this.nameOrItemList, false, null);
    }

    private void fieldsToNames(Item[] itemArray, int n, SimpleList simpleList) {
        simpleList.clear();
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item instanceof Field) {
                FieldImpl fieldImpl = (FieldImpl)item;
                if (fieldImpl.name != null) {
                    simpleList.add(fieldImpl.name);
                } else {
                    simpleList.add(ElementTypeImpl.wildcardToName(fieldImpl.nameWildcard));
                }
            } else {
                simpleList.add(item);
            }
            ++n2;
        }
    }

    private static final Name wildcardToName(NameWildcard nameWildcard) {
        Namespace[] namespaceArray = nameWildcard.getIncludedNamespaces();
        if (namespaceArray != null) {
            return Name.get(namespaceArray[0], "x");
        }
        return A_NAME;
    }

    private boolean checkAttributes(SimpleList simpleList, Structure structure) {
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < simpleList.size) {
            Name name = (Name)simpleList.list[n2];
            FieldImpl fieldImpl = (FieldImpl)this.nameToAttributeField.get(name);
            if (fieldImpl == null && this.firstAttributeWildcard < this.attributeFields.length && this.attributeFields[this.firstAttributeWildcard].nameWildcard.match(name)) {
                fieldImpl = this.attributeFields[this.firstAttributeWildcard];
            }
            if (fieldImpl == null) {
                return false;
            }
            if (fieldImpl.required) {
                ++n;
            }
            if (structure != null) {
                structure.addAttributeField(name, fieldImpl);
            }
            ++n2;
        }
        return n == this.requiredAttributeCount;
    }

    private boolean checkChildNodes(SimpleList simpleList, boolean bl, Structure structure) {
        Object object;
        if (this.childElementFields == null) {
            this.initChildElementFields();
        }
        boolean bl2 = false;
        this.nameList.clear();
        int n = 0;
        while (n < simpleList.size) {
            Object object2;
            object = simpleList.list[n];
            if (object instanceof Name) {
                object2 = (Name)object;
                FieldImpl fieldImpl = (FieldImpl)this.nameToChildElementField.get(object2);
                if (fieldImpl == null) {
                    int n2 = this.firstChildElementWildcard;
                    while (n2 < this.childElementFields.length) {
                        if (this.childElementFields[n2].nameWildcard.match((Name)object2)) {
                            fieldImpl = this.childElementFields[n2];
                            break;
                        }
                        ++n2;
                    }
                }
                if (fieldImpl == null) {
                    return false;
                }
                this.nameList.add((Name)object2);
                if (structure != null) {
                    structure.addChildNodeItem(fieldImpl);
                }
            } else {
                object2 = (Item)object;
                if (object2 == TextItem.INSTANCE) {
                    bl2 = true;
                } else if (object2 == SPACE_ITEM) {
                    if (!bl) {
                        bl2 = true;
                    }
                    object2 = TextItem.INSTANCE;
                }
                if (structure != null) {
                    structure.addChildNodeItem((Item)object2);
                }
            }
            ++n;
        }
        if (this.type instanceof ComplexType) {
            object = (ComplexType)this.type;
            switch (((ComplexType)object).getContentType()) {
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    if (!bl2) break;
                    return false;
                }
            }
            if (((ComplexType)object).getParticle() == null) {
                return this.nameList.size == 0;
            }
            return ((ComplexType)object).checkNameSequence(this.nameList.list, this.nameList.size);
        }
        return this.nameList.size == 0;
    }

    public boolean getStructure(Element element, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(element, structure) && this.doGetElementStructure(element, bl, structure);
    }

    public boolean getAttributeStructure(Element element, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(element, structure);
    }

    public boolean getElementStructure(Element element, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetElementStructure(element, bl, structure);
    }

    private boolean doGetAttributeStructure(Element element, Structure structure) {
        this.nameOrItemList.clear();
        if (element.getAttributeCount() > 0) {
            Enumeration enumeration = element.getAttributes();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                this.nameOrItemList.add(attribute.name);
            }
        }
        return this.checkAttributes(this.nameOrItemList, structure);
    }

    private boolean doGetElementStructure(Element element, boolean bl, Structure structure) {
        this.nameOrItemList.clear();
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    this.nameOrItemList.add(CommentItem.INSTANCE);
                    break;
                }
                case 2: {
                    this.nameOrItemList.add(ProcessingInstructionItem.INSTANCE);
                    break;
                }
                case 0: {
                    if (((Text)node).isXMLSpace()) {
                        this.nameOrItemList.add(SPACE_ITEM);
                        break;
                    }
                    this.nameOrItemList.add(TextItem.INSTANCE);
                    break;
                }
                default: {
                    this.nameOrItemList.add(((Element)node).getName());
                }
            }
            node = node.getNextSibling();
        }
        return this.checkChildNodes(this.nameOrItemList, bl, structure);
    }

    public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(attributeArray, n, nodeArray, n2, structure) && this.doGetElementStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    public boolean getAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(attributeArray, n, nodeArray, n2, structure);
    }

    public boolean getElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetElementStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    private boolean doGetAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, Structure structure) {
        this.nameOrItemList.clear();
        int n3 = 0;
        while (n3 < n) {
            this.nameOrItemList.add(attributeArray[n3].name);
            ++n3;
        }
        return this.checkAttributes(this.nameOrItemList, structure);
    }

    private boolean doGetElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        this.nameOrItemList.clear();
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeArray[n3];
            switch (node.getNodeType()) {
                case 1: {
                    this.nameOrItemList.add(CommentItem.INSTANCE);
                    break;
                }
                case 2: {
                    this.nameOrItemList.add(ProcessingInstructionItem.INSTANCE);
                    break;
                }
                case 0: {
                    if (((Text)node).isXMLSpace()) {
                        this.nameOrItemList.add(SPACE_ITEM);
                        break;
                    }
                    this.nameOrItemList.add(TextItem.INSTANCE);
                    break;
                }
                default: {
                    this.nameOrItemList.add(((Element)node).getName());
                }
            }
            ++n3;
        }
        return this.checkChildNodes(this.nameOrItemList, bl, structure);
    }

    public AttributeType getAttributeType(Field field, Name name) {
        ComplexType complexType;
        AttributeType attributeType = null;
        if (this.type instanceof ComplexType && (attributeType = (complexType = (ComplexType)this.type).getAttributeDeclaration(name)) == null) {
            attributeType = this.schema.getAttributeDeclaration(name);
        }
        if (attributeType == null) {
            if (name == Name.XSI_NIL) {
                attributeType = XSI_NIL_ATTRIBUTE;
            } else if (name == Name.XSI_TYPE) {
                attributeType = XSI_TYPE_ATTRIBUTE;
            } else if (name == Name.XSI_SCHEMA_LOCATION) {
                attributeType = XSI_SCHEMA_LOCATION_ATTRIBUTE;
            } else if (name == Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION) {
                attributeType = XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIBUTE;
            }
        }
        return attributeType;
    }

    public ElementType getChildElementType(Field field, Name name) {
        return this.doGetChildElementType(field, name, null);
    }

    public ElementType getChildElementType(Field field, Element element) {
        return this.doGetChildElementType(field, element.getName(), element);
    }

    private ElementType doGetChildElementType(Field field, Name name, Element element) {
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            ElementDeclaration elementDeclaration = complexType.getElementDeclaration(name);
            if (elementDeclaration == null) {
                elementDeclaration = this.schema.getElementDeclaration(name);
            }
            if (elementDeclaration == null) {
                return null;
            }
            return new ElementTypeImpl(this.schema, elementDeclaration, element == null ? null : this.schema.getElementLocalType(element));
        }
        return null;
    }

    public Element createInstance(Name name, int n) {
        Element element = new Element(name);
        if ((n & 4) != 0) {
            this.addChildren(element, this.type, n);
            Traversal.traverse(element, typePropertyTrimmer);
        } else {
            this.addChildText(element, this.type);
        }
        if ((n & 1) != 0) {
            this.addRequiredAttributes(element, this.type, n);
        }
        return element;
    }

    private void addChildText(Element element, Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            switch (complexType.getContentType()) {
                case 1: 
                case 3: {
                    element.appendChild(new Text());
                }
            }
        } else {
            element.appendChild(new Text());
        }
    }

    private boolean addChildren(Element element, Type type, int n) {
        if (type == null) {
            return true;
        }
        element.putProperty("type", type);
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            int n2 = complexType.getContentType();
            switch (n2) {
                case 0: {
                    return true;
                }
                case 1: {
                    element.appendChild(new Text());
                    return true;
                }
            }
            boolean bl = this.addChildren(element, complexType, complexType.getParticle(), n);
            if (bl && n2 == 3 && element.hasNoContent()) {
                element.appendChild(new Text());
            }
            return bl;
        }
        element.appendChild(new Text());
        return true;
    }

    private boolean addChildren(Element element, ComplexType complexType, Particle particle, int n) {
        boolean bl = true;
        int n2 = particle.getMinOccurs();
        if (n2 > 0) {
            int n3;
            int n4;
            int n5 = element.getChildCount();
            int n6 = particle.getType();
            block0 : switch (n6) {
                case 3: {
                    Object object = this.getElementNameAndType(complexType, (ElementParticle)particle);
                    bl = this.addChild(element, object.name, object.type, n);
                    break;
                }
                case 4: {
                    Object object = this.getElementNameAndType(complexType, (WildcardParticle)particle);
                    bl = this.addChild(element, object.name, object.type, n);
                    break;
                }
                case 1: {
                    Object object = ((ChoiceParticle)particle).getParticles();
                    if (((Particle[])object).length == 0) {
                        bl = true;
                        break;
                    }
                    if (((Particle[])object).length == 1 || (n & 8) != 0) {
                        bl = false;
                        if ((n & 0x10) != 0) {
                            ParticleWeight particleWeight;
                            ParticleWeight[] particleWeightArray = new ParticleWeight[((Particle[])object).length];
                            int n7 = 0;
                            while (n7 < ((Particle[])object).length) {
                                Particle particle2 = object[n7];
                                particleWeight = new ParticleWeight();
                                particleWeight.particle = particle2;
                                particleWeight.weight = this.particleWeight(complexType, particle2);
                                if (particleWeight.weight == 0.0) {
                                    bl = true;
                                    break;
                                }
                                particleWeightArray[n7] = particleWeight;
                                ++n7;
                            }
                            if (!bl) {
                                if (((Particle[])object).length > 1) {
                                    Arrays.sort(particleWeightArray, particleWeightCompare);
                                }
                                int n8 = 0;
                                while (n8 < ((Particle[])object).length) {
                                    particleWeight = particleWeightArray[n8];
                                    if (this.addChildren(element, complexType, particleWeight.particle, n)) {
                                        bl = true;
                                        break;
                                    }
                                    ++n8;
                                }
                            }
                        }
                        if (bl) break;
                        int n9 = 0;
                        while (n9 < ((Particle[])object).length) {
                            if (this.addChildren(element, complexType, object[n9], n)) {
                                bl = true;
                                break block0;
                            }
                            ++n9;
                        }
                        break;
                    }
                    bl = true;
                    break;
                }
                case 0: 
                case 2: {
                    Object object = n6 == 0 ? ((SequenceParticle)particle).getParticles() : ((AllParticle)particle).getParticles();
                    bl = true;
                    int n10 = 0;
                    while (n10 < ((Particle[])object).length) {
                        if (!this.addChildren(element, complexType, object[n10], n)) {
                            bl = false;
                            break;
                        }
                        ++n10;
                    }
                    if (bl) break;
                    ElementTypeImpl.restoreChildren(element, n5);
                }
            }
            if (bl && n2 > 1 && (n4 = (n3 = element.getChildCount()) - n5) > 0) {
                Node[] nodeArray = new Node[n4];
                n4 = 0;
                int n11 = n5;
                while (n11 < n3) {
                    nodeArray[n4++] = element.getChild(n11);
                    ++n11;
                }
                while (n2 > 1) {
                    int n12 = 0;
                    while (n12 < n4) {
                        element.appendChild(nodeArray[n12].copy());
                        ++n12;
                    }
                    --n2;
                }
            }
        }
        return bl;
    }

    private NameAndType getElementNameAndType(ComplexType complexType, ElementParticle elementParticle) {
        Name name = elementParticle.getElementName();
        ElementDeclaration elementDeclaration = complexType.getElementDeclaration(name);
        if (elementDeclaration == null) {
            elementDeclaration = this.schema.getElementDeclaration(name);
        }
        Type type = elementDeclaration == null ? null : elementDeclaration.getType();
        return new NameAndType(name, type);
    }

    private NameAndType getElementNameAndType(ComplexType complexType, WildcardParticle wildcardParticle) {
        ElementDeclaration elementDeclaration;
        Wildcard wildcard = wildcardParticle.getWildcard();
        NameWildcard nameWildcard = wildcard.getNameWildcard();
        Name name = null;
        Type type = null;
        Enumeration enumeration = complexType.getElementDeclarations();
        while (enumeration.hasMoreElements()) {
            elementDeclaration = (ElementDeclaration)enumeration.nextElement();
            if (!nameWildcard.match(elementDeclaration.getName())) continue;
            name = elementDeclaration.getName();
            type = elementDeclaration.getType();
            break;
        }
        if (name == null) {
            enumeration = this.schema.getElementDeclarations();
            while (enumeration.hasMoreElements()) {
                elementDeclaration = (ElementDeclaration)enumeration.nextElement();
                if (!nameWildcard.match(elementDeclaration.getName())) continue;
                name = elementDeclaration.getName();
                type = elementDeclaration.getType();
                break;
            }
        }
        if (name == null) {
            name = ElementTypeImpl.wildcardToName(nameWildcard);
        }
        return new NameAndType(name, type);
    }

    private double particleWeight(ComplexType complexType, Particle particle) {
        if (particle.getMinOccurs() == 0) {
            return 0.0;
        }
        double d = 0.0;
        int n = particle.getType();
        switch (n) {
            case 3: {
                NameAndType nameAndType = this.getElementNameAndType(complexType, (ElementParticle)particle);
                d = ElementTypeImpl.typeWeight(nameAndType.type, nameAndType.name);
                break;
            }
            case 4: {
                NameAndType nameAndType = this.getElementNameAndType(complexType, (WildcardParticle)particle);
                d = ElementTypeImpl.typeWeight(nameAndType.type, nameAndType.name);
                break;
            }
            case 1: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                if (particleArray.length == 0) {
                    d = 0.0;
                    break;
                }
                double d2 = -1.0;
                int n2 = 0;
                while (n2 < particleArray.length) {
                    Particle particle2 = particleArray[n2];
                    double d3 = this.particleWeight(complexType, particle2);
                    if (d2 < 0.0 || d3 < d2) {
                        d2 = d3;
                    }
                    ++n2;
                }
                if (!(d2 >= 0.0)) break;
                d = d2;
                break;
            }
            case 0: 
            case 2: {
                Particle[] particleArray = n == 0 ? ((SequenceParticle)particle).getParticles() : ((AllParticle)particle).getParticles();
                if (particleArray.length == 0) {
                    d = 0.0;
                    break;
                }
                int n3 = 0;
                while (n3 < particleArray.length) {
                    Particle particle3 = particleArray[n3];
                    d += this.particleWeight(complexType, particle3);
                    ++n3;
                }
                break;
            }
        }
        return d;
    }

    private static int typeWeight(Type type, Name name) {
        int n;
        int n2 = 0;
        if (type == null) {
            n = 8;
        } else if (type instanceof SimpleType) {
            n = 2;
        } else {
            ComplexType complexType = (ComplexType)type;
            switch (complexType.getContentType()) {
                case 3: {
                    n = complexType.getParticle().isEmptiable() ? 1 : 6;
                    break;
                }
                case 2: {
                    n = complexType.getParticle().isEmptiable() ? 5 : 7;
                    break;
                }
                case 1: {
                    n = 4;
                    break;
                }
                default: {
                    n = 3;
                }
            }
            AttributeUse[] attributeUseArray = complexType.getAttributeUses();
            int n3 = 0;
            while (n3 < attributeUseArray.length) {
                if (attributeUseArray[n3].isRequired()) {
                    ++n2;
                }
                ++n3;
            }
            if (n2 > 9) {
                n2 = 9;
            }
        }
        int n4 = name.getLocalPart().length();
        if (n4 > 99) {
            n4 = 99;
        }
        return 10000 * n + 100 * n2 + n4;
    }

    private boolean addChild(Element element, Name name, Type type, int n) {
        if (type != null && ElementTypeImpl.isRecursiveStructure(element, type)) {
            return false;
        }
        Element element2 = new Element(name);
        element.appendChild(element2);
        if (!this.addChildren(element2, type, n)) {
            element.removeChild(element2);
            return false;
        }
        if ((n & 1) != 0) {
            this.addRequiredAttributes(element2, type, n);
        }
        return true;
    }

    private static final boolean isRecursiveStructure(Element element, Type type) {
        Element element2 = element;
        boolean bl = false;
        while (element2 != null) {
            Object object = element2.getProperty("type");
            if (object == null) break;
            if (object == type) {
                bl = true;
                break;
            }
            element2 = element2.getParentElement();
        }
        return bl;
    }

    private static final void restoreChildren(Element element, int n) {
        int n2 = element.getChildCount();
        while (n2 > n) {
            element.removeChild(element.getLastChild());
            --n2;
        }
    }

    private void addRequiredAttributes(Element element, Type type, int n) {
        if (type == null) {
            return;
        }
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            AttributeUse[] attributeUseArray = complexType.getAttributeUses();
            boolean bl = (n & 2) != 0;
            boolean bl2 = (n & 0x20) != 0;
            int n2 = 0;
            while (n2 < attributeUseArray.length) {
                AttributeUse attributeUse = attributeUseArray[n2];
                if (attributeUse.isRequired()) {
                    String string;
                    Name name = attributeUse.getName();
                    String string2 = string = bl2 ? "" : "???";
                    if (bl) {
                        AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name);
                        if (attributeDeclaration == null) {
                            attributeDeclaration = this.schema.getAttributeDeclaration(name);
                        }
                        if (attributeDeclaration != null && attributeDeclaration.getDataType() instanceof IDType) {
                            string = XMLUtil.getUniqueId();
                        }
                    }
                    element.putAttribute(name, string);
                }
                ++n2;
            }
        }
    }

    static {
        int n = 0;
        while (n < NO_FIELDS.length) {
            FieldImpl fieldImpl = NO_FIELDS[n];
            NO_FIELD_MAP.put(fieldImpl.name, fieldImpl);
            ++n;
        }
        int n2 = 0;
        while (n2 < XSI_FIELDS1.length) {
            FieldImpl fieldImpl = XSI_FIELDS1[n2];
            XSI_FIELD_MAP1.put(fieldImpl.name, fieldImpl);
            ++n2;
        }
        int n3 = 0;
        while (n3 < XSI_FIELDS2.length) {
            FieldImpl fieldImpl = XSI_FIELDS2[n3];
            XSI_FIELD_MAP2.put(fieldImpl.name, fieldImpl);
            ++n3;
        }
        XSI_NIL_ATTRIBUTE = new XSIAttributeType(BooleanType.BASE);
        XSI_TYPE_ATTRIBUTE = new XSIAttributeType(QNameType.BASE);
        XSI_SCHEMA_LOCATION_ATTRIBUTE = new XSIAttributeType(new ListType(AnyURIType.BASE));
        XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIBUTE = new XSIAttributeType(AnyURIType.BASE);
        typePropertyTrimmer = new Traversal.HandlerBase(){

            public Object enterElement(Element element) {
                element.removeProperty("type");
                return null;
            }
        };
        particleWeightCompare = new ParticleWeightCompare();
        compareWildcardFieldBySpecificity = new CompareWildcardFieldBySpecificity();
        SPACE_ITEM = new SpaceItem();
    }

    private static final class SpaceItem
    implements Item {
        private SpaceItem() {
        }
    }

    private static final class CompareWildcardFieldBySpecificity
    implements Comparator {
        private CompareWildcardFieldBySpecificity() {
        }

        public int compare(Object object, Object object2) {
            FieldImpl fieldImpl = (FieldImpl)object;
            FieldImpl fieldImpl2 = (FieldImpl)object2;
            return fieldImpl2.nameWildcard.getSpecificity() - fieldImpl.nameWildcard.getSpecificity();
        }
    }

    private static final class ParticleWeightCompare
    implements Comparator {
        private ParticleWeightCompare() {
        }

        public int compare(Object object, Object object2) {
            double d = ((ParticleWeight)object).weight;
            double d2 = ((ParticleWeight)object2).weight;
            return d < d2 ? -1 : (d > d2 ? 1 : 0);
        }
    }

    private static final class ParticleWeight {
        public Particle particle;
        public double weight;

        private ParticleWeight() {
        }
    }

    private static final class NameAndType {
        public Name name;
        public Type type;

        public NameAndType(Name name, Type type) {
            this.name = name;
            this.type = type;
        }
    }

    private static final class XSIAttributeType
    implements AttributeType {
        private DataType dataType;

        public XSIAttributeType(DataType dataType) {
            this.dataType = dataType;
        }

        public DataType getAttributeDataType() {
            return this.dataType;
        }

        public Data getAttributeDefaultValue() {
            return null;
        }

        public Data getAttributeFixedValue() {
            return null;
        }
    }
}

