/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.IdEntry;
import com.xmlmind.xmledit.doctype.IdRefItem;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.ListValue;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementHandler;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

final class IdCollector
extends ElementHandler {
    private Map ids;
    private List idRefs;

    public IdCollector(Schema schema) {
        super(schema);
    }

    public void collect(Element element, Map map, List list) {
        this.ids = map;
        this.idRefs = list;
        this.traverse(element);
    }

    protected Object handleElement(Element element, ElementDeclaration elementDeclaration, Type type) {
        if (elementDeclaration == null || type instanceof SimpleType || element.getAttributeCount() == 0) {
            return null;
        }
        ComplexType complexType = (ComplexType)type;
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            int n;
            Object object;
            String[] stringArray;
            Attribute attribute = (Attribute)enumeration.nextElement();
            Name name = attribute.name;
            AttributeDeclaration attributeDeclaration = null;
            if (complexType.containsAttributeField(name) && (attributeDeclaration = complexType.getAttributeDeclaration(name)) == null) {
                attributeDeclaration = this.schema.getAttributeDeclaration(name);
            }
            if (attributeDeclaration == null) continue;
            DataType dataType = attributeDeclaration.getDataType();
            if (this.ids != null && dataType instanceof IDType) {
                try {
                    stringArray = dataType.valueOf(attribute.value, element).toString();
                }
                catch (InvalidDataException invalidDataException) {
                    stringArray = null;
                }
                if (stringArray != null) {
                    object = (IdEntry)this.ids.get(stringArray);
                    if (object == null) {
                        object = new IdEntry((String)stringArray, element);
                        this.ids.put(stringArray, object);
                    } else {
                        ((IdEntry)object).addElement(element);
                    }
                }
            }
            if (this.idRefs == null) continue;
            if (dataType instanceof IDREFType) {
                try {
                    stringArray = dataType.valueOf(attribute.value, element).toString();
                }
                catch (InvalidDataException invalidDataException) {
                    stringArray = null;
                }
                if (stringArray == null) continue;
                object = null;
                n = this.idRefs.size() - 1;
                if (n >= 0) {
                    object = (IdRefItem)this.idRefs.get(n);
                    if (((IdRefItem)object).element != element) {
                        object = null;
                    }
                }
                if (object == null) {
                    this.idRefs.add(new IdRefItem(element, (String)stringArray));
                    continue;
                }
                ((IdRefItem)object).addIdRef((String)stringArray);
                continue;
            }
            if (!(dataType instanceof IDREFSType)) continue;
            try {
                stringArray = ((ListValue)dataType.valueOf(attribute.value, element)).toStringArray();
            }
            catch (InvalidDataException invalidDataException) {
                stringArray = null;
            }
            if (stringArray == null) continue;
            object = null;
            n = this.idRefs.size() - 1;
            if (n >= 0) {
                object = (IdRefItem)this.idRefs.get(n);
                if (((IdRefItem)object).element != element) {
                    object = null;
                }
            }
            if (object == null) {
                this.idRefs.add(new IdRefItem(element, stringArray));
                continue;
            }
            ((IdRefItem)object).addIdRefs(stringArray);
        }
        return null;
    }
}

