/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.util.HashMap;

public final class NameRE {
    private static final int MATCH_NAME = 0;
    private static final int MATCH_WILDCARD = 1;
    private static final int MATCH_ALL_NAMES = 2;
    private static final int CHOICE = 3;
    private static final int INIT_UNCONDITIONAL_LOOP = 4;
    private static final int UNCONDITIONAL_LOOP = 5;
    private static final int NOTHING = 6;
    private static final int INIT_LOOP = 7;
    private static final int LOOP = 8;
    private static final int FAIL = 9;
    private static final String[] opcodeNames = new String[]{"MATCH_NAME", "MATCH_WILDCARD", "MATCH_ALL_NAMES", "CHOICE", "INIT_UNCONDITIONAL_LOOP", "UNCONDITIONAL_LOOP", "NOTHING", "INIT_LOOP", "LOOP", "FAIL"};
    private Program program;
    private boolean[] matched = null;

    public NameRE(Particle particle) throws InvalidParticleException {
        this.program = NameRE.compile(particle);
        int n = NameRE.matchedArrayLength(this.program, null, 0);
        if (n > 0) {
            this.matched = new boolean[n];
        }
    }

    private static int matchedArrayLength(Program program, Program program2, int n) {
        while (program != program2) {
            switch (program.opcode) {
                case 2: {
                    int n2 = ((MatchAllNames)program).list.length;
                    if (n2 <= n) break;
                    n = n2;
                    break;
                }
                case 3: {
                    Program[] programArray = ((Choice)program).choices;
                    Program program3 = program.next;
                    int n3 = 0;
                    while (n3 < programArray.length) {
                        int n4 = NameRE.matchedArrayLength(programArray[n3], program3, n);
                        if (n4 > n) {
                            n = n4;
                        }
                        ++n3;
                    }
                    break;
                }
            }
            program = program.next;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap = new HashMap();
        Program.toString(this.program, null, stringBuffer, hashMap, 0);
        return stringBuffer.toString();
    }

    private static Program compile(Particle particle) throws InvalidParticleException {
        Program program = NameRE.doCompile(particle);
        NameRE.fixUpChoices(program, null);
        return program;
    }

    private static void fixUpChoices(Program program, Program program2) {
        while (program != program2) {
            if (program.opcode == 3) {
                NameRE.fixUpChoice((Choice)program);
            }
            program = program.next;
        }
    }

    private static void fixUpChoice(Choice choice) {
        Program[] programArray = choice.choices;
        Program program = choice.next;
        int n = 0;
        while (n < programArray.length) {
            programArray[n].tail().next = program;
            ++n;
        }
        int n2 = 0;
        while (n2 < programArray.length) {
            NameRE.fixUpChoices(programArray[n2], program);
            ++n2;
        }
    }

    private static Program doCompile(Particle particle) throws InvalidParticleException {
        Program program;
        Program program2;
        Program program3;
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        if (n < 0 || n2 == 0 || n2 != -1 && n > n2) {
            throw new InvalidParticleException(particle, Msg.msg("NRE.invalidMinMaxOccurs"));
        }
        Program program4 = null;
        if (n > 0) {
            program3 = NameRE.compileParticle(particle);
            if (n == 1) {
                program4 = program3;
            } else {
                program2 = new InitLoop();
                program4 = program2;
                program4.next = program3;
                program = new Loop(n - 1, program3);
                ((InitLoop)program2).loop = program;
                program3.tail().next = program;
            }
        }
        program3 = null;
        if (n2 == -1) {
            UnconditionalLoop unconditionalLoop;
            program2 = new InitUnconditionalLoop();
            program3 = program2;
            program3.next = program = new Choice();
            Program program5 = NameRE.compileParticle(particle);
            program2.loop = unconditionalLoop = new UnconditionalLoop(program);
            program5.tail().next = unconditionalLoop;
            ((Choice)program).add(program5);
            ((Choice)program).add(new Program(6));
        } else {
            int n3 = n2 - n;
            if (n3 == 1) {
                program3 = program = new Choice();
                ((Choice)program).add(NameRE.compileParticle(particle));
                ((Choice)program).add(new Program(6));
            } else if (n3 > 1) {
                Loop loop;
                program3 = program = new InitLoop();
                Choice choice = new Choice();
                program3.next = choice;
                Program program6 = NameRE.compileParticle(particle);
                ((InitLoop)program).loop = loop = new Loop(n3, choice);
                loop.next = new Program(9);
                program6.tail().next = loop;
                choice.add(program6);
                choice.add(new Program(6));
            }
        }
        if (program4 == null) {
            program4 = program3;
        } else {
            program4.tail().next = program3;
        }
        return program4;
    }

    private static Program compileParticle(Particle particle) throws InvalidParticleException {
        switch (particle.getType()) {
            case 1: {
                return NameRE.compileChoiceParticle((ChoiceParticle)particle);
            }
            case 0: {
                return NameRE.compileSequenceParticle((SequenceParticle)particle);
            }
            case 2: {
                return NameRE.compileAllParticle((AllParticle)particle);
            }
            case 3: {
                return new MatchName(((ElementParticle)particle).getElementName());
            }
            case 4: {
                return new MatchWildcard(((WildcardParticle)particle).getWildcard().getNameWildcard());
            }
        }
        throw new RuntimeException("internal error: unknown particle " + particle.getType());
    }

    private static Program compileChoiceParticle(ChoiceParticle choiceParticle) throws InvalidParticleException {
        Particle[] particleArray = choiceParticle.getParticles();
        int n = particleArray.length;
        if (n == 0) {
            return new Program(6);
        }
        if (n == 1) {
            return NameRE.doCompile(particleArray[0]);
        }
        Choice choice = new Choice();
        int n2 = 0;
        while (n2 < n) {
            choice.add(NameRE.doCompile(particleArray[n2]));
            ++n2;
        }
        return choice;
    }

    private static Program compileSequenceParticle(SequenceParticle sequenceParticle) throws InvalidParticleException {
        Particle[] particleArray = sequenceParticle.getParticles();
        int n = particleArray.length;
        if (n == 0) {
            return new Program(6);
        }
        Program program = NameRE.doCompile(particleArray[0]);
        Program program2 = program.tail();
        int n2 = 1;
        while (n2 < n) {
            Program program3;
            program2.next = program3 = NameRE.doCompile(particleArray[n2]);
            program2 = program3.tail();
            ++n2;
        }
        return program;
    }

    private static Program compileAllParticle(AllParticle allParticle) throws InvalidParticleException {
        Particle[] particleArray = allParticle.getParticles();
        int n = particleArray.length;
        if (n == 0) {
            return new Program(6);
        }
        Name[] nameArray = new Name[n];
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            Particle particle = particleArray[n2];
            int n3 = particle.getMinOccurs();
            int n4 = particle.getMaxOccurs();
            if (particle.getType() != 3 || n3 > 1 || n4 != 1) {
                throw new InvalidParticleException(allParticle, Msg.msg("NRE.badAllParticle"));
            }
            nameArray[n2] = ((ElementParticle)particle).getElementName();
            blArray[n2] = n3 == 0;
            ++n2;
        }
        return new MatchAllNames(nameArray, blArray);
    }

    public boolean match(Name[] nameArray, int n) {
        return this.match(nameArray, 0, n, this.program);
    }

    private boolean match(Name[] nameArray, int n, int n2, Program program) {
        while (program != null) {
            Program program2 = program.next;
            switch (program.opcode) {
                case 0: {
                    if (n == n2 || ((MatchName)program).name != nameArray[n]) {
                        return false;
                    }
                    ++n;
                    break;
                }
                case 1: {
                    if (n == n2 || !((MatchWildcard)program).wildcard.match(nameArray[n])) {
                        return false;
                    }
                    ++n;
                    break;
                }
                case 2: {
                    Object object = (MatchAllNames)program;
                    Name[] nameArray2 = object.list;
                    int n3 = nameArray2.length;
                    boolean[] blArray = object.optional;
                    int n4 = 0;
                    while (n4 < n3) {
                        this.matched[n4] = false;
                        ++n4;
                    }
                    int n5 = 0;
                    while (n5 < n3) {
                        if (n == n2) break;
                        Name name = nameArray[n];
                        boolean bl = false;
                        int n6 = 0;
                        while (n6 < n3) {
                            if (!this.matched[n6] && nameArray2[n6] == name) {
                                bl = true;
                                this.matched[n6] = true;
                                break;
                            }
                            ++n6;
                        }
                        if (!bl) break;
                        ++n;
                        ++n5;
                    }
                    int n7 = 0;
                    while (n7 < n3) {
                        if (!this.matched[n7] && !blArray[n7]) {
                            return false;
                        }
                        ++n7;
                    }
                    break;
                }
                case 3: {
                    int n4;
                    Object object = ((Choice)program).choices;
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < ((Program[])object).length) {
                        if (object[n3].opcode != 0 || object[n3].next != program2) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl) {
                        boolean bl2 = false;
                        n4 = 0;
                        while (n4 < ((Program[])object).length) {
                            if (n != n2 && ((MatchName)object[n4]).name == nameArray[n]) {
                                bl2 = true;
                                break;
                            }
                            ++n4;
                        }
                        if (bl2) {
                            ++n;
                            break;
                        }
                        return false;
                    }
                    int n8 = 0;
                    while (n8 < ((Program[])object).length) {
                        Program program3 = object[n8];
                        if ((program3.opcode != 0 || n != n2 && ((MatchName)program3).name == nameArray[n]) && this.match(nameArray, n, n2, program3)) {
                            return true;
                        }
                        ++n8;
                    }
                    return false;
                }
                case 5: {
                    Object object = (UnconditionalLoop)program;
                    if (n <= object.start) break;
                    object.start = n;
                    program2 = object.begin;
                    break;
                }
                case 4: {
                    ((InitUnconditionalLoop)program).loop.start = n;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    Object object = ((InitLoop)program).loop;
                    object.start = n;
                    object.counter = 0;
                    break;
                }
                case 8: {
                    Object object = (Loop)program;
                    if (n <= object.start || object.counter >= object.maxCounter) break;
                    object.start = n;
                    ++object.counter;
                    program2 = object.begin;
                    break;
                }
                case 9: {
                    return false;
                }
                default: {
                    throw new RuntimeException("internal error: unknown opcode " + program.opcode);
                }
            }
            program = program2;
        }
        return n == n2;
    }

    private static final class InitLoop
    extends Program {
        public Loop loop;

        public InitLoop() {
            super(7);
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            stringBuffer.append("loop=");
            stringBuffer.append(Program.getLabel(this.loop, hashMap));
            stringBuffer.append('\n');
        }
    }

    private static final class Loop
    extends Program {
        public int counter;
        public int maxCounter;
        public int start;
        public Program begin;

        public Loop(int n, Program program) {
            super(8);
            this.maxCounter = n;
            this.begin = program;
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            stringBuffer.append("max=");
            stringBuffer.append(this.maxCounter);
            stringBuffer.append(" begin=");
            stringBuffer.append(Program.getLabel(this.begin, hashMap));
            stringBuffer.append('\n');
        }
    }

    private static final class InitUnconditionalLoop
    extends Program {
        public UnconditionalLoop loop;

        public InitUnconditionalLoop() {
            super(4);
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            stringBuffer.append("loop=");
            stringBuffer.append(Program.getLabel(this.loop, hashMap));
            stringBuffer.append('\n');
        }
    }

    private static final class UnconditionalLoop
    extends Program {
        public int start;
        public Program begin;

        public UnconditionalLoop(Program program) {
            super(5);
            this.begin = program;
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            stringBuffer.append("begin=");
            stringBuffer.append(Program.getLabel(this.begin, hashMap));
            stringBuffer.append('\n');
        }
    }

    private static final class Choice
    extends Program {
        public Program[] choices = new Program[0];

        public Choice() {
            super(3);
        }

        public void add(Program program) {
            Program[] programArray = new Program[this.choices.length + 1];
            System.arraycopy(this.choices, 0, programArray, 0, this.choices.length);
            programArray[this.choices.length] = program;
            this.choices = programArray;
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            int n2 = 0;
            while (n2 < this.choices.length) {
                Program.toString(this.choices[n2], this.next, stringBuffer, hashMap, n + 4);
                ++n2;
            }
        }
    }

    private static final class MatchAllNames
    extends Program {
        public Name[] list;
        public boolean[] optional;

        public MatchAllNames(Name[] nameArray, boolean[] blArray) {
            super(2);
            this.list = nameArray;
            this.optional = blArray;
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            int n2 = 0;
            while (n2 < this.list.length) {
                if (n2 > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.list[n2]);
                if (this.optional[n2]) {
                    stringBuffer.append('?');
                }
                ++n2;
            }
            stringBuffer.append('\n');
        }
    }

    private static final class MatchWildcard
    extends Program {
        public NameWildcard wildcard;

        public MatchWildcard(NameWildcard nameWildcard) {
            super(1);
            this.wildcard = nameWildcard;
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            stringBuffer.append(this.wildcard);
            stringBuffer.append('\n');
        }
    }

    private static final class MatchName
    extends Program {
        public Name name;

        public MatchName(Name name) {
            super(0);
            this.name = name;
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            super.toString(stringBuffer, hashMap, n);
            Program.appendSpace(stringBuffer, 8 + n);
            stringBuffer.append(this.name);
            stringBuffer.append('\n');
        }
    }

    public static class Program {
        public byte opcode;
        public Program next;

        public Program(int n) {
            this.opcode = (byte)n;
        }

        public final Program tail() {
            Program program = this;
            while (program.next != null) {
                program = program.next;
            }
            return program;
        }

        protected static void toString(Program program, Program program2, StringBuffer stringBuffer, HashMap hashMap, int n) {
            while (program != program2) {
                program.toString(stringBuffer, hashMap, n);
                program = program.next;
            }
        }

        protected void toString(StringBuffer stringBuffer, HashMap hashMap, int n) {
            String string = Program.getLabel(this, hashMap);
            stringBuffer.append(string);
            Program.appendSpace(stringBuffer, 8 - string.length() + n);
            stringBuffer.append(opcodeNames[this.opcode]);
            stringBuffer.append(" -> ");
            stringBuffer.append(Program.getLabel(this.next, hashMap));
            stringBuffer.append('\n');
        }

        protected static String getLabel(Program program, HashMap hashMap) {
            if (program == null) {
                return "/";
            }
            String string = (String)hashMap.get(program);
            if (string == null) {
                string = Integer.toString(hashMap.size());
                hashMap.put(program, string);
            }
            return string;
        }

        protected static void appendSpace(StringBuffer stringBuffer, int n) {
            while (n > 0) {
                stringBuffer.append(' ');
                --n;
            }
        }
    }

    public static class InvalidParticleException
    extends Exception {
        private Particle particle;

        public InvalidParticleException(Particle particle, String string) {
            super(string);
            this.particle = particle;
        }

        public Particle getParticle() {
            return this.particle;
        }
    }
}

