/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import java.io.Serializable;

public abstract class Particle
implements Serializable {
    public static final int SEQUENCE = 0;
    public static final int CHOICE = 1;
    public static final int ALL = 2;
    public static final int ELEMENT = 3;
    public static final int WILDCARD = 4;
    public static final int UNBOUNDED = -1;
    protected int minOccurs;
    protected int maxOccurs;

    protected Particle(int n, int n2) {
        this.setOccurs(n, n2);
    }

    public final void setOccurs(int n, int n2) {
        this.minOccurs = n;
        this.maxOccurs = n2;
    }

    public abstract int getType();

    public String getTypeName() {
        switch (this.getType()) {
            case 0: {
                return "sequence";
            }
            case 1: {
                return "choice";
            }
            case 2: {
                return "all";
            }
            case 3: {
                return "element";
            }
            case 4: {
                return "any";
            }
        }
        return null;
    }

    public final int getMinOccurs() {
        return this.minOccurs;
    }

    public final int getMaxOccurs() {
        return this.maxOccurs;
    }

    public final boolean isEmptiable() {
        return this.minOccurs == 0 || this.rangeMin() == 0;
    }

    public abstract int rangeMin();

    public abstract int rangeMax();

    public Particle simplify() {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return null;
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        if (this.maxOccurs == 1) {
            if (this.minOccurs == 0) {
                stringBuffer.append('?');
            }
        } else if (this.maxOccurs == -1) {
            if (this.minOccurs == 0) {
                stringBuffer.append('*');
            } else if (this.minOccurs == 1) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('{');
                stringBuffer.append(this.minOccurs);
                stringBuffer.append(",}");
            }
        } else {
            stringBuffer.append('{');
            stringBuffer.append(this.minOccurs);
            if (this.maxOccurs != this.minOccurs) {
                stringBuffer.append(',');
                stringBuffer.append(this.maxOccurs);
            }
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    protected abstract void toString(StringBuffer var1);
}

