/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xsd.validate.MultiXMLSchema;
import com.xmlmind.xmledit.xsd.validate.Schema;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class SerializedSchemas {
    public static final int CHECK_LOCAL_SOURCES = 1;
    public static final int CHECK_REMOTE_SOURCES = 2;
    private File directory;
    private boolean checkLocalSources;
    private boolean checkRemoteSources;
    private HashMap entries;
    private static final boolean trace = false;

    public SerializedSchemas(String string) throws IOException {
        this(new File(string));
    }

    public SerializedSchemas(File file) throws IOException {
        if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            throw new IllegalArgumentException("'" + file.getPath() + "' is not a directory or" + " is not readable or is not writable");
        }
        this.directory = file;
        this.checkLocalSources = true;
        this.checkRemoteSources = false;
        this.initEntries();
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setCheckSources(int n) {
        this.checkLocalSources = (n & 1) != 0;
        this.checkRemoteSources = (n & 2) != 0;
    }

    public int getCheckSources() {
        int n = 0;
        if (this.checkLocalSources) {
            n |= 1;
        }
        if (this.checkRemoteSources) {
            n |= 2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry save(String string, Schema schema, String string2) throws IllegalArgumentException, IOException {
        URL[] uRLArray;
        Object object;
        Object object2;
        String string3;
        if (string == null || (string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("null or empty id");
        }
        if (schema instanceof MultiXMLSchema) {
            throw new IllegalArgumentException("MultiXMLSchema cannot be serialized");
        }
        Entry entry = this.delete(string);
        if (entry == null) {
            string3 = null;
            int n = 0;
            while (n < Integer.MAX_VALUE) {
                string3 = "schema" + n;
                if (!new File(this.directory, string3 + ".ser").exists()) break;
                ++n;
            }
            if (string3 == null) {
                throw new RuntimeException("internal error: cannot find a baseName for '" + string + "' in directory '" + this.directory + "'");
            }
        } else {
            string3 = entry.baseName;
        }
        SerializedSchemas.trace("Serializing schema '" + string + "'.");
        File file = new File(this.directory, string3 + ".ser");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file), 4096));
        try {
            objectOutputStream.writeObject(schema);
            objectOutputStream.flush();
            object2 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
        if (string2 != null) {
            object = new File(this.directory, string3 + ".ent");
            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8");
            try {
                ((Writer)object2).write("<?xml encoding='UTF-8'?>\n");
                ((Writer)object2).write(string2);
                ((OutputStreamWriter)object2).flush();
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                ((OutputStreamWriter)object2).close();
                throw throwable;
            }
            ((OutputStreamWriter)object2).close();
            {
            }
        }
        if ((uRLArray = schema.getSourceURLs()) == null || uRLArray.length == 0) {
            object = new File[]{};
            object2 = new URL[]{};
        } else {
            Serializable[] serializableArray;
            object = new File[uRLArray.length];
            int n = 0;
            object2 = new URL[uRLArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < uRLArray.length) {
                serializableArray = uRLArray[n3];
                File file2 = FileUtil.urlToFile((URL)serializableArray);
                if (file2 != null) {
                    object[n++] = file2;
                } else {
                    object2[n2++] = serializableArray;
                }
                ++n3;
            }
            if (n != ((File[])object).length) {
                serializableArray = new File[n];
                System.arraycopy(object, 0, serializableArray, 0, n);
                object = serializableArray;
            }
            if (n2 != ((Object)object2).length) {
                serializableArray = new URL[n2];
                System.arraycopy(object2, 0, serializableArray, 0, n2);
                object2 = serializableArray;
            }
        }
        entry = new Entry(string, string3, System.currentTimeMillis(), (File[])object, (URL[])object2);
        this.entries.put(string, entry);
        this.saveEntries();
        return entry;
    }

    public Entry delete(String string) throws IOException {
        Entry entry = (Entry)this.entries.remove(string);
        if (entry != null) {
            File file = entry.getSchemaFile();
            file.delete();
            file = entry.getGeneralEntitiesFile();
            if (file != null) {
                file.delete();
            }
            this.saveEntries();
        }
        return entry;
    }

    public void deleteAll() throws IOException {
        this.entries.clear();
        FileUtil.emptyDirectory(this.directory);
        this.saveEntries();
    }

    public Entry get(String string) {
        Entry entry = (Entry)this.entries.get(string);
        if (entry != null) {
            int n;
            Serializable[] serializableArray;
            long l;
            boolean bl = true;
            if (this.checkLocalSources) {
                l = entry.serializationDate;
                serializableArray = entry.localSources;
                n = 0;
                while (n < serializableArray.length) {
                    Serializable serializable = serializableArray[n];
                    if (!((File)serializable).isFile() || ((File)serializable).lastModified() >= l) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (bl && this.checkRemoteSources) {
                l = entry.serializationDate;
                serializableArray = entry.remoteSources;
                n = 0;
                while (n < serializableArray.length) {
                    if (SerializedSchemas.lastModified((URL)serializableArray[n]) >= l) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                SerializedSchemas.trace("Serial '" + string + "' is obsolete.");
                entry = null;
                try {
                    this.delete(string);
                }
                catch (IOException iOException) {}
            } else {
                SerializedSchemas.trace("Serial '" + string + "' is up to date.");
            }
        } else {
            SerializedSchemas.trace("Schema '" + string + "' not found.");
        }
        return entry;
    }

    private static final long lastModified(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            uRLConnection.connect();
            long l = uRLConnection.getLastModified();
            return l <= 0L ? Long.MAX_VALUE : l;
        }
        catch (IOException iOException) {
            return Long.MAX_VALUE;
        }
    }

    private static final void trace(String string) {
    }

    private void initEntries() throws IOException {
        boolean bl = true;
        File file = new File(this.directory, "directory.txt");
        if (file.isFile() && file.lastModified() > 1133513321620L && this.loadEntries(file)) {
            bl = false;
        }
        if (bl) {
            this.entries = new HashMap();
            FileUtil.emptyDirectory(this.directory);
            this.saveEntries();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadEntries(File file) throws IOException {
        this.entries = new HashMap();
        String string = FileUtil.loadString(file, "UTF-8");
        String[] stringArray = StringUtil.split(string, '\n');
        int n = 0;
        int n2 = 1;
        boolean bl = true;
        String string2 = null;
        String string3 = null;
        long l = -1L;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<URL[]> arrayList2 = new ArrayList<URL[]>();
        int n3 = 0;
        block11: while (n3 < stringArray.length) {
            String string4 = stringArray[n3].trim();
            if (string4.length() != 0 && string4.charAt(0) != '#') {
                switch (n) {
                    case 0: {
                        if (!"{".equals(string4)) {
                            SerializedSchemas.syntaxError(file, n2, "expected '{', found '" + string4 + "'");
                            bl = false;
                            break block11;
                        }
                        n = 1;
                        break;
                    }
                    case 1: {
                        string2 = string4;
                        if ("-".equals(string2)) {
                            string2 = "";
                        }
                        n = 2;
                        break;
                    }
                    case 2: {
                        string3 = string4;
                        Object object = new File(this.directory, string3 + ".ser");
                        if (!((File)object).isFile()) {
                            SerializedSchemas.syntaxError(file, n2, "'" + object + "' is not a file");
                            bl = false;
                            break block11;
                        }
                        n = 3;
                        break;
                    }
                    case 3: {
                        try {
                            l = Long.parseLong(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            l = -1L;
                        }
                        if (l <= 0L) {
                            SerializedSchemas.syntaxError(file, n2, "expected date in ms since Epoch, found '" + string4 + "'");
                            bl = false;
                            break block11;
                        }
                        n = 4;
                        break;
                    }
                    case 4: {
                        URL[] uRLArray;
                        Object object;
                        if ("}".equals(string4)) {
                            object = new File[arrayList.size()];
                            arrayList.toArray((T[])object);
                            uRLArray = new URL[arrayList2.size()];
                            arrayList2.toArray(uRLArray);
                            this.entries.put(string2, new Entry(string2, string3, l, (File[])object, uRLArray));
                            string2 = null;
                            string3 = null;
                            l = -1L;
                            arrayList.clear();
                            arrayList2.clear();
                            n = 0;
                            break;
                        }
                        object = null;
                        uRLArray = null;
                        try {
                            uRLArray = new URL(string4);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (uRLArray != null && string4.startsWith("file:") && (object = FileUtil.urlToFile((URL)uRLArray)) == null) {
                            uRLArray = null;
                        }
                        if (uRLArray == null) {
                            SerializedSchemas.syntaxError(file, n2, "expected URL, found '" + string4 + "'");
                            bl = false;
                            break block11;
                        }
                        if (object != null) {
                            arrayList.add(object);
                            break;
                        }
                        arrayList2.add(uRLArray);
                    }
                }
                ++n2;
            }
            ++n3;
        }
        if (n == 0) return bl;
        SerializedSchemas.syntaxError(file, n2, "unexpected end of file");
        return false;
    }

    private static final void syntaxError(File file, int n, String string) {
        SerializedSchemas.trace("Syntax error in file '" + file + "' at line " + n + ":\n" + string);
    }

    private void saveEntries() throws IOException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# Created by com.xmlmind.xmledit.xsd.validate.SerializedSchemas.\n# PLEASE DO NOT EDIT!\n");
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            object = (Entry)iterator.next();
            stringBuffer.append("{\n");
            stringBuffer.append(((Entry)object).id.length() == 0 ? "-" : ((Entry)object).id);
            stringBuffer.append('\n');
            stringBuffer.append(((Entry)object).baseName);
            stringBuffer.append('\n');
            stringBuffer.append(Long.toString(((Entry)object).serializationDate));
            stringBuffer.append('\n');
            int n = 0;
            while (n < ((Entry)object).localSources.length) {
                URL uRL = FileUtil.fileToURL(((Entry)object).localSources[n]);
                stringBuffer.append(uRL.toExternalForm());
                stringBuffer.append('\n');
                ++n;
            }
            int n2 = 0;
            while (n2 < ((Entry)object).remoteSources.length) {
                stringBuffer.append(((Entry)object).remoteSources[n2].toExternalForm());
                stringBuffer.append('\n');
                ++n2;
            }
            stringBuffer.append("}\n");
        }
        object = new File(this.directory, "directory.txt");
        FileUtil.saveString(stringBuffer.toString(), (File)object, "UTF-8");
    }

    public final class Entry {
        private String id;
        private String baseName;
        private long serializationDate;
        private File[] localSources;
        private URL[] remoteSources;

        private Entry(String string, String string2, long l, File[] fileArray, URL[] uRLArray) {
            this.id = string;
            this.baseName = string2;
            this.serializationDate = l;
            this.localSources = fileArray;
            this.remoteSources = uRLArray;
        }

        public String getId() {
            return this.id;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public File getSchemaFile() {
            return new File(SerializedSchemas.this.directory, this.baseName + ".ser");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Schema loadSchema() throws IOException, ClassNotFoundException {
            Schema schema;
            SerializedSchemas.trace("Deserializing schema '" + this.id + "'.");
            File file = this.getSchemaFile();
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), 4096));
            try {
                schema = (Schema)objectInputStream.readObject();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                objectInputStream.close();
                throw throwable;
            }
            objectInputStream.close();
            return schema;
        }

        public File getGeneralEntitiesFile() {
            File file = new File(SerializedSchemas.this.directory, this.baseName + ".ent");
            if (!file.isFile()) {
                return null;
            }
            return file;
        }

        public URL getGeneralEntitiesURL() {
            File file = this.getGeneralEntitiesFile();
            if (file == null) {
                return null;
            }
            return FileUtil.fileToURL(file);
        }

        public long getSerializationDate() {
            return this.serializationDate;
        }

        public File[] getLocalSources() {
            return this.localSources;
        }

        public URL[] getRemoteSources() {
            return this.remoteSources;
        }
    }
}

