/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.apps;

import com.jclark.xml.parse.AttributeDefinition;
import com.jclark.xml.parse.CommentEvent;
import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.EndDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.EndEntityReferenceEvent;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.EntityManagerImpl;
import com.jclark.xml.parse.MarkupDeclarationEvent;
import com.jclark.xml.parse.NotWellFormedException;
import com.jclark.xml.parse.ProcessingInstructionEvent;
import com.jclark.xml.parse.StartDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.StartEntityReferenceEvent;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.ParserImpl;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class Doctype
extends ApplicationImpl {
    private static final String[] attTypeNames = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", null, "NOTATION"};
    private final PrintWriter w;
    private int openEntityCount = 0;
    private boolean inDoctype = false;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length > 1) {
            System.err.println("usage: jview com.jclark.xml.apps.Doctype [file]");
            System.exit(1);
        }
        ParserImpl parserImpl = new ParserImpl();
        parserImpl.setApplication(new Doctype(new PrintWriter(new FileOutputStream(FileDescriptor.out))));
        try {
            parserImpl.parseDocument(stringArray.length == 0 ? EntityManagerImpl.openStandardInput() : EntityManagerImpl.openFile(stringArray[0]));
        }
        catch (NotWellFormedException notWellFormedException) {
            System.err.println(notWellFormedException.getMessage());
            System.exit(1);
        }
    }

    public Doctype(PrintWriter printWriter) {
        this.w = printWriter;
    }

    public void startDocumentTypeDeclaration(StartDocumentTypeDeclarationEvent startDocumentTypeDeclarationEvent) {
        DTD dTD = startDocumentTypeDeclarationEvent.getDTD();
        this.w.print("<!DOCTYPE " + dTD.getDocumentTypeName() + " ");
        Entity entity = dTD.getEntity((byte)1, "#DOCTYPE");
        if (entity != null) {
            this.writeExternalId(entity);
            this.w.println(" [");
        } else {
            this.w.println("[");
        }
        this.inDoctype = true;
    }

    public void endDocumentTypeDeclaration(EndDocumentTypeDeclarationEvent endDocumentTypeDeclarationEvent) {
        this.inDoctype = false;
        this.w.println("]>");
        this.w.flush();
    }

    public void startEntityReference(StartEntityReferenceEvent startEntityReferenceEvent) {
        if (this.inDoctype && this.openEntityCount++ == 0 && !startEntityReferenceEvent.getName().equals("#DOCTYPE")) {
            this.w.println("%" + startEntityReferenceEvent.getName() + ";");
        }
    }

    public void endEntityReference(EndEntityReferenceEvent endEntityReferenceEvent) {
        if (this.inDoctype) {
            --this.openEntityCount;
        }
    }

    public void processingInstruction(ProcessingInstructionEvent processingInstructionEvent) {
        if (this.openEntityCount == 0 && this.inDoctype) {
            this.w.println("<?" + processingInstructionEvent.getName() + " " + processingInstructionEvent.getInstruction() + "?>");
        }
    }

    public void comment(CommentEvent commentEvent) {
        if (this.openEntityCount == 0 && this.inDoctype) {
            this.w.println("<!--" + commentEvent.getComment() + "-->");
        }
    }

    public void markupDeclaration(MarkupDeclarationEvent markupDeclarationEvent) {
        if (this.openEntityCount != 0) {
            return;
        }
        String string = markupDeclarationEvent.getName();
        DTD dTD = markupDeclarationEvent.getDTD();
        switch (markupDeclarationEvent.getType()) {
            case 1: {
                this.writeElementDecl(dTD, string);
                break;
            }
            case 2: {
                this.writeEntityDecl(dTD, (byte)0, string);
                break;
            }
            case 3: {
                this.writeEntityDecl(dTD, (byte)1, string);
                break;
            }
            case 4: {
                this.writeEntityDecl(dTD, (byte)2, string);
                break;
            }
            case 0: {
                this.writeAttributeDef(dTD, string, markupDeclarationEvent.getAttributeName());
            }
        }
    }

    public void writeEntityDecl(DTD dTD, byte by, String string) {
        switch (by) {
            case 0: {
                this.w.print("<!ENTITY ");
                break;
            }
            case 1: {
                this.w.print("<!ENTITY % ");
                break;
            }
            case 2: {
                this.w.print("<!NOTATION ");
            }
        }
        this.w.print(string + " ");
        Entity entity = dTD.getEntity(by, string);
        String string2 = entity.getReplacementText();
        if (string2 == null) {
            this.writeExternalId(entity);
            if (by == 0 && (string = entity.getNotationName()) != null) {
                this.w.print(" NDATA " + string);
            }
        } else {
            this.w.print('\"');
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                switch (c) {
                    case '\r': 
                    case '\"': 
                    case '%': 
                    case '&': {
                        this.w.print("&#" + c + ";");
                        break;
                    }
                    default: {
                        this.w.print(c);
                    }
                }
                ++n;
            }
            this.w.print('\"');
        }
        this.w.println(">");
    }

    public void writeElementDecl(DTD dTD, String string) {
        this.w.println("<!ELEMENT " + string + " " + dTD.getElementType(string).getContentSpec() + ">");
    }

    public void writeAttributeDef(DTD dTD, String string, String string2) {
        Enumeration enumeration;
        AttributeDefinition attributeDefinition = dTD.getElementType(string).getAttributeDefinition(string2);
        this.w.print("<!ATTLIST " + string + " " + string2);
        String string3 = attTypeNames[attributeDefinition.getType()];
        if (string3 != null) {
            this.w.print(" " + string3);
        }
        if ((enumeration = attributeDefinition.allowedValues()) != null) {
            this.w.print(" (" + (String)enumeration.nextElement());
            while (enumeration.hasMoreElements()) {
                this.w.print((String)enumeration.nextElement());
            }
            this.w.print(")");
        }
        String string4 = attributeDefinition.getDefaultUnnormalizedValue();
        boolean bl = attributeDefinition.isRequired();
        if (string4 == null) {
            this.w.print(bl ? " #REQUIRED" : " #IMPLIED");
        } else {
            if (bl) {
                this.w.print(" #FIXED");
            }
            char c = string4.indexOf(34) < 0 ? (char)'\"' : '\'';
            this.w.print(" " + c + string4 + c);
        }
        this.w.println(">");
    }

    void writeExternalId(Entity entity) {
        String string = entity.getPublicId();
        String string2 = entity.getSystemId();
        if (string != null) {
            this.w.print("PUBLIC \"" + string + "\"");
        }
        if (string2 != null) {
            if (string == null) {
                this.w.print("SYSTEM");
            }
            this.w.print(' ');
            char c = string2.indexOf(34) < 0 ? (char)'\"' : '\'';
            this.w.print(c);
            this.w.print(string2);
            this.w.print(c);
        }
    }
}

