/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.jaxp;

import com.jclark.xml.jaxp.SAXParserImpl;
import com.jclark.xml.sax.SAX2Driver;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    private XMLReader dummyXMLReader = new SAX2Driver();
    private Hashtable features = new Hashtable();

    public SAXParser newSAXParser() throws ParserConfigurationException {
        SAXParserImpl sAXParserImpl;
        try {
            sAXParserImpl = new SAXParserImpl();
            XMLReader xMLReader = sAXParserImpl.getXMLReader();
            Enumeration enumeration = this.features.elements();
            while (enumeration.hasMoreElements()) {
                Feature feature = (Feature)enumeration.nextElement();
                xMLReader.setFeature(feature.name, feature.value);
            }
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        return sAXParserImpl;
    }

    public void setNamespaceAware(boolean bl) {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", bl);
        }
        catch (Exception exception) {}
    }

    public boolean isNamespaceAware() {
        boolean bl = false;
        try {
            bl = this.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (Exception exception) {}
        return bl;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.dummyXMLReader.setFeature(string, bl);
        this.features.put(string, new Feature(string, bl));
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.dummyXMLReader.getFeature(string);
    }

    private static class Feature {
        public String name;
        public boolean value;

        public Feature(String string, boolean bl) {
            this.name = string;
            this.value = bl;
        }
    }
}

