/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.sax;

import java.util.Enumeration;

public final class NamespaceStack
implements Enumeration {
    private static final int INITIAL_CAPACITY = 20;
    private String[][] stack;
    private int next;
    private String cachedPrefix;
    private String cachedURI;
    private int iter;

    public NamespaceStack() {
        this.reset();
    }

    public void reset() {
        this.stack = new String[20][];
        this.next = 0;
        this.cachedPrefix = null;
        this.cachedURI = null;
        this.pushContext();
        this.doDeclarePrefix("", "");
        this.doDeclarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public void pushContext() {
        if (this.next == this.stack.length) {
            String[][] stringArrayArray = new String[this.stack.length * 2][];
            System.arraycopy(this.stack, 0, stringArrayArray, 0, this.stack.length);
            this.stack = stringArrayArray;
        }
        this.stack[this.next++] = null;
    }

    public void popContext() {
        --this.next;
        if (this.stack[this.next] != null) {
            this.stack[this.next] = null;
            this.cachedPrefix = null;
        }
    }

    public boolean declarePrefix(String string, String string2) {
        if (string.length() > 0 && (string2.length() == 0 || !NamespaceStack.isNCName(string) || string.regionMatches(true, 0, "xml", 0, 3))) {
            return false;
        }
        this.doDeclarePrefix(string, string2);
        this.cachedPrefix = null;
        return true;
    }

    private void doDeclarePrefix(String string, String string2) {
        int n = this.next - 1;
        String[] stringArray = this.stack[n];
        if (stringArray == null) {
            stringArray = new String[]{string, string2};
        } else {
            int n2 = stringArray.length;
            String[] stringArray2 = new String[n2 + 2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray2[n2] = string;
            stringArray2[n2 + 1] = string2;
            stringArray = stringArray2;
        }
        this.stack[n] = stringArray;
    }

    public String[] processName(String string, String[] stringArray, boolean bl) {
        boolean bl2;
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n < 0) {
            string3 = "";
            string2 = string;
            bl2 = true;
        } else {
            if (n == 0 || n == string.length() - 1) {
                return null;
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            bl2 = false;
        }
        if (bl && bl2) {
            stringArray[0] = "";
            stringArray[1] = string2;
            stringArray[2] = string;
            return stringArray;
        }
        if (string3.equals(this.cachedPrefix)) {
            stringArray[0] = this.cachedURI;
            stringArray[1] = string2;
            stringArray[2] = string;
            return stringArray;
        }
        int n2 = this.next - 1;
        while (n2 >= 0) {
            String[] stringArray2 = this.stack[n2];
            if (stringArray2 != null) {
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    if (string3.equals(stringArray2[n4])) {
                        this.cachedPrefix = string3;
                        this.cachedURI = stringArray[0] = stringArray2[n4 + 1];
                        stringArray[1] = string2;
                        stringArray[2] = string;
                        return stringArray;
                    }
                    n4 += 2;
                }
            }
            --n2;
        }
        return null;
    }

    public Enumeration getDeclaredPrefixes() {
        this.iter = 0;
        return this;
    }

    public boolean hasMoreElements() {
        String[] stringArray = this.stack[this.next - 1];
        return stringArray != null && this.iter < stringArray.length;
    }

    public Object nextElement() {
        String[] stringArray = this.stack[this.next - 1];
        if (stringArray == null || this.iter >= stringArray.length) {
            return null;
        }
        String string = stringArray[this.iter];
        this.iter += 2;
        return string;
    }

    private static final boolean isNCName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        switch (c) {
            case '_': {
                break;
            }
            default: {
                if (Character.isLetter(c)) break;
                return false;
            }
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            switch (c) {
                case '-': 
                case '.': 
                case '_': {
                    break;
                }
                case '\u05bf': 
                case '\u05c4': 
                case '\u0670': 
                case '\u093c': 
                case '\u094d': 
                case '\u09bc': 
                case '\u09be': 
                case '\u09bf': 
                case '\u09d7': 
                case '\u0a02': 
                case '\u0a3c': 
                case '\u0a3e': 
                case '\u0a3f': 
                case '\u0abc': 
                case '\u0b3c': 
                case '\u0bd7': 
                case '\u0d57': 
                case '\u0e31': 
                case '\u0eb1': 
                case '\u0f35': 
                case '\u0f37': 
                case '\u0f39': 
                case '\u0f3e': 
                case '\u0f3f': 
                case '\u0f97': 
                case '\u0fb9': 
                case '\u20e1': 
                case '\u3099': 
                case '\u309a': {
                    break;
                }
                case '\u00b7': 
                case '\u02d0': 
                case '\u02d1': 
                case '\u0387': 
                case '\u0640': 
                case '\u0e46': 
                case '\u0ec6': 
                case '\u3005': {
                    break;
                }
                default: {
                    if (Character.isLetterOrDigit(c) || c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0483' && c <= '\u0486' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c >= '\u05c1' && c <= '\u05c2' || c >= '\u064b' && c <= '\u0652' || c >= '\u06d6' && c <= '\u06dc' || c >= '\u06dd' && c <= '\u06df' || c >= '\u06e0' && c <= '\u06e4' || c >= '\u06e7' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u0901' && c <= '\u0903' || c >= '\u093e' && c <= '\u094c' || c >= '\u0951' && c <= '\u0954' || c >= '\u0962' && c <= '\u0963' || c >= '\u0981' && c <= '\u0983' || c >= '\u09c0' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c >= '\u09e2' && c <= '\u09e3' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a70' && c <= '\u0a71' || c >= '\u0a81' && c <= '\u0a83' || c >= '\u0abe' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c >= '\u0b01' && c <= '\u0b03' || c >= '\u0b3e' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c >= '\u0e34' && c <= '\u0e3a' || c >= '\u0e47' && c <= '\u0e4e' || c >= '\u0eb4' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebc' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0f18' && c <= '\u0f19' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c >= '\u20d0' && c <= '\u20dc' || c >= '\u302a' && c <= '\u302f' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe') break;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

