/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.sax;

import com.jclark.util.Hashtable;
import com.jclark.xml.parse.ApplicationException;
import com.jclark.xml.parse.AttributeDefinition;
import com.jclark.xml.parse.CharacterDataEvent;
import com.jclark.xml.parse.CommentEvent;
import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.EndCdataSectionEvent;
import com.jclark.xml.parse.EndDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.EndElementEvent;
import com.jclark.xml.parse.EndEntityReferenceEvent;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.EntityManager;
import com.jclark.xml.parse.LocatedEvent;
import com.jclark.xml.parse.NotWellFormedException;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.ProcessingInstructionEvent;
import com.jclark.xml.parse.StartCdataSectionEvent;
import com.jclark.xml.parse.StartDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.StartEntityReferenceEvent;
import com.jclark.xml.parse.base.ApplicationImpl;
import com.jclark.xml.parse.base.Parser;
import com.jclark.xml.parse.base.ParserImpl;
import com.jclark.xml.sax.Locator;
import com.jclark.xml.sax.NamespaceStack;
import com.jclark.xml.sax.ReaderInputStream;
import com.jclark.xml.sax.WrapperException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAX2Driver
extends ApplicationImpl
implements XMLReader,
EntityManager,
Attributes,
Locator {
    private Parser parser = new ParserImpl();
    private NamespaceStack nsSupport = new NamespaceStack();
    private String[] nameParts = new String[3];
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    private static final String PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    private boolean namespacesFeature = true;
    private boolean namespacePrefixFeature = false;
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    private static final String DTD_EXTERNAL_SUBSET = "[dtd]";
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private DeclHandler declHandler;
    private LocatedEvent locatedEvent = null;
    private DTD dtd = null;
    private int dtdDeclarationStep = 0;
    private Hashtable declaredParameterEntities = new Hashtable();
    private Hashtable declaredElements = new Hashtable();
    private Hashtable declaredGeneralEntities = new Hashtable();
    private Hashtable declaredNotations = new Hashtable();
    private Stack entityReferenceStack = new Stack();
    private static final int INIT_DATA_BUF_SIZE = 80;
    private char[] dataBuf = new char[80];
    private int dataBufUsed = 0;
    private StartElementEvent elementEvent;
    private static final int UNKNOWN_INDEX = -2;
    private int idAttributeIndex;
    private int attributeCount;
    private int[] attributeIndexMap = new int[10];

    public SAX2Driver() {
        DefaultHandler defaultHandler = new DefaultHandler();
        this.entityResolver = defaultHandler;
        this.errorHandler = defaultHandler;
        this.dtdHandler = defaultHandler;
        this.contentHandler = defaultHandler;
        this.lexicalHandler = null;
        this.declHandler = null;
        this.parser.setApplication(this);
        this.parser.setEntityManager(this);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void startDocumentTypeDeclaration(StartDocumentTypeDeclarationEvent startDocumentTypeDeclarationEvent) throws SAXException {
        this.dtd = startDocumentTypeDeclarationEvent.getDTD();
        if (this.lexicalHandler != null) {
            String string;
            String string2;
            this.locatedEvent = null;
            Entity entity = this.dtd.getEntity((byte)1, "#DOCTYPE");
            if (entity != null) {
                string2 = entity.getPublicId();
                string = SAX2Driver.getEntitySystemId(entity);
            } else {
                string2 = null;
                string = null;
            }
            this.lexicalHandler.startDTD(this.dtd.getDocumentTypeName(), string2, string);
        }
    }

    private static final String getEntitySystemId(Entity entity) {
        String string;
        block2: {
            string = entity.getSystemId();
            if (string == null) break block2;
            try {
                string = new URL(entity.getBase(), string).toString();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return string;
    }

    public void endDocumentTypeDeclaration(EndDocumentTypeDeclarationEvent endDocumentTypeDeclarationEvent) throws SAXException {
        this.dtdDeclarations();
        if (this.lexicalHandler != null) {
            this.locatedEvent = null;
            this.lexicalHandler.endDTD();
        }
        this.dtd = null;
    }

    private void dtdDeclarations() throws SAXException {
        String string;
        Object object;
        String string2;
        Enumeration enumeration;
        if (this.dtdDeclarationStep >= 2) {
            return;
        }
        boolean bl = this.dtdDeclarationStep == 0;
        ++this.dtdDeclarationStep;
        if (this.declHandler != null) {
            enumeration = this.dtd.entityNames((byte)1);
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (bl) {
                    this.declaredParameterEntities.put(string2, string2);
                } else if (this.declaredParameterEntities.get(string2) != null) continue;
                object = this.dtd.getEntity((byte)1, string2);
                string = object.getReplacementText();
                if (string == null) {
                    this.declHandler.externalEntityDecl("%" + string2, object.getPublicId(), SAX2Driver.getEntitySystemId((Entity)object));
                    continue;
                }
                this.declHandler.internalEntityDecl("%" + string2, string);
            }
            enumeration = this.dtd.elementTypeNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (bl) {
                    this.declaredElements.put(string2, string2);
                } else if (this.declaredElements.get(string2) != null) continue;
                object = this.dtd.getElementType(string2);
                string = object.getContentSpec();
                if (string != null) {
                    this.declHandler.elementDecl(string2, string);
                }
                Enumeration enumeration2 = object.attributeNames();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    AttributeDefinition attributeDefinition = object.getAttributeDefinition(string3);
                    StringBuffer stringBuffer = new StringBuffer();
                    switch (attributeDefinition.getType()) {
                        case 0: {
                            stringBuffer.append("CDATA");
                            break;
                        }
                        case 1: {
                            stringBuffer.append("ID");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("IDREF");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("IDREFS");
                            break;
                        }
                        case 4: {
                            stringBuffer.append("ENTITY");
                            break;
                        }
                        case 5: {
                            stringBuffer.append("ENTITIES");
                            break;
                        }
                        case 6: {
                            stringBuffer.append("NMTOKEN");
                            break;
                        }
                        case 7: {
                            stringBuffer.append("NMTOKENS");
                            break;
                        }
                        case 9: {
                            stringBuffer.append("NOTATION ");
                        }
                    }
                    Enumeration enumeration3 = attributeDefinition.allowedValues();
                    if (enumeration3 != null) {
                        stringBuffer.append('(');
                        stringBuffer.append((String)enumeration3.nextElement());
                        while (enumeration3.hasMoreElements()) {
                            stringBuffer.append('|');
                            stringBuffer.append((String)enumeration3.nextElement());
                        }
                        stringBuffer.append(')');
                    }
                    String string4 = attributeDefinition.getDefaultValue();
                    String string5 = attributeDefinition.isRequired() ? (string4 == null ? "#REQUIRED" : "#FIXED") : (string4 == null ? "#IMPLIED" : null);
                    this.declHandler.attributeDecl(string2, string3, stringBuffer.toString(), string5, string4);
                }
            }
            enumeration = this.dtd.entityNames((byte)0);
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                object = this.dtd.getEntity((byte)0, string2);
                if (object.getNotationName() != null) continue;
                if (bl) {
                    this.declaredGeneralEntities.put(string2, string2);
                } else if (this.declaredGeneralEntities.get(string2) != null) continue;
                string = object.getReplacementText();
                if (string == null) {
                    this.declHandler.externalEntityDecl(string2, object.getPublicId(), SAX2Driver.getEntitySystemId((Entity)object));
                    continue;
                }
                this.declHandler.internalEntityDecl(string2, string);
            }
        }
        if (this.dtdHandler != null) {
            enumeration = this.dtd.entityNames((byte)2);
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (bl) {
                    this.declaredNotations.put(string2, string2);
                } else if (this.declaredNotations.get(string2) != null) continue;
                object = this.dtd.getEntity((byte)2, string2);
                this.dtdHandler.notationDecl(string2, object.getPublicId(), SAX2Driver.getEntitySystemId((Entity)object));
            }
            enumeration = this.dtd.entityNames((byte)0);
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                object = this.dtd.getEntity((byte)0, string2);
                string = object.getNotationName();
                if (string == null) continue;
                if (bl) {
                    this.declaredGeneralEntities.put(string2, string2);
                } else if (this.declaredGeneralEntities.get(string2) != null) continue;
                this.dtdHandler.unparsedEntityDecl(string2, object.getPublicId(), SAX2Driver.getEntitySystemId((Entity)object), string);
            }
        }
    }

    public void comment(CommentEvent commentEvent) throws SAXException {
        this.flushData();
        if (this.lexicalHandler != null) {
            this.locatedEvent = commentEvent;
            char[] cArray = commentEvent.getComment().toCharArray();
            this.lexicalHandler.comment(cArray, 0, cArray.length);
            this.locatedEvent = null;
        }
    }

    public void processingInstruction(ProcessingInstructionEvent processingInstructionEvent) throws SAXException {
        this.flushData();
        this.locatedEvent = processingInstructionEvent;
        this.contentHandler.processingInstruction(processingInstructionEvent.getName(), processingInstructionEvent.getInstruction());
        this.locatedEvent = null;
    }

    public void startEntityReference(StartEntityReferenceEvent startEntityReferenceEvent) throws SAXException {
        this.flushData();
        if (this.lexicalHandler != null) {
            this.locatedEvent = null;
            String string = startEntityReferenceEvent.getName();
            if (string.equals("#DOCTYPE")) {
                string = DTD_EXTERNAL_SUBSET;
            }
            this.entityReferenceStack.push(string);
            if (string == DTD_EXTERNAL_SUBSET) {
                this.dtdDeclarations();
            }
            this.lexicalHandler.startEntity(string);
        }
    }

    public void endEntityReference(EndEntityReferenceEvent endEntityReferenceEvent) throws SAXException {
        this.flushData();
        if (this.lexicalHandler != null) {
            this.locatedEvent = null;
            String string = (String)this.entityReferenceStack.peek();
            this.entityReferenceStack.pop();
            if (string == DTD_EXTERNAL_SUBSET) {
                this.dtdDeclarations();
            }
            this.lexicalHandler.endEntity(string);
        }
    }

    public void startCdataSection(StartCdataSectionEvent startCdataSectionEvent) throws SAXException {
        this.flushData();
        if (this.lexicalHandler != null) {
            this.locatedEvent = null;
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCdataSection(EndCdataSectionEvent endCdataSectionEvent) throws SAXException {
        this.flushData();
        if (this.lexicalHandler != null) {
            this.locatedEvent = null;
            this.lexicalHandler.endCDATA();
        }
    }

    public void characterData(CharacterDataEvent characterDataEvent) {
        int n = characterDataEvent.getLengthMax() + this.dataBufUsed;
        if (n > this.dataBuf.length) {
            int n2 = this.dataBuf.length << 1;
            while (n > n2) {
                n2 <<= 1;
            }
            char[] cArray = this.dataBuf;
            this.dataBuf = new char[n2];
            if (this.dataBufUsed > 0) {
                System.arraycopy(cArray, 0, this.dataBuf, 0, this.dataBufUsed);
            }
        }
        this.dataBufUsed += characterDataEvent.copyChars(this.dataBuf, this.dataBufUsed);
    }

    private final void flushData() throws SAXException {
        if (this.dataBufUsed > 0) {
            this.contentHandler.characters(this.dataBuf, 0, this.dataBufUsed);
            this.dataBufUsed = 0;
        }
    }

    public void startElement(StartElementEvent startElementEvent) throws SAXException {
        int n;
        this.flushData();
        this.locatedEvent = startElementEvent;
        this.elementEvent = startElementEvent;
        this.idAttributeIndex = -2;
        int n2 = startElementEvent.getAttributeCount();
        if (this.attributeIndexMap.length < n2) {
            this.attributeIndexMap = new int[Math.max(n2, 2 * this.attributeIndexMap.length)];
            if (!this.namespacesFeature) {
                n = 0;
                while (n < this.attributeIndexMap.length) {
                    this.attributeIndexMap[n] = n;
                    ++n;
                }
            }
        }
        if (this.namespacesFeature) {
            String string;
            this.nsSupport.pushContext();
            this.attributeCount = 0;
            n = 0;
            while (n < n2) {
                string = startElementEvent.getAttributeName(n);
                if (string.indexOf("xmlns") == 0) {
                    int n3 = string.length();
                    String string2 = startElementEvent.getAttributeValue(n);
                    if (n3 == 5) {
                        this.nsSupport.declarePrefix("", string2);
                        this.contentHandler.startPrefixMapping("", string2);
                    } else if (string.charAt(5) == ':') {
                        String string3 = n3 > 6 ? string.substring(6) : "";
                        this.nsSupport.declarePrefix(string3, string2);
                        this.contentHandler.startPrefixMapping(string3, string2);
                    }
                    if (this.namespacePrefixFeature) {
                        this.attributeIndexMap[this.attributeCount++] = n;
                    }
                } else {
                    this.attributeIndexMap[this.attributeCount++] = n;
                }
                ++n;
            }
            string = startElementEvent.getName();
            this.nameParts[1] = null;
            this.nameParts[0] = null;
            this.nsSupport.processName(string, this.nameParts, false);
            this.contentHandler.startElement(this.nameParts[0], this.nameParts[1], string, this);
        } else {
            this.attributeCount = n2;
            this.contentHandler.startElement("", "", startElementEvent.getName(), this);
        }
        this.elementEvent = null;
        this.locatedEvent = null;
    }

    public void endElement(EndElementEvent endElementEvent) throws SAXException {
        this.flushData();
        if (this.namespacesFeature) {
            String string = endElementEvent.getName();
            this.nameParts[1] = null;
            this.nameParts[0] = null;
            this.nsSupport.processName(string, this.nameParts, false);
            this.contentHandler.endElement(this.nameParts[0], this.nameParts[1], string);
            Enumeration enumeration = this.nsSupport.getDeclaredPrefixes();
            while (enumeration.hasMoreElements()) {
                this.contentHandler.endPrefixMapping((String)enumeration.nextElement());
            }
            this.nsSupport.popContext();
        } else {
            this.contentHandler.endElement("", "", endElementEvent.getName());
        }
    }

    public void endDocument() throws SAXException {
        this.flushData();
        this.contentHandler.endDocument();
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            this.namespacesFeature = bl;
        } else if (NAMESPACE_PREFIX_FEATURE.equals(string)) {
            this.namespacePrefixFeature = bl;
        } else if (VALIDATION_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("'" + string + "'=" + bl + " feature not supported");
            }
        } else if (EXTERNAL_GENERAL_ENTITIES_FEATURE.equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException("'" + string + "'=" + bl + " feature not supported");
            }
        } else if (EXTERNAL_PARAMETER_ENTITIES_FEATURE.equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException("'" + string + "'=" + bl + " feature not supported");
            }
        } else if (PARAMETER_ENTITIES_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("'" + string + "'=" + bl + " feature not supported");
            }
        } else {
            throw new SAXNotRecognizedException("'" + string + "' feature not recognized");
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            return this.namespacesFeature;
        }
        if (NAMESPACE_PREFIX_FEATURE.equals(string)) {
            return this.namespacePrefixFeature;
        }
        if (VALIDATION_FEATURE.equals(string)) {
            return false;
        }
        if (EXTERNAL_GENERAL_ENTITIES_FEATURE.equals(string)) {
            return true;
        }
        if (EXTERNAL_PARAMETER_ENTITIES_FEATURE.equals(string)) {
            return true;
        }
        if (PARAMETER_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException("'" + string + "' feature not recognized");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            this.lexicalHandler = (LexicalHandler)object;
        } else if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            this.declHandler = (DeclHandler)object;
        } else {
            throw new SAXNotRecognizedException("'" + string + "' property not recognized");
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            return this.lexicalHandler;
        }
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            return this.declHandler;
        }
        throw new SAXNotRecognizedException("'" + string + "' property not recognized");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (!this.namespacesFeature) {
            int n = 0;
            while (n < this.attributeIndexMap.length) {
                this.attributeIndexMap[n] = n;
                ++n;
            }
        }
        this.contentHandler.setDocumentLocator(this);
        try {
            try {
                this.parser.parseDocument(this.openInputSource(inputSource));
            }
            catch (WrapperException wrapperException) {
                throw wrapperException.getWrapped();
            }
            catch (NotWellFormedException notWellFormedException) {
                SAXParseException sAXParseException = new SAXParseException(notWellFormedException.getMessageWithoutLocation(), null, notWellFormedException.getEntityLocation(), notWellFormedException.getLineNumber(), notWellFormedException.getColumnNumber());
                this.errorHandler.fatalError(sAXParseException);
                throw sAXParseException;
            }
            catch (ApplicationException applicationException) {
                throw (SAXException)applicationException.getException();
            }
            Object var6_4 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    private void cleanUp() {
        this.locatedEvent = null;
        this.nsSupport.reset();
        this.dtd = null;
        this.dtdDeclarationStep = 0;
        this.declaredParameterEntities.clear();
        this.declaredElements.clear();
        this.declaredGeneralEntities.clear();
        this.declaredNotations.clear();
        while (!this.entityReferenceStack.empty()) {
            this.entityReferenceStack.pop();
        }
        this.dataBufUsed = 0;
    }

    public OpenEntity open(String string, URL uRL, String string2) throws IOException {
        Object object;
        if (this.entityResolver != null) {
            try {
                object = string;
                try {
                    object = new URL(uRL, string).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                InputSource inputSource = this.entityResolver.resolveEntity(string2, (String)object);
                if (inputSource != null) {
                    return this.openInputSource(inputSource);
                }
            }
            catch (SAXException sAXException) {
                throw new WrapperException(sAXException);
            }
        }
        object = new URL(uRL, string);
        return new OpenEntity(((URL)object).openStream(), ((URL)object).toString(), (URL)object, null);
    }

    private OpenEntity openInputSource(InputSource inputSource) throws IOException {
        String string;
        InputStream inputStream;
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            inputStream = new ReaderInputStream(reader);
            string = "UTF-16";
        } else {
            inputStream = inputSource.getByteStream();
            string = inputSource.getEncoding();
        }
        String string2 = inputSource.getSystemId();
        URL uRL = null;
        if (inputStream == null) {
            if (string2 == null) {
                return null;
            }
            uRL = SAX2Driver.systemIdToURL(string2);
            inputStream = uRL.openStream();
        } else if (string2 != null) {
            uRL = SAX2Driver.systemIdToURL(string2);
        } else {
            string2 = "(internal)";
        }
        return new OpenEntity(inputStream, string2, uRL, string);
    }

    private static final URL systemIdToURL(String string) {
        URL uRL;
        block4: {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL != null) break block4;
            try {
                uRL = new File(string).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return uRL;
    }

    public int getLength() {
        return this.attributeCount;
    }

    public String getQName(int n) {
        if (n < 0 || n >= this.attributeCount) {
            return null;
        }
        return this.elementEvent.getAttributeName(this.attributeIndexMap[n]);
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.attributeCount) {
            return null;
        }
        return this.elementEvent.getAttributeValue(this.attributeIndexMap[n]);
    }

    public String getType(int n) {
        if (n < 0 || n >= this.attributeCount) {
            return null;
        }
        if (this.idAttributeIndex == -2) {
            this.idAttributeIndex = this.elementEvent.getIdAttributeIndex();
        }
        return this.attributeIndexMap[n] == this.idAttributeIndex ? "ID" : "CDATA";
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.attributeCount) {
            return null;
        }
        if (!this.namespacesFeature) {
            return "";
        }
        String string = this.elementEvent.getAttributeName(this.attributeIndexMap[n]);
        this.nameParts[1] = null;
        this.nameParts[0] = null;
        if (!this.namespacePrefixFeature || string.indexOf("xmlns") < 0) {
            this.nsSupport.processName(string, this.nameParts, true);
        }
        return this.nameParts[0];
    }

    public String getLocalName(int n) {
        if (n < 0 || n >= this.attributeCount) {
            return null;
        }
        if (!this.namespacesFeature) {
            return "";
        }
        String string = this.elementEvent.getAttributeName(this.attributeIndexMap[n]);
        this.nameParts[1] = null;
        this.nameParts[0] = null;
        if (!this.namespacePrefixFeature || string.indexOf("xmlns") < 0) {
            this.nsSupport.processName(string, this.nameParts, true);
        }
        return this.nameParts[1];
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.attributeCount) {
            String string2 = this.elementEvent.getAttributeName(this.attributeIndexMap[n]);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getValue(String string) {
        return this.elementEvent.getAttributeValue(string);
    }

    public String getType(String string) {
        if (this.idAttributeIndex == -2) {
            this.idAttributeIndex = this.elementEvent.getIdAttributeIndex();
        }
        if (this.idAttributeIndex >= 0 && this.elementEvent.getAttributeName(this.idAttributeIndex).equals(string)) {
            return "ID";
        }
        return "CDATA";
    }

    public int getIndex(String string, String string2) {
        if (!this.namespacesFeature) {
            return -1;
        }
        int n = 0;
        while (n < this.attributeCount) {
            String string3 = this.elementEvent.getAttributeName(this.attributeIndexMap[n]);
            this.nameParts[1] = null;
            this.nameParts[0] = null;
            if (!this.namespacePrefixFeature || string3.indexOf("xmlns") < 0) {
                this.nsSupport.processName(string3, this.nameParts, true);
            }
            if (string.equals(this.nameParts[0]) && string2.equals(this.nameParts[1])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getSystemId() {
        if (this.locatedEvent == null) {
            return null;
        }
        return this.locatedEvent.getLocation().getEntityLocation();
    }

    public URL getURL() {
        if (this.locatedEvent == null) {
            return null;
        }
        return this.locatedEvent.getLocation().getEntityBase();
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        if (this.locatedEvent == null) {
            return -1;
        }
        return this.locatedEvent.getLocation().getLineNumber();
    }

    public int getColumnNumber() {
        if (this.locatedEvent == null) {
            return -1;
        }
        int n = this.locatedEvent.getLocation().getColumnNumber();
        if (n < 0) {
            return n;
        }
        return n + 1;
    }

    public long getByteIndex() {
        if (this.locatedEvent == null) {
            return -1L;
        }
        return this.locatedEvent.getLocation().getByteIndex();
    }
}

